/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.serial.io;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidObjectException;
import java.io.NotActiveException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectInputValidation;
import java.io.ObjectStreamClass;
import java.io.StreamCorruptedException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.Arrays;
import org.jboss.serial.classmetamodel.ClassResolver;
import org.jboss.serial.objectmetamodel.DataContainer;
import org.jboss.serial.objectmetamodel.DataContainerConstants;
import org.jboss.serial.util.ClassMetaConsts;
import org.jboss.serial.util.StringUtil;
import org.jboss.serial.util.StringUtilBuffer;

public class JBossObjectInputStream
extends ObjectInputStream
implements DataContainerConstants {
    InputStream is;
    DataInputStream dis;
    DataContainer container;
    ClassLoader classLoader;
    StringUtilBuffer buffer;
    private static Constructor constructorObjectStreamClass;
    private static Field setNameField;
    ClassResolver resolver = new ClassResolver(){

        public Class resolveClass(String name) throws ClassNotFoundException {
            if (constructorObjectStreamClass != null) {
                try {
                    ObjectStreamClass streamClass = (ObjectStreamClass)constructorObjectStreamClass.newInstance(ClassMetaConsts.EMPTY_OBJECT_ARRAY);
                    setNameField.set(streamClass, name);
                    return JBossObjectInputStream.this.resolveClass(streamClass);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return null;
                }
            }
            return null;
        }
    };

    public JBossObjectInputStream(InputStream is) throws IOException {
        this(is, Thread.currentThread().getContextClassLoader());
    }

    public JBossObjectInputStream(InputStream is, StringUtilBuffer buffer) throws IOException {
        this(is, Thread.currentThread().getContextClassLoader(), buffer);
    }

    public JBossObjectInputStream(InputStream is, ClassLoader loader) throws IOException {
        this(is, loader, StringUtil.getThreadLocalBuffer());
    }

    public JBossObjectInputStream(InputStream is, ClassLoader loader, StringUtilBuffer buffer) throws IOException {
        this.buffer = buffer;
        if (is != null) {
            this.checkSignature(is);
            this.is = is;
            this.dis = is instanceof DataInputStream ? (DataInputStream)is : new DataInputStream(is);
        }
        this.classLoader = loader;
    }

    private void checkSignature(InputStream is) throws IOException {
        byte[] signature = new byte[openSign.length];
        is.read(signature);
        if (!Arrays.equals(signature, openSign)) {
            throw new IOException("Mismatch version of JBossSerialization signature");
        }
    }

    protected Class resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
        return this.classLoader.loadClass(desc.getName());
    }

    public Object readObjectUsingDataContainer() throws IOException, ClassNotFoundException {
        DataContainer container = new DataContainer(this.classLoader, false, this.buffer);
        container.setClassResolver(this.resolver);
        container.setBuffer(this.buffer);
        container.loadData(this.dis);
        ObjectInput input = container.getInput();
        return input.readObject();
    }

    public Object readObjectOverride() throws IOException, ClassNotFoundException {
        DataContainer container = new DataContainer(this.classLoader, false, this.buffer);
        container.setClassResolver(this.resolver);
        container.setBuffer(this.buffer);
        ObjectInput input = container.getDirectInput(this.dis);
        return input.readObject();
    }

    public Object readUnshared() throws IOException, ClassNotFoundException {
        return this.readObjectOverride();
    }

    public void defaultReadObject() throws IOException, ClassNotFoundException {
    }

    public void registerValidation(ObjectInputValidation obj, int prio) throws NotActiveException, InvalidObjectException {
    }

    protected void readStreamHeader() throws IOException, StreamCorruptedException {
    }

    protected ObjectStreamClass readClassDescriptor() throws IOException, ClassNotFoundException {
        return null;
    }

    public int read() throws IOException {
        return this.dis.read();
    }

    public int read(byte[] buf, int off, int len) throws IOException {
        return this.dis.read(buf, off, len);
    }

    public int available() throws IOException {
        return 1;
    }

    public void close() throws IOException {
    }

    public boolean readBoolean() throws IOException {
        return this.dis.readBoolean();
    }

    public byte readByte() throws IOException {
        return this.dis.readByte();
    }

    public int readUnsignedByte() throws IOException {
        return this.dis.readUnsignedByte();
    }

    public char readChar() throws IOException {
        return this.dis.readChar();
    }

    public short readShort() throws IOException {
        return this.dis.readShort();
    }

    public int readUnsignedShort() throws IOException {
        return this.dis.readUnsignedShort();
    }

    public int readInt() throws IOException {
        return this.dis.readInt();
    }

    public long readLong() throws IOException {
        return this.dis.readLong();
    }

    public float readFloat() throws IOException {
        return this.dis.readFloat();
    }

    public double readDouble() throws IOException {
        return this.dis.readDouble();
    }

    public void readFully(byte[] buf) throws IOException {
        this.dis.readFully(buf);
    }

    public void readFully(byte[] buf, int off, int len) throws IOException {
        this.dis.readFully(buf, off, len);
    }

    public int skipBytes(int len) throws IOException {
        return this.dis.skipBytes(len);
    }

    public String readLine() throws IOException {
        return this.dis.readLine();
    }

    public String readUTF() throws IOException {
        return StringUtil.readString(this.dis, this.buffer);
    }

    public int read(byte[] b) throws IOException {
        return this.dis.read(b);
    }

    public long skip(long n) throws IOException {
        return this.dis.skip(n);
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    static {
        try {
            constructorObjectStreamClass = ObjectStreamClass.class.getDeclaredConstructor(ClassMetaConsts.EMPTY_CLASS_ARRY);
            constructorObjectStreamClass.setAccessible(true);
            setNameField = ObjectStreamClass.class.getDeclaredField("name");
            setNameField.setAccessible(true);
        }
        catch (Exception e) {
            constructorObjectStreamClass = null;
            setNameField = null;
            e.printStackTrace();
        }
    }
}

