/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xb.binding.sunday;

import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import org.jboss.logging.Logger;
import org.jboss.util.Classes;
import org.jboss.xb.binding.AbstractMarshaller;
import org.jboss.xb.binding.AttributesImpl;
import org.jboss.xb.binding.Constants;
import org.jboss.xb.binding.Content;
import org.jboss.xb.binding.ContentWriter;
import org.jboss.xb.binding.JBossXBRuntimeException;
import org.jboss.xb.binding.MarshallingContext;
import org.jboss.xb.binding.ObjectLocalMarshaller;
import org.jboss.xb.binding.ObjectModelProvider;
import org.jboss.xb.binding.SimpleTypeBindings;
import org.jboss.xb.binding.Util;
import org.jboss.xb.binding.metadata.CharactersMetaData;
import org.jboss.xb.binding.metadata.PropertyMetaData;
import org.jboss.xb.binding.metadata.marshalling.FieldBinding;
import org.jboss.xb.binding.sunday.unmarshalling.AllBinding;
import org.jboss.xb.binding.sunday.unmarshalling.AttributeBinding;
import org.jboss.xb.binding.sunday.unmarshalling.ChoiceBinding;
import org.jboss.xb.binding.sunday.unmarshalling.ElementBinding;
import org.jboss.xb.binding.sunday.unmarshalling.ModelGroupBinding;
import org.jboss.xb.binding.sunday.unmarshalling.ParticleBinding;
import org.jboss.xb.binding.sunday.unmarshalling.SchemaBinding;
import org.jboss.xb.binding.sunday.unmarshalling.SchemaBindingResolver;
import org.jboss.xb.binding.sunday.unmarshalling.TermBinding;
import org.jboss.xb.binding.sunday.unmarshalling.TypeBinding;
import org.jboss.xb.binding.sunday.unmarshalling.WildcardBinding;
import org.jboss.xb.binding.sunday.unmarshalling.XsdBinder;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class MarshallerImpl
extends AbstractMarshaller {
    private static final Logger log = Logger.getLogger(MarshallerImpl.class);
    private AbstractMarshaller.Stack stack = new AbstractMarshaller.StackImpl();
    private Object root;
    private boolean supportNil = true;
    private boolean ignoreUnresolvedWildcard;
    private QName rootTypeQName;
    private SchemaBindingResolver schemaResolver;
    private SchemaBinding schema;
    private MarshallingContext ctx = new MarshallingContext(){
        private ContentHandler ch;

        public FieldBinding getFieldBinding() {
            throw new UnsupportedOperationException("getFieldBinding is not implemented.");
        }

        public boolean isAttributeRequired() {
            throw new UnsupportedOperationException();
        }

        public boolean isTypeComplex() {
            throw new UnsupportedOperationException();
        }

        public String getSimpleContentProperty() {
            throw new UnsupportedOperationException();
        }

        public ContentHandler getContentHandler() {
            if (this.ch == null) {
                this.ch = new AbstractMarshaller.ContentHandlerAdaptor();
            }
            return this.ch;
        }
    };

    public boolean isIgnoreUnresolvedWildcard() {
        return this.ignoreUnresolvedWildcard;
    }

    public void setIgnoreUnresolvedWildcard(boolean ignoreUnresolvedWildcard) {
        this.ignoreUnresolvedWildcard = ignoreUnresolvedWildcard;
    }

    public SchemaBindingResolver getSchemaResolver() {
        return this.schemaResolver;
    }

    public void setSchemaResolver(SchemaBindingResolver schemaResolver) {
        this.schemaResolver = schemaResolver;
    }

    public QName getRootTypeQName() {
        return this.rootTypeQName;
    }

    public void setRootTypeQName(QName rootTypeQName) {
        this.rootTypeQName = rootTypeQName;
    }

    public boolean isSupportNil() {
        return this.supportNil;
    }

    public void setSupportNil(boolean supportNil) {
        this.supportNil = supportNil;
    }

    public void addAttribute(String prefix, String localName, String type, String value) {
    }

    public void marshal(Reader xsdReader, ObjectModelProvider provider, Object root, Writer writer) throws IOException, SAXException, ParserConfigurationException {
        SchemaBinding model = XsdBinder.bind(xsdReader, null, this.schemaResolver);
        this.marshallInternal(root, model, writer);
    }

    public void marshal(String xsdURL, ObjectModelProvider provider, Object root, Writer writer) throws IOException, SAXException {
        SchemaBinding model = XsdBinder.bind(xsdURL, this.schemaResolver);
        this.marshallInternal(root, model, writer);
    }

    public void marshal(SchemaBinding model, ObjectModelProvider provider, Object root, Writer writer) throws IOException, SAXException {
        this.marshallInternal(root, model, writer);
    }

    private void marshallInternal(Object root, SchemaBinding schema, Writer writer) throws IOException, SAXException {
        if (schema == null) {
            throw new JBossXBRuntimeException("XSModel is not available!");
        }
        this.schema = schema;
        this.root = root;
        this.content.startDocument();
        if (this.rootTypeQName != null) {
            if (this.rootQNames.isEmpty()) {
                throw new JBossXBRuntimeException("If type name (" + this.rootTypeQName + ") for the root element is specified then the name for the root element is required!");
            }
            QName rootQName = (QName)this.rootQNames.get(0);
            TypeBinding type = schema.getType(this.rootTypeQName);
            if (type == null) {
                throw new JBossXBRuntimeException("Global type definition is not found: " + this.rootTypeQName);
            }
            if (MarshallerImpl.isArrayWrapper(type)) {
                this.stack.push(root);
                this.marshalComplexType(rootQName.getNamespaceURI(), rootQName.getLocalPart(), type, true, false);
                this.stack.pop();
            } else {
                ElementBinding element = new ElementBinding(schema, rootQName, type);
                this.marshalElementOccurence(element, root, false, true);
            }
        } else if (this.rootQNames.isEmpty()) {
            Iterator elements = schema.getElements();
            if (!elements.hasNext()) {
                throw new JBossXBRuntimeException("The schema doesn't contain global element declarations.");
            }
            while (elements.hasNext()) {
                ElementBinding element = (ElementBinding)elements.next();
                this.marshalElementOccurence(element, root, true, true);
            }
        } else {
            for (int i = 0; i < this.rootQNames.size(); ++i) {
                QName qName = (QName)this.rootQNames.get(i);
                ElementBinding element = schema.getElement(qName);
                if (element == null) {
                    Iterator components = schema.getElements();
                    String roots = "";
                    int j = 0;
                    while (components.hasNext()) {
                        ElementBinding xsObject = (ElementBinding)components.next();
                        if (j > 0) {
                            roots = roots + ", ";
                        }
                        roots = roots + xsObject.getQName();
                        ++j;
                    }
                    throw new IllegalStateException("Root element not found: " + qName + " among " + roots);
                }
                this.marshalElementOccurence(element, root, true, true);
            }
        }
        this.content.endDocument();
        this.writeXmlVersion(writer);
        ContentWriter contentWriter = new ContentWriter(writer, this.propertyIsTrueOrNotSet("org.jboss.xml.binding.marshalling.indent"));
        this.content.handleContent(contentWriter);
        if (log.isTraceEnabled()) {
            StringWriter traceWriter = new StringWriter();
            contentWriter = new ContentWriter(traceWriter, this.propertyIsTrueOrNotSet("org.jboss.xml.binding.marshalling.indent"));
            this.content.handleContent(contentWriter);
            log.trace("marshalled:\n" + traceWriter.getBuffer().toString());
        }
    }

    private boolean marshalElementOccurence(ElementBinding element, Object value, boolean optional, boolean declareNs) {
        QName xsiTypeQName = null;
        TypeBinding xsiType = null;
        if (value != null) {
            QName typeQName = element.getType().getQName();
            xsiTypeQName = (QName)this.cls2TypeMap.get(value.getClass());
            if (!(xsiTypeQName == null || typeQName.getLocalPart().equals(xsiTypeQName.getLocalPart()) && typeQName.getNamespaceURI().equals(xsiTypeQName.getNamespaceURI()))) {
                if (log.isTraceEnabled()) {
                    log.trace(value.getClass() + " is mapped to xsi:type " + xsiTypeQName);
                }
                if ((xsiType = this.schema.getType(xsiTypeQName)) == null) {
                    log.warn("Class " + value.getClass() + " is mapped to type " + xsiTypeQName + " but the type is not found in schema.");
                }
            }
        }
        this.stack.push(value);
        boolean marshalled = this.marshalElement(element, xsiType, optional, declareNs);
        this.stack.pop();
        return marshalled;
    }

    private boolean marshalElement(ElementBinding element, TypeBinding xsiType, boolean optional, boolean declareNs) {
        boolean trace;
        Object value = this.stack.peek();
        boolean nillable = element.isNillable();
        boolean result = value != null || value == null && (optional || nillable);
        String elementNs = element.getQName().getNamespaceURI();
        String elementLocal = element.getQName().getLocalPart();
        boolean bl = trace = log.isTraceEnabled() && result;
        if (trace) {
            String prefix = this.getPrefix(elementNs);
            log.trace("started element ns=" + elementNs + ", local=" + elementLocal + ", prefix=" + prefix);
        }
        if (value != null) {
            boolean declareXsiType = xsiType != null;
            this.marshalElementType(elementNs, elementLocal, declareXsiType ? xsiType : element.getType(), declareNs, declareXsiType, nillable);
        } else if (nillable) {
            this.writeNillable(elementNs, elementLocal, nillable);
        }
        if (trace) {
            log.trace("finished element ns=" + elementNs + ", local=" + elementLocal);
        }
        return result;
    }

    private void marshalElementType(String elementNs, String elementLocal, TypeBinding type, boolean declareNs, boolean declareXsiType, boolean nillable) {
        if (type.isSimple()) {
            this.marshalSimpleType(elementNs, elementLocal, type, declareNs, declareXsiType, nillable);
        } else {
            this.marshalComplexType(elementNs, elementLocal, type, declareNs, declareXsiType);
        }
    }

    private void marshalSimpleType(String elementUri, String elementLocal, TypeBinding type, boolean declareNs, boolean declareXsiType, boolean nillable) {
        Object value = this.stack.peek();
        if (value != null) {
            boolean genPrefix;
            String prefix = this.getPrefix(elementUri);
            boolean bl = genPrefix = prefix == null && elementUri != null && elementUri.length() > 0;
            if (genPrefix) {
                prefix = "ns_" + elementLocal;
            }
            AttributesImpl attrs = null;
            String typeName = type.getQName().getLocalPart();
            if ("QName".equals(typeName) || "NOTATION".equals(typeName) || type.getItemType() != null && ("QName".equals(type.getItemType().getQName().getLocalPart()) || "NOTATION".equals(type.getItemType().getQName().getLocalPart()))) {
                attrs = new AttributesImpl(5);
            }
            String marshalled = this.marshalCharacters(elementUri, prefix, type, value, attrs);
            if ((declareNs || declareXsiType) && !this.prefixByUri.isEmpty()) {
                if (attrs == null) {
                    attrs = new AttributesImpl(this.prefixByUri.size() + 1);
                }
                this.declareNs(attrs);
            }
            if (declareXsiType) {
                this.declareXsiType(type.getQName(), attrs);
            }
            if (genPrefix) {
                if (attrs == null) {
                    attrs = new AttributesImpl(1);
                }
                attrs.add(null, prefix, "xmlns:" + prefix, null, elementUri);
            }
            String qName = MarshallerImpl.createQName(prefix, elementLocal);
            this.content.startElement(elementUri, elementLocal, qName, attrs);
            this.content.characters(marshalled.toCharArray(), 0, marshalled.length());
            this.content.endElement(elementUri, elementLocal, qName);
        } else {
            this.writeNillable(elementUri, elementLocal, nillable);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void marshalComplexType(String elementNsUri, String elementLocalName, TypeBinding type, boolean declareNs, boolean declareXsiType) {
        PropertyMetaData propertyMetaData;
        String prefix;
        boolean genPrefix;
        String generatedPrefix;
        AttributesImpl attrs;
        ParticleBinding particle = type.getParticle();
        Collection attributeUses = type.getAttributes();
        int attrsTotal = declareNs || declareXsiType ? this.prefixByUri.size() + attributeUses.size() + 1 : attributeUses.size();
        AttributesImpl attributesImpl = attrs = attrsTotal > 0 ? new AttributesImpl(attrsTotal) : null;
        if (declareNs && !this.prefixByUri.isEmpty()) {
            this.declareNs(attrs);
        }
        String typeNsWithGeneratedPrefix = null;
        if (declareXsiType && (generatedPrefix = this.declareXsiType(type.getQName(), attrs)) != null) {
            typeNsWithGeneratedPrefix = type.getQName().getNamespaceURI();
            this.declareNs(attrs, generatedPrefix, typeNsWithGeneratedPrefix);
            this.declareNamespace(generatedPrefix, typeNsWithGeneratedPrefix);
        }
        boolean bl = genPrefix = (prefix = this.getPrefix(elementNsUri)) == null && elementNsUri != null && elementNsUri.length() > 0;
        if (genPrefix) {
            prefix = "ns_" + elementLocalName;
            this.declareNamespace(prefix, elementNsUri);
            if (attrs == null) {
                attrs = new AttributesImpl(1);
            }
            attrs.add(null, prefix, "xmlns:" + prefix, null, elementNsUri);
        }
        Object o = this.stack.peek();
        boolean ignoreUnresolvedFieldOrClass = type.getSchemaBinding().isIgnoreUnresolvedFieldOrClass();
        Iterator i = attributeUses.iterator();
        while (i.hasNext()) {
            TypeBinding attrType;
            Object attrValue;
            AttributeBinding attrUse = (AttributeBinding)i.next();
            QName attrQName = attrUse.getQName();
            String fieldName = null;
            propertyMetaData = attrUse.getPropertyMetaData();
            if (propertyMetaData != null) {
                fieldName = propertyMetaData.getName();
            }
            if (fieldName == null) {
                fieldName = Util.xmlNameToFieldName(attrQName.getLocalPart(), type.getSchemaBinding().isIgnoreLowLine());
            }
            if ((attrValue = MarshallerImpl.getJavaValue(attrQName, fieldName, o, false, ignoreUnresolvedFieldOrClass)) == null) continue;
            if (attrs == null) {
                attrs = new AttributesImpl(5);
            }
            String attrNs = attrQName.getNamespaceURI();
            String attrLocal = attrQName.getLocalPart();
            String attrPrefix = null;
            if (attrNs != null && (attrPrefix = this.getPrefix(attrNs)) == null && attrNs != null && attrNs.length() > 0) {
                attrPrefix = "ns_" + attrLocal;
                attrs.add(null, attrPrefix, "xmlns:" + attrPrefix, null, attrNs);
            }
            if ((attrType = attrUse.getType()).getItemType() != null) {
                List<Object> list;
                TypeBinding itemType = attrType.getItemType();
                if (!"http://www.w3.org/2001/XMLSchema".equals(itemType.getQName().getNamespaceURI())) throw new JBossXBRuntimeException("Marshalling of list types with item types not from http://www.w3.org/2001/XMLSchema is not supported.");
                if (attrValue instanceof List) {
                    list = (List<Object>)attrValue;
                } else {
                    if (!attrValue.getClass().isArray()) throw new JBossXBRuntimeException("Expected value for list type is an array or " + List.class.getName() + " but got: " + attrValue);
                    list = Arrays.asList((Object[])attrValue);
                }
                if (Constants.QNAME_QNAME.getLocalPart().equals(itemType.getQName().getLocalPart())) {
                    for (int listInd = 0; listInd < list.size(); ++listInd) {
                        String itemPrefix;
                        QName item = (QName)list.get(listInd);
                        String itemNs = item.getNamespaceURI();
                        if (itemNs == null || itemNs.length() <= 0) continue;
                        if (itemNs.equals(elementNsUri)) {
                            itemPrefix = prefix;
                        } else {
                            itemPrefix = this.getPrefix(itemNs);
                            if (itemPrefix == null) {
                                itemPrefix = attrLocal + listInd;
                                this.declareNs(attrs, itemPrefix, itemNs);
                            }
                        }
                        item = new QName(item.getNamespaceURI(), item.getLocalPart(), itemPrefix);
                        list.set(listInd, item);
                    }
                }
                attrValue = SimpleTypeBindings.marshalList(itemType.getQName().getLocalPart(), list, null);
            } else {
                String item;
                attrValue = attrType.getLexicalPattern() != null && attrType.getBaseType() != null && Constants.QNAME_BOOLEAN.equals(attrType.getBaseType().getQName()) ? ((item = (String)attrType.getLexicalPattern().get(0)).indexOf(48) != -1 && item.indexOf(49) != -1 ? ((Boolean)attrValue != false ? "1" : "0") : ((Boolean)attrValue != false ? "true" : "false")) : attrValue.toString();
            }
            String qName = attrPrefix == null || attrPrefix.length() == 0 ? attrLocal : attrPrefix + ":" + attrLocal;
            QName typeQName = attrType.getQName();
            String typeName = typeQName == null ? null : typeQName.getLocalPart();
            attrs.add(attrNs, attrLocal, qName, typeName, attrValue.toString());
        }
        String characters = null;
        TypeBinding simpleType = type.getSimpleType();
        if (simpleType != null) {
            Object value;
            String fieldName = "value";
            CharactersMetaData charactersMetaData = type.getCharactersMetaData();
            PropertyMetaData propertyMetaData2 = propertyMetaData = charactersMetaData == null ? null : charactersMetaData.getProperty();
            if (propertyMetaData != null) {
                fieldName = propertyMetaData.getName();
            }
            if (fieldName != null && (value = MarshallerImpl.getElementValue(new QName(elementNsUri, elementLocalName), o, fieldName, ignoreUnresolvedFieldOrClass)) != null) {
                String typeName = simpleType.getQName().getLocalPart();
                if (attrs == null && ("QName".equals(typeName) || "NOTATION".equals(typeName) || simpleType.getItemType() != null && ("QName".equals(simpleType.getItemType().getQName().getLocalPart()) || "NOTATION".equals(simpleType.getItemType().getQName().getLocalPart())))) {
                    attrs = new AttributesImpl(5);
                }
                characters = this.marshalCharacters(elementNsUri, prefix, simpleType, value, attrs);
            }
        }
        String qName = MarshallerImpl.createQName(prefix, elementLocalName);
        this.content.startElement(elementNsUri, elementLocalName, qName, attrs);
        if (particle != null) {
            this.marshalParticle(particle, false);
        }
        if (characters != null) {
            this.content.characters(characters.toCharArray(), 0, characters.length());
        }
        this.content.endElement(elementNsUri, elementLocalName, qName);
        if (genPrefix) {
            this.removeNamespace(elementNsUri);
        }
        if (typeNsWithGeneratedPrefix == null) return;
        this.removeNamespace(typeNsWithGeneratedPrefix);
    }

    private boolean marshalParticle(ParticleBinding particle, boolean declareNs) {
        boolean marshalled;
        TermBinding term = particle.getTerm();
        if (term.isModelGroup()) {
            ModelGroupBinding modelGroup = (ModelGroupBinding)term;
            if (modelGroup.isSkip() || this.stack.isEmpty()) {
                marshalled = this.marshalModelGroup(modelGroup, declareNs);
            } else {
                Iterator i;
                PropertyMetaData propertyMetaData = modelGroup.getPropertyMetaData();
                if (propertyMetaData == null) {
                    throw new JBossXBRuntimeException("Currently, property binding metadata must be available for a model group to be marshalled!");
                }
                Object o = MarshallerImpl.getChildren(null, this.stack.peek(), propertyMetaData.getName(), modelGroup.getSchema().isIgnoreUnresolvedFieldOrClass());
                Iterator iterator = i = o != null && MarshallerImpl.isRepeatable(particle) ? this.getIterator(o) : null;
                if (i != null) {
                    marshalled = true;
                    while (i.hasNext() && marshalled) {
                        Object value = i.next();
                        this.stack.push(value);
                        marshalled = this.marshalModelGroup(modelGroup, declareNs);
                        this.stack.pop();
                    }
                } else {
                    this.stack.push(o);
                    marshalled = this.marshalModelGroup(modelGroup, declareNs);
                    this.stack.pop();
                }
            }
        } else if (term.isWildcard()) {
            Iterator i;
            Object o = this.stack.peek();
            boolean popWildcardValue = false;
            ObjectLocalMarshaller marshaller = null;
            AbstractMarshaller.FieldToWildcardMapping mapping = (AbstractMarshaller.FieldToWildcardMapping)this.field2WildcardMap.get(o.getClass());
            if (mapping != null) {
                marshaller = mapping.marshaller;
                if (mapping.getter != null) {
                    try {
                        o = mapping.getter.invoke(o, null);
                    }
                    catch (Exception e) {
                        throw new JBossXBRuntimeException("Failed to invoke getter " + mapping.getter.getName() + " on " + o.getClass() + " to get wildcard value: " + e.getMessage());
                    }
                }
                try {
                    o = mapping.field.get(o);
                }
                catch (Exception e) {
                    throw new JBossXBRuntimeException("Failed to invoke get on field " + mapping.field.getName() + " in " + o.getClass() + " to get wildcard value: " + e.getMessage());
                }
                this.stack.push(o);
                popWildcardValue = true;
            }
            Iterator iterator = i = o != null && MarshallerImpl.isRepeatable(particle) ? this.getIterator(o) : null;
            if (i != null) {
                marshalled = true;
                while (i.hasNext() && marshalled) {
                    Object value = i.next();
                    marshalled = this.marshalWildcardOccurence(particle, marshaller, value, declareNs);
                }
            } else {
                marshalled = this.marshalWildcardOccurence(particle, marshaller, o, declareNs);
            }
            if (popWildcardValue) {
                this.stack.pop();
            }
        } else {
            Iterator i;
            ElementBinding element = (ElementBinding)term;
            SchemaBinding schema = element.getSchema();
            Object o = this.getElementValue(element, schema.isIgnoreLowLine(), schema.isIgnoreUnresolvedFieldOrClass());
            Iterator iterator = i = o != null && MarshallerImpl.isRepeatable(particle) ? this.getIterator(o) : null;
            if (i != null) {
                marshalled = true;
                while (i.hasNext() && marshalled) {
                    Object value = i.next();
                    marshalled = this.marshalElementOccurence(element, value, particle.getMinOccurs() == 0, declareNs);
                }
            } else {
                marshalled = this.marshalElementOccurence(element, o, particle.getMinOccurs() == 0, declareNs);
            }
        }
        return marshalled;
    }

    private boolean marshalWildcardOccurence(ParticleBinding particle, ObjectLocalMarshaller marshaller, Object value, boolean declareNs) {
        boolean marshalled = true;
        if (marshaller != null) {
            marshaller.marshal(this.ctx, value);
        } else {
            this.stack.push(value);
            marshalled = this.marshalWildcard(particle, declareNs);
            this.stack.pop();
        }
        return marshalled;
    }

    /*
     * WARNING - void declaration
     */
    private boolean marshalWildcard(ParticleBinding particle, boolean declareNs) {
        void var9_13;
        boolean marshalled;
        WildcardBinding wildcard = (WildcardBinding)particle.getTerm();
        Object o = this.stack.peek();
        AbstractMarshaller.ClassMapping mapping = this.getClassMapping(o.getClass());
        if (mapping == null) {
            QName autoType = SimpleTypeBindings.typeQName(o.getClass());
            if (autoType != null) {
                String marshalled2 = SimpleTypeBindings.marshal(autoType.getLocalPart(), o, null);
                this.content.characters(marshalled2.toCharArray(), 0, marshalled2.length());
                return true;
            }
            if (this.ignoreUnresolvedWildcard) {
                log.warn("Failed to marshal wildcard. Class mapping not found for " + o.getClass() + "@" + o.hashCode() + ": " + o);
                return true;
            }
            throw new IllegalStateException("Failed to marshal wildcard. Class mapping not found for " + o.getClass() + "@" + o.hashCode() + ": " + o);
        }
        Object parentRoot = this.root;
        AbstractMarshaller.Stack parentStack = this.stack;
        SchemaBinding parentSchema = this.schema;
        this.root = o;
        this.stack = new AbstractMarshaller.StackImpl();
        this.schema = XsdBinder.bind(mapping.schemaUrl, this.schemaResolver);
        if (mapping.elementName != null) {
            ElementBinding elDec = this.schema.getElement(mapping.elementName);
            if (elDec == null) {
                throw new JBossXBRuntimeException("Element " + mapping.elementName + " is not declared in the schema.");
            }
            marshalled = this.marshalElementOccurence(elDec, this.root, particle.getMinOccurs() == 0, declareNs);
        } else if (mapping.typeName != null) {
            TypeBinding typeDef = this.schema.getType(mapping.typeName);
            if (typeDef == null) {
                throw new JBossXBRuntimeException("Type " + mapping.typeName + " is not defined in the schema.");
            }
            if (wildcard.getQName() == null) {
                throw new JBossXBRuntimeException("Expected the wildcard to have a non-null QName.");
            }
            ElementBinding element = new ElementBinding(this.schema, wildcard.getQName(), typeDef);
            marshalled = this.marshalElementOccurence(element, this.root, particle.getMinOccurs() == 0, declareNs);
        } else {
            throw new JBossXBRuntimeException("Class mapping for " + mapping.cls + " is associated with neither global element name nor global type name.");
        }
        this.root = parentRoot;
        this.stack = parentStack;
        this.schema = parentSchema;
        return (boolean)var9_13;
    }

    private boolean marshalModelGroup(ModelGroupBinding modelGroup, boolean declareNs) {
        boolean marshalled = modelGroup instanceof AllBinding ? this.marshalModelGroupAll(modelGroup.getParticles(), declareNs) : (modelGroup instanceof ChoiceBinding ? this.marshalModelGroupChoice(modelGroup.getParticles(), declareNs) : this.marshalModelGroupSequence(modelGroup, declareNs));
        return marshalled;
    }

    private boolean marshalModelGroupAll(Collection particles, boolean declareNs) {
        boolean marshalled = false;
        Iterator i = particles.iterator();
        while (i.hasNext()) {
            ParticleBinding particle = (ParticleBinding)i.next();
            marshalled |= this.marshalParticle(particle, declareNs);
        }
        return marshalled;
    }

    private boolean marshalModelGroupChoice(Collection particles, boolean declareNs) {
        boolean marshalled = false;
        Content mainContent = this.content;
        Iterator i = particles.iterator();
        while (i.hasNext() && !marshalled) {
            ParticleBinding particle = (ParticleBinding)i.next();
            this.content = new Content();
            marshalled = this.marshalParticle(particle, declareNs);
        }
        if (marshalled) {
            mainContent.append(this.content);
        }
        this.content = mainContent;
        return marshalled;
    }

    private boolean marshalModelGroupSequence(ModelGroupBinding sequence, boolean declareNs) {
        Object o;
        Iterator valueIterator = null;
        if (!sequence.isSkip() && !this.stack.isEmpty() && (o = this.stack.peek()) != null && (Collection.class.isAssignableFrom(o.getClass()) || o.getClass().isArray())) {
            valueIterator = this.getIterator(o);
        }
        boolean marshalled = true;
        Iterator i = sequence.getParticles().iterator();
        while (i.hasNext()) {
            if (valueIterator != null) {
                Object o2 = valueIterator.hasNext() ? valueIterator.next() : null;
                this.stack.push(o2);
            }
            ParticleBinding particle = (ParticleBinding)i.next();
            marshalled &= this.marshalParticle(particle, declareNs);
            if (valueIterator == null) continue;
            this.stack.pop();
        }
        return marshalled;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String marshalCharacters(String elementUri, String elementPrefix, TypeBinding simpleType, Object value, AttributesImpl attrs) {
        Method getValue;
        if (simpleType.getItemType() != null) {
            List list;
            TypeBinding itemType = simpleType.getItemType();
            if (!"http://www.w3.org/2001/XMLSchema".equals(itemType.getQName().getNamespaceURI())) throw new JBossXBRuntimeException("Marshalling of list types with item types not from http://www.w3.org/2001/XMLSchema is not supported.");
            if (value instanceof List) {
                list = (List)value;
                return SimpleTypeBindings.marshalList(itemType.getQName().getLocalPart(), list, null);
            } else {
                if (!value.getClass().isArray()) throw new JBossXBRuntimeException("Expected value for list type is an array or " + List.class.getName() + " but got: " + value);
                list = MarshallerImpl.asList(value);
            }
            return SimpleTypeBindings.marshalList(itemType.getQName().getLocalPart(), list, null);
        }
        if ("http://www.w3.org/2001/XMLSchema".equals(simpleType.getQName().getNamespaceURI())) {
            String typeName = simpleType.getQName().getLocalPart();
            if (!"QName".equals(typeName)) {
                if (!"NOTATION".equals(typeName)) return SimpleTypeBindings.marshal(typeName, value, null);
            }
            QName qNameValue = (QName)value;
            String prefixValue = qNameValue.getPrefix();
            if ((elementUri != null && !qNameValue.getNamespaceURI().equals(elementUri) || elementUri == null && qNameValue.getNamespaceURI().length() > 0) && (prefixValue.equals(elementPrefix) || prefixValue.length() == 0 && elementPrefix == null)) {
                prefixValue = prefixValue + 'x';
                value = new QName(qNameValue.getNamespaceURI(), qNameValue.getLocalPart(), prefixValue);
            }
            attrs = new AttributesImpl(1);
            this.declareNs(attrs, prefixValue, qNameValue.getNamespaceURI());
            return SimpleTypeBindings.marshal(typeName, value, null);
        }
        if (simpleType.getLexicalPattern() != null && simpleType.getBaseType() != null && Constants.QNAME_BOOLEAN.equals(simpleType.getBaseType().getQName())) {
            String item = (String)simpleType.getLexicalPattern().get(0);
            if (item.indexOf(48) != -1 && item.indexOf(49) != -1) {
                if ((Boolean)value == false) return "0";
                return "1";
            }
            if ((Boolean)value == false) return "false";
            return "true";
        }
        if (simpleType.getLexicalEnumeration() == null) return this.marshalCharacters(elementUri, elementPrefix, simpleType.getBaseType(), value, attrs);
        try {
            getValue = value.getClass().getMethod("value", null);
        }
        catch (NoSuchMethodException e) {
            try {
                getValue = value.getClass().getMethod("getValue", null);
            }
            catch (NoSuchMethodException e1) {
                throw new JBossXBRuntimeException("Failed to find neither value() nor getValue() in " + value.getClass() + " which is bound to enumeration type " + simpleType.getQName());
            }
        }
        try {
            value = getValue.invoke(value, null);
            return this.marshalCharacters(elementUri, elementPrefix, simpleType.getBaseType(), value, attrs);
        }
        catch (Exception e) {
            throw new JBossXBRuntimeException("Failed to invoke getValue() on " + value + " to get the enumeration value", e);
        }
    }

    private void declareNs(AttributesImpl attrs, String prefix, String ns) {
        attrs.add(null, prefix, prefix.length() == 0 ? "xmlns" : "xmlns:" + prefix, null, ns);
    }

    private void writeNillable(String elementNs, String elementLocal, boolean nillable) {
        AttributesImpl attrs;
        if (!this.supportNil) {
            return;
        }
        if (!nillable) {
            throw new JBossXBRuntimeException("Failed to marshal " + new QName(elementNs, elementLocal) + ": Java value is null but the element is not nillable.");
        }
        String prefix = this.getPrefix(elementNs);
        if (prefix == null && elementNs != null && elementNs.length() > 0) {
            prefix = "ns_" + elementLocal;
            attrs = new AttributesImpl(2);
            attrs.add(null, prefix, "xmlns:" + prefix, null, elementNs);
        } else {
            attrs = new AttributesImpl(1);
        }
        String xsiPrefix = this.getPrefix("http://www.w3.org/2001/XMLSchema-instance");
        if (xsiPrefix == null) {
            xsiPrefix = "xsi";
            attrs.add(null, xsiPrefix, "xmlns:xsi", null, "http://www.w3.org/2001/XMLSchema-instance");
        }
        String nilQName = xsiPrefix + ":nil";
        attrs.add("http://www.w3.org/2001/XMLSchema-instance", "nil", nilQName, null, "1");
        String qName = MarshallerImpl.createQName(prefix, elementLocal);
        this.content.startElement(elementNs, elementLocal, qName, attrs);
        this.content.endElement(elementNs, elementLocal, qName);
    }

    private Object getElementValue(ElementBinding element, boolean ignoreLowLine, boolean ignoreNotFoundField) {
        Object value;
        Object peeked = this.stack.peek();
        if (peeked == null) {
            value = null;
        } else if (peeked instanceof Collection || peeked.getClass().isArray()) {
            value = peeked;
        } else {
            String fieldName = null;
            PropertyMetaData propertyMetaData = element.getPropertyMetaData();
            if (propertyMetaData != null) {
                fieldName = propertyMetaData.getName();
            }
            if (fieldName == null) {
                fieldName = Util.xmlNameToFieldName(element.getQName().getLocalPart(), ignoreLowLine);
            }
            if ((value = MarshallerImpl.getChildren(element.getQName(), peeked, fieldName, ignoreNotFoundField)) == null) {
                value = MarshallerImpl.getElementValue(element.getQName(), peeked, fieldName, ignoreNotFoundField);
            }
        }
        return value;
    }

    private void declareNs(AttributesImpl attrs) {
        Iterator i = this.prefixByUri.entrySet().iterator();
        while (i.hasNext()) {
            String localName;
            Map.Entry entry = i.next();
            attrs.add(null, localName, (localName = (String)entry.getValue()) == null || localName.length() == 0 ? "xmlns" : "xmlns:" + localName, null, (String)entry.getKey());
        }
    }

    private static String createQName(String prefix, String local) {
        return prefix == null || prefix.length() == 0 ? local : prefix + ':' + local;
    }

    private static boolean isArrayWrapper(TypeBinding type) {
        ParticleBinding particle;
        boolean is = false;
        if (!type.isSimple() && (particle = type.getParticle()) != null) {
            is = particle.getMaxOccursUnbounded() || particle.getMaxOccurs() > 1;
        }
        return is;
    }

    private Iterator getIterator(Object value) {
        Iterator i = null;
        if (value instanceof Collection) {
            i = ((Collection)value).iterator();
        } else if (value.getClass().isArray()) {
            final Object arr = value;
            i = new Iterator(){
                private int curInd = 0;
                private int length = Array.getLength(arr);

                public boolean hasNext() {
                    return this.curInd < this.length;
                }

                public Object next() {
                    return Array.get(arr, this.curInd++);
                }

                public void remove() {
                    throw new UnsupportedOperationException("remove is not implemented.");
                }
            };
        } else if (value instanceof Iterator) {
            i = (Iterator)value;
        }
        return i;
    }

    private static Object getChildren(QName qName, Object o, String fieldName, boolean ignoreNotFoundField) {
        Object children = null;
        if (!MarshallerImpl.writeAsValue(o.getClass())) {
            children = MarshallerImpl.getJavaValue(qName, fieldName, o, true, ignoreNotFoundField);
        }
        return children;
    }

    private static Object getJavaValue(QName qName, String fieldName, Object o, boolean forComplexType, boolean ignoreNotFoundField) {
        Class<?> fieldType;
        Field field;
        Method getter;
        block12: {
            getter = null;
            field = null;
            fieldType = null;
            try {
                getter = Classes.getAttributeGetter(o.getClass(), fieldName);
                fieldType = getter.getReturnType();
            }
            catch (NoSuchMethodException e) {
                try {
                    field = o.getClass().getField(fieldName);
                    fieldType = field.getType();
                }
                catch (NoSuchFieldException e3) {
                    if (ignoreNotFoundField) {
                        if (log.isTraceEnabled()) {
                            log.trace("Found neither getter nor field for " + qName + " in " + o.getClass());
                        }
                        break block12;
                    }
                    throw new JBossXBRuntimeException("Found neither getter nor field for " + qName + " in " + o.getClass());
                }
            }
        }
        Object value = null;
        if (fieldType != null && (!forComplexType || forComplexType && !MarshallerImpl.writeAsValue(fieldType))) {
            if (getter != null) {
                try {
                    value = getter.invoke(o, null);
                }
                catch (Exception e) {
                    log.error("Failed to invoke getter '" + getter + "' on object: " + o);
                    throw new JBossXBRuntimeException("Failed to provide value for " + qName + " from " + o, e);
                }
            }
            try {
                value = field.get(o);
            }
            catch (Exception e) {
                log.error("Failed to invoke get on field '" + field + "' on object: " + o);
                throw new JBossXBRuntimeException("Failed to provide value for " + qName + " from " + o, e);
            }
        }
        return value;
    }

    private static Object getElementValue(QName qName, Object o, String fieldName, boolean ignoreNotFoundField) {
        Object value = MarshallerImpl.writeAsValue(o.getClass()) ? o : MarshallerImpl.getJavaValue(qName, fieldName, o, false, ignoreNotFoundField);
        return value;
    }

    private static boolean writeAsValue(Class type) {
        return Classes.isPrimitive(type) || type == String.class || type == Date.class || type == BigDecimal.class || type == BigInteger.class;
    }

    private static boolean isRepeatable(ParticleBinding particle) {
        return particle.getMaxOccursUnbounded() || particle.getMaxOccurs() > 1 || particle.getMinOccurs() > 1;
    }

    private String declareXsiType(QName typeQName, AttributesImpl attrs) {
        String pref;
        String result = null;
        if (!this.prefixByUri.containsKey("http://www.w3.org/2001/XMLSchema-instance")) {
            attrs.add("http://www.w3.org/2001/XMLSchema", "xmlns", "xmlns:xsi", null, "http://www.w3.org/2001/XMLSchema-instance");
        }
        if ((pref = this.getPrefix(typeQName.getNamespaceURI())) == null) {
            result = pref = typeQName.getLocalPart() + "_ns";
        }
        String qName = pref == null ? typeQName.getLocalPart() : pref + ':' + typeQName.getLocalPart();
        attrs.add("http://www.w3.org/2001/XMLSchema-instance", "type", "xsi:type", null, qName);
        return result;
    }

    private static final List asList(final Object arr) {
        return new AbstractList(){
            private final Object array;
            {
                this.array = arr;
            }

            public Object get(int index) {
                return Array.get(this.array, index);
            }

            public int size() {
                return Array.getLength(this.array);
            }
        };
    }
}

