/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xb.binding.sunday.unmarshalling;

import java.util.LinkedList;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.xerces.xs.XSTypeDefinition;
import org.jboss.logging.Logger;
import org.jboss.util.StringPropertyReplacer;
import org.jboss.xb.binding.JBossXBRuntimeException;
import org.jboss.xb.binding.NamespaceRegistry;
import org.jboss.xb.binding.Util;
import org.jboss.xb.binding.group.ValueList;
import org.jboss.xb.binding.metadata.CharactersMetaData;
import org.jboss.xb.binding.metadata.ValueMetaData;
import org.jboss.xb.binding.parser.JBossXBParser;
import org.jboss.xb.binding.sunday.unmarshalling.CharactersHandler;
import org.jboss.xb.binding.sunday.unmarshalling.ChoiceBinding;
import org.jboss.xb.binding.sunday.unmarshalling.DefaultHandlers;
import org.jboss.xb.binding.sunday.unmarshalling.ElementBinding;
import org.jboss.xb.binding.sunday.unmarshalling.ElementInterceptor;
import org.jboss.xb.binding.sunday.unmarshalling.ModelGroupBinding;
import org.jboss.xb.binding.sunday.unmarshalling.ParticleBinding;
import org.jboss.xb.binding.sunday.unmarshalling.ParticleHandler;
import org.jboss.xb.binding.sunday.unmarshalling.SchemaBinding;
import org.jboss.xb.binding.sunday.unmarshalling.SchemaBindingResolver;
import org.jboss.xb.binding.sunday.unmarshalling.TermBinding;
import org.jboss.xb.binding.sunday.unmarshalling.TypeBinding;
import org.jboss.xb.binding.sunday.unmarshalling.WildcardBinding;
import org.xml.sax.Attributes;

public class SundayContentHandler
implements JBossXBParser.ContentHandler {
    private static final Logger log = Logger.getLogger(SundayContentHandler.class);
    private static final Object NIL = new Object();
    private final SchemaBinding schema;
    private final SchemaBindingResolver schemaResolver;
    private final StackImpl stack = new StackImpl();
    private Object root;
    private NamespaceRegistry nsRegistry = new NamespaceRegistry();
    private ParticleHandler defParticleHandler = DefaultHandlers.ELEMENT_HANDLER;

    public SundayContentHandler(SchemaBinding schema) {
        this.schema = schema;
        this.schemaResolver = null;
    }

    public SundayContentHandler(SchemaBindingResolver schemaResolver) {
        this.schemaResolver = schemaResolver;
        this.schema = null;
    }

    public void characters(char[] ch, int start, int length) {
        StackItem stackItem = (StackItem)this.stack.peek();
        if (stackItem.particle != null) {
            if (stackItem.textContent == null) {
                stackItem.textContent = new StringBuffer(length);
            }
            stackItem.textContent.append(ch, start, length);
        }
    }

    public void endElement(String namespaceURI, String localName, String qName) {
        ElementBinding elementBinding = null;
        QName endName = null;
        StackItem item = this.pop();
        while (true) {
            if (item.particle != null) {
                elementBinding = (ElementBinding)item.particle.getTerm();
                break;
            }
            if (this.stack.isEmpty()) break;
            if (endName == null) {
                endName = localName.length() == 0 ? new QName(qName) : new QName(namespaceURI, localName);
            }
            item = this.endParticle(item, endName);
            this.pop();
        }
        if (elementBinding == null) {
            throw new JBossXBRuntimeException("Failed to endElement " + qName + ": binding not found");
        }
        endName = elementBinding.getQName();
        if (!endName.getLocalPart().equals(localName) || !endName.getNamespaceURI().equals(namespaceURI)) {
            throw new JBossXBRuntimeException("Failed to end element " + new QName(namespaceURI, localName) + ": element on the stack is " + endName);
        }
        this.endElement(item.o, item.particle, item.textContent == null ? "" : item.textContent.toString());
        if (!this.stack.isEmpty() && ((StackItem)this.stack.peek()).cursor.getParticle().getTerm() instanceof ChoiceBinding) {
            this.endParticle(this.pop(), endName);
        }
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts, XSTypeDefinition xercesType) {
        int i;
        ElementBinding element;
        SchemaBinding schemaBinding;
        ModelGroupBinding.Cursor cursor;
        ParticleBinding particle;
        QName startName;
        block36: {
            Object o;
            ParticleHandler handler;
            ParticleBinding modelGroupParticle;
            List newCursors;
            ModelGroupBinding modelGroup;
            block34: {
                block37: {
                    block35: {
                        startName = localName.length() == 0 ? new QName(qName) : new QName(namespaceURI, localName);
                        particle = null;
                        cursor = null;
                        schemaBinding = this.schema;
                        if (!this.stack.isEmpty()) break block34;
                        if (schemaBinding == null) break block35;
                        particle = schemaBinding.getElementParticle(startName);
                        break block36;
                    }
                    if (this.schemaResolver == null) break block37;
                    String schemaLocation = atts == null ? null : Util.getSchemaLocation(atts, namespaceURI);
                    schemaBinding = this.schemaResolver.resolve(namespaceURI, null, schemaLocation);
                    if (schemaBinding == null) break block36;
                    particle = schemaBinding.getElementParticle(startName);
                    break block36;
                }
                throw new JBossXBRuntimeException("Neither schema binding nor schema binding resolver is available!");
            }
            StackItem item = (StackItem)this.stack.peek();
            if (item.particle != null) {
                TermBinding term = item.particle.getTerm();
                element = (ElementBinding)term;
                ParticleBinding typeParticle = element.getType().getParticle();
                ModelGroupBinding modelGroupBinding = modelGroup = typeParticle == null ? null : (ModelGroupBinding)typeParticle.getTerm();
                if (modelGroup == null) {
                    throw new JBossXBRuntimeException("Element " + element.getQName() + " should be of a complex type for " + startName);
                }
                cursor = modelGroup.newCursor(typeParticle);
                newCursors = cursor.startElement(startName, atts);
                if (newCursors.isEmpty()) {
                    throw new JBossXBRuntimeException(startName + " not found as a child of " + ((ElementBinding)term).getQName());
                }
                for (i = newCursors.size() - 1; i >= 0; --i) {
                    cursor = (ModelGroupBinding.Cursor)newCursors.get(i);
                    modelGroupParticle = cursor.getParticle();
                    handler = ((ModelGroupBinding)modelGroupParticle.getTerm()).getHandler();
                    if (handler == null) {
                        handler = this.defParticleHandler;
                    }
                    o = handler.startParticle(item.o, startName, modelGroupParticle, atts, this.nsRegistry);
                    this.push(cursor, o);
                }
                particle = cursor.getCurrentParticle();
            } else {
                while (!this.stack.isEmpty()) {
                    if (item.particle != null) {
                        TermBinding term = item.particle.getTerm();
                        element = (ElementBinding)term;
                        ParticleBinding typeParticle = element.getType().getParticle();
                        ModelGroupBinding modelGroupBinding = modelGroup = typeParticle == null ? null : (ModelGroupBinding)typeParticle.getTerm();
                        if (modelGroup == null) {
                            throw new JBossXBRuntimeException("Element " + element.getQName() + " should be of a complex type!");
                        }
                        cursor = modelGroup.newCursor(typeParticle);
                        newCursors = cursor.startElement(startName, atts);
                        if (newCursors.isEmpty()) {
                            throw new JBossXBRuntimeException(startName + " not found as a child of " + ((ElementBinding)term).getQName());
                        }
                        for (int i2 = newCursors.size() - 1; i2 >= 0; --i2) {
                            cursor = (ModelGroupBinding.Cursor)newCursors.get(i2);
                            modelGroupParticle = cursor.getParticle();
                            handler = ((ModelGroupBinding)modelGroupParticle.getTerm()).getHandler();
                            if (handler == null) {
                                handler = this.defParticleHandler;
                            }
                            o = handler.startParticle(item.o, startName, modelGroupParticle, atts, this.nsRegistry);
                            this.push(cursor, o);
                        }
                        particle = cursor.getCurrentParticle();
                        break;
                    }
                    cursor = item.cursor;
                    if (cursor == null) {
                        throw new JBossXBRuntimeException("No cursor for " + startName);
                    }
                    int currentOccurence = cursor.getOccurence();
                    List newCursors2 = cursor.startElement(startName, atts);
                    if (newCursors2.isEmpty()) {
                        this.pop();
                        item = this.endParticle(item, startName);
                        continue;
                    }
                    if (cursor.getOccurence() - currentOccurence > 0) {
                        item = this.endParticle(item, startName);
                        ParticleBinding modelGroupParticle2 = cursor.getParticle();
                        ParticleHandler handler2 = ((ModelGroupBinding)modelGroupParticle2.getTerm()).getHandler();
                        if (handler2 == null) {
                            handler2 = this.defParticleHandler;
                        }
                        Object o2 = handler2.startParticle(item.o, startName, modelGroupParticle2, atts, this.nsRegistry);
                        item = this.push(cursor, o2);
                    }
                    for (int i3 = newCursors2.size() - 2; i3 >= 0; --i3) {
                        cursor = (ModelGroupBinding.Cursor)newCursors2.get(i3);
                        ParticleBinding modelGroupParticle3 = cursor.getParticle();
                        ParticleHandler handler3 = ((ModelGroupBinding)modelGroupParticle3.getTerm()).getHandler();
                        if (handler3 == null) {
                            handler3 = this.defParticleHandler;
                        }
                        Object o3 = handler3.startParticle(item.o, startName, modelGroupParticle3, atts, this.nsRegistry);
                        this.push(cursor, o3);
                    }
                    cursor = (ModelGroupBinding.Cursor)newCursors2.get(0);
                    particle = cursor.getCurrentParticle();
                    break;
                }
            }
        }
        Object o = null;
        if (particle != null) {
            String nil;
            TypeBinding type;
            Object parent;
            Object object = parent = this.stack.isEmpty() ? null : ((StackItem)this.stack.peek()).o;
            if (particle.getTerm() instanceof WildcardBinding) {
                element = cursor.getElement();
                if (element == null) {
                    throw new JBossXBRuntimeException("Failed to resolve element " + startName + " for wildcard.");
                }
                particle = new ParticleBinding(element);
            }
            element = (ElementBinding)particle.getTerm();
            String xsiType = atts.getValue("xsi:type");
            if (xsiType != null) {
                String xsiTypeLocal;
                String xsiTypePrefix;
                int colon;
                if (log.isTraceEnabled()) {
                    log.trace(element.getQName() + " uses xsi:type " + xsiType);
                }
                if ((colon = xsiType.indexOf(58)) == -1) {
                    xsiTypePrefix = "";
                    xsiTypeLocal = xsiType;
                } else {
                    xsiTypePrefix = xsiType.substring(0, colon);
                    xsiTypeLocal = xsiType.substring(colon + 1);
                }
                String xsiTypeNs = this.nsRegistry.getNamespaceURI(xsiTypePrefix);
                QName xsiTypeQName = new QName(xsiTypeNs, xsiTypeLocal);
                TypeBinding xsiTypeBinding = schemaBinding.getType(xsiTypeQName);
                if (xsiTypeBinding == null) {
                    throw new JBossXBRuntimeException("Type binding not found for type " + xsiTypeQName + " specified with xsi:type for element " + startName);
                }
                element = new ElementBinding(schemaBinding, startName, xsiTypeBinding);
                particle = new ParticleBinding(element);
            }
            if ((type = element.getType()) == null) {
                throw new JBossXBRuntimeException("No type for element " + element);
            }
            List interceptors = element.getInterceptors();
            for (i = 0; i < interceptors.size(); ++i) {
                ElementInterceptor interceptor = (ElementInterceptor)interceptors.get(i);
                parent = interceptor.startElement(parent, startName, type);
                this.push(startName, particle, parent);
                interceptor.attributes(parent, startName, type, atts, this.nsRegistry);
            }
            ParticleHandler handler = type.getHandler();
            if (handler == null) {
                handler = this.defParticleHandler;
            }
            o = (nil = atts.getValue("xsi:nil")) == null || !"1".equals(nil) && !"true".equals(nil) ? handler.startParticle(parent, startName, particle, atts, this.nsRegistry) : NIL;
        } else {
            ParticleBinding stackParticle;
            TermBinding parentBinding = null;
            if (!this.stack.isEmpty() && (stackParticle = ((StackItem)this.stack.peek()).particle) != null) {
                parentBinding = (ElementBinding)stackParticle.getTerm();
            }
            if (parentBinding != null && parentBinding.getSchema() != null) {
                schemaBinding = parentBinding.getSchema();
            }
            String msg = "Element " + startName + " is not bound " + (parentBinding == null ? "as a global element." : "in type " + ((ElementBinding)parentBinding).getType().getQName());
            if (schemaBinding != null && schemaBinding.isStrictSchema()) {
                throw new JBossXBRuntimeException(msg);
            }
            if (log.isTraceEnabled()) {
                log.trace(msg);
            }
        }
        this.push(startName, particle, o);
    }

    private StackItem endParticle(StackItem item, QName qName) {
        Object o;
        ParticleBinding modelGroupParticle = item.cursor.getParticle();
        ParticleHandler handler = ((ModelGroupBinding)modelGroupParticle.getTerm()).getHandler();
        if (handler == null) {
            handler = this.defParticleHandler;
        }
        if (item.o instanceof ValueList && !modelGroupParticle.getTerm().isSkip()) {
            if (log.isTraceEnabled()) {
                log.trace("endParticle " + qName + " valueList");
            }
            ValueList valueList = (ValueList)item.o;
            o = valueList.getHandler().newInstance(modelGroupParticle, valueList);
        } else {
            o = handler.endParticle(item.o, qName, modelGroupParticle);
        }
        item = (StackItem)this.stack.peek();
        if (item.o != null) {
            ParticleBinding parentParticle = item.particle;
            if (parentParticle == null) {
                parentParticle = item.cursor.getParticle();
            }
            this.setParent(handler, item.o, o, qName, modelGroupParticle, parentParticle);
        }
        if (item.particle == null && item.cursor.getParticle().getTerm() instanceof ChoiceBinding) {
            item = this.endParticle(this.pop(), qName);
        }
        return item;
    }

    public void startPrefixMapping(String prefix, String uri) {
        this.nsRegistry.addPrefixMapping(prefix, uri);
    }

    public void endPrefixMapping(String prefix) {
        this.nsRegistry.removePrefixMapping(prefix);
    }

    public void processingInstruction(String target, String data) {
    }

    public Object getRoot() {
        return this.root;
    }

    private void endElement(Object o, ParticleBinding particle, String textContent) {
        block33: {
            ElementInterceptor interceptor;
            int i;
            Object parent;
            List interceptors;
            QName endName;
            block31: {
                int j;
                ParticleBinding parentParticle;
                block32: {
                    ElementBinding element = (ElementBinding)particle.getTerm();
                    endName = element.getQName();
                    TypeBinding type = element.getType();
                    interceptors = element.getInterceptors();
                    if (o != NIL) {
                        TypeBinding charType = type.getSimpleType();
                        if (charType == null) {
                            charType = type;
                        }
                        CharactersHandler charHandler = charType.getCharactersHandler();
                        if (textContent.length() > 0 || charHandler != null && type.isSimple()) {
                            Object unmarshalled;
                            String dataContent;
                            SchemaBinding schema = element.getSchema();
                            if (textContent.length() == 0) {
                                dataContent = null;
                            } else {
                                dataContent = textContent.toString();
                                if (schema != null && schema.isReplacePropertyRefs()) {
                                    dataContent = StringPropertyReplacer.replaceProperties(dataContent);
                                }
                            }
                            if (charHandler == null) {
                                if (!type.isSimple() && schema != null && schema.isStrictSchema() && !element.isSkip()) {
                                    throw new JBossXBRuntimeException("Element " + endName + " with type binding " + type.getQName() + " does not include text content binding: " + dataContent);
                                }
                                unmarshalled = dataContent;
                            } else {
                                CharactersMetaData charactersMetaData;
                                ValueMetaData valueMetaData = element.getValueMetaData();
                                if (valueMetaData == null && (charactersMetaData = type.getCharactersMetaData()) != null) {
                                    valueMetaData = charactersMetaData.getValue();
                                }
                                Object object = unmarshalled = dataContent == null ? charHandler.unmarshalEmpty(endName, charType, this.nsRegistry, valueMetaData) : charHandler.unmarshal(endName, charType, this.nsRegistry, valueMetaData, dataContent);
                            }
                            if (unmarshalled != null) {
                                if (o == null) {
                                    o = unmarshalled;
                                } else if (charHandler != null) {
                                    if (o instanceof ValueList) {
                                        ValueList valueList = (ValueList)o;
                                        if (type.isSimple()) {
                                            valueList.getInitializer().addTermValue(endName, particle, charHandler, valueList, unmarshalled);
                                        } else {
                                            valueList.getInitializer().addTextValue(endName, particle, charHandler, valueList, unmarshalled);
                                        }
                                    } else {
                                        charHandler.setValue(endName, element, o, unmarshalled);
                                    }
                                }
                            }
                            int i2 = interceptors.size();
                            while (i2-- > 0) {
                                ElementInterceptor interceptor2 = (ElementInterceptor)interceptors.get(i2);
                                interceptor2.characters(((StackItem)this.stack.peek((int)(interceptors.size() - 1 - i2))).o, endName, type, this.nsRegistry, dataContent);
                            }
                        }
                    } else {
                        o = null;
                    }
                    parent = this.stack.isEmpty() ? null : ((StackItem)this.stack.peek()).o;
                    ParticleHandler handler = type.getHandler();
                    if (handler == null) {
                        handler = this.defParticleHandler;
                    }
                    if (o instanceof ValueList && !particle.getTerm().isSkip()) {
                        if (log.isTraceEnabled()) {
                            log.trace("endParticle " + endName + " valueList");
                        }
                        ValueList valueList = (ValueList)o;
                        o = valueList.getHandler().newInstance(particle, valueList);
                    } else {
                        o = handler.endParticle(o, endName, particle);
                    }
                    i = interceptors.size();
                    while (i-- > 0) {
                        interceptor = (ElementInterceptor)interceptors.get(i);
                        interceptor.endElement(((StackItem)this.stack.peek((int)(interceptors.size() - 1 - i))).o, endName, type);
                    }
                    i = interceptors.size();
                    if (i != 0) break block31;
                    ParticleHandler wildcardHandler = null;
                    parentParticle = null;
                    for (j = 0; j < this.stack.size(); ++j) {
                        StackItem item = (StackItem)this.stack.peek(j);
                        ParticleBinding peeked = item.particle;
                        if (peeked == null || !(peeked.getTerm() instanceof ElementBinding)) continue;
                        parentParticle = peeked;
                        WildcardBinding wildcard = ((ElementBinding)parentParticle.getTerm()).getType().getWildcard();
                        if (wildcard == null) break;
                        wildcardHandler = wildcard.getWildcardHandler();
                        break;
                    }
                    if (parent == null) break block32;
                    if (wildcardHandler != null) {
                        this.setParent(wildcardHandler, parent, o, endName, particle, parentParticle);
                    } else {
                        this.setParent(handler, parent, o, endName, particle, parentParticle);
                    }
                    break block33;
                }
                if (parentParticle == null || !((ElementBinding)parentParticle.getTerm()).getType().hasWildcard() || this.stack.isEmpty()) break block33;
                for (j = 0; j < this.stack.size(); ++j) {
                    StackItem peeked = (StackItem)this.stack.peek(j);
                    peeked.o = o;
                    if (peeked.particle != null) break;
                }
                if (!log.isTraceEnabled()) break block33;
                log.trace("Value of " + endName + " " + o + " is promoted as the value of its parent element.");
                break block33;
            }
            while (i-- > 0) {
                interceptor = (ElementInterceptor)interceptors.get(i);
                parent = ((StackItem)this.stack.pop()).o;
                interceptor.add(parent, o, endName);
                o = parent;
            }
        }
        if (this.stack.isEmpty()) {
            this.root = o;
        }
    }

    private void setParent(ParticleHandler handler, Object parent, Object o, QName endName, ParticleBinding particle, ParticleBinding parentParticle) {
        if (parent instanceof ValueList && !particle.getTerm().isSkip()) {
            ValueList valueList = (ValueList)parent;
            valueList.getInitializer().addTermValue(endName, particle, handler, valueList, o);
        } else {
            handler.setParent(parent, o, endName, particle, parentParticle);
        }
    }

    private void push(QName qName, ParticleBinding particle, Object o) {
        StackItem item = new StackItem(particle, o);
        this.stack.push(item);
        if (log.isTraceEnabled()) {
            TermBinding binding = null;
            if (particle != null) {
                binding = particle.getTerm();
            }
            log.trace("pushed " + qName + "=" + o + ", binding=" + binding);
        }
    }

    private StackItem push(ModelGroupBinding.Cursor cursor, Object o) {
        StackItem item = new StackItem(cursor, o);
        this.stack.push(item);
        if (log.isTraceEnabled()) {
            log.trace("pushed cursor " + cursor);
        }
        return item;
    }

    private StackItem pop() {
        StackItem item = (StackItem)this.stack.pop();
        if (log.isTraceEnabled()) {
            if (item.particle != null) {
                log.trace("poped " + ((ElementBinding)item.particle.getTerm()).getQName() + "=" + item.particle);
            } else if (item.cursor != null) {
                log.trace("poped " + item.cursor.getCurrentParticle().getTerm());
            } else {
                log.trace("poped null");
            }
        }
        return item;
    }

    static class StackImpl {
        private LinkedList list = new LinkedList();

        StackImpl() {
        }

        public void clear() {
            this.list.clear();
        }

        public void push(Object o) {
            this.list.addLast(o);
        }

        public Object pop() {
            return this.list.removeLast();
        }

        public Object peek() {
            return this.list.getLast();
        }

        public Object peek(int i) {
            return this.list.get(this.list.size() - 1 - i);
        }

        public boolean isEmpty() {
            return this.list.isEmpty();
        }

        public int size() {
            return this.list.size();
        }
    }

    private static class StackItem {
        final ModelGroupBinding.Cursor cursor;
        final ParticleBinding particle;
        Object o;
        StringBuffer textContent;

        public StackItem(ModelGroupBinding.Cursor cursor, Object o) {
            this.cursor = cursor;
            this.particle = null;
            this.o = o;
        }

        public StackItem(ParticleBinding particle, Object o) {
            this.cursor = null;
            this.particle = particle;
            this.o = o;
        }
    }
}

