/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.jaxrpc;

import java.lang.reflect.Method;
import javax.xml.rpc.ServiceException;
import org.jboss.logging.Logger;
import org.jboss.ws.metadata.EndpointMetaData;
import org.jboss.ws.metadata.OperationMetaData;

public class MetaDataSynchronization {
    private static final Logger log = Logger.getLogger(MetaDataSynchronization.class);

    public static void synchronizeServiceEndpointInterface(EndpointMetaData epMetaData, Class seiClass) throws ServiceException {
        log.debug((Object)("synchronize: [epMetaData=" + epMetaData.getName() + ",sei=" + seiClass.getName() + "]"));
        if (epMetaData.getServiceEndpointInterface() != seiClass) {
            throw new IllegalArgumentException("Endpoint meta data SEI missmatch, expected: " + epMetaData.getServiceEndpointInterfaceName());
        }
        Method[] methods = seiClass.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            log.debug((Object)("synchronize method: " + method));
            OperationMetaData opMetaData = epMetaData.getOperation(method);
            if (opMetaData != null) continue;
            throw new ServiceException("Cannot obtain operation meta data for method: " + method);
        }
    }
}

