/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.provider.ftp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileType;
import org.apache.commons.vfs.provider.AbstractFileObject;
import org.apache.commons.vfs.provider.ftp.FtpFileSystem;
import org.apache.commons.vfs.util.MonitorInputStream;
import org.apache.commons.vfs.util.MonitorOutputStream;

final class FtpFileObject
extends AbstractFileObject {
    private static final FTPFile[] EMPTY_FTP_FILE_ARRAY = new FTPFile[0];
    private final FtpFileSystem ftpFs;
    private final String relPath;
    private FTPFile fileInfo;
    private FTPFile[] children;

    public FtpFileObject(FileName name, FtpFileSystem fileSystem, FileName rootName) throws FileSystemException {
        super(name, fileSystem);
        this.ftpFs = fileSystem;
        this.relPath = rootName.getRelativeName(name);
    }

    private FTPFile getChildFile(String name, boolean flush) throws IOException {
        if (flush) {
            this.children = null;
        }
        this.doGetChildren();
        int i = 0;
        while (i < this.children.length) {
            FTPFile child = this.children[i];
            if (child.getName().equals(name)) {
                return child;
            }
            ++i;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doGetChildren() throws IOException {
        if (this.children != null) {
            return;
        }
        FTPClient client = this.ftpFs.getClient();
        try {
            FTPFile[] tmpChildren = client.listFiles(this.relPath);
            if (tmpChildren == null || tmpChildren.length == 0) {
                this.children = EMPTY_FTP_FILE_ARRAY;
            } else {
                ArrayList<FTPFile> childList = new ArrayList<FTPFile>();
                int i = 0;
                while (i < tmpChildren.length) {
                    FTPFile child = tmpChildren[i];
                    if (!child.getName().equals(".") && !child.getName().equals("..")) {
                        childList.add(child);
                    }
                    ++i;
                }
                this.children = childList.toArray(new FTPFile[childList.size()]);
            }
            Object var7_6 = null;
            this.ftpFs.putClient(client);
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.ftpFs.putClient(client);
            throw throwable;
        }
    }

    protected void doAttach() throws IOException {
        this.getInfo(false);
    }

    private void getInfo(boolean flush) throws IOException {
        FtpFileObject parent = (FtpFileObject)this.getParent();
        if (parent != null) {
            this.fileInfo = parent.getChildFile(this.getName().getBaseName(), flush);
        } else {
            this.fileInfo = new FTPFile();
            this.fileInfo.setType(1);
        }
    }

    protected void doDetach() {
        this.fileInfo = null;
        this.children = null;
    }

    protected void onChildrenChanged() {
        this.children = null;
    }

    protected void onChange() throws IOException {
        this.children = null;
        this.getInfo(true);
    }

    protected FileType doGetType() throws Exception {
        if (this.fileInfo == null) {
            return FileType.IMAGINARY;
        }
        if (this.fileInfo.isDirectory()) {
            return FileType.FOLDER;
        }
        if (this.fileInfo.isFile()) {
            return FileType.FILE;
        }
        if (this.fileInfo.isSymbolicLink()) {
            String path = this.fileInfo.getLink();
            FileObject target = this.getParent().resolveFile(path);
            return target.getType();
        }
        throw new FileSystemException("vfs.provider.ftp/get-type.error", this.getName());
    }

    protected String[] doListChildren() throws Exception {
        this.doGetChildren();
        String[] childNames = new String[this.children.length];
        int i = 0;
        while (i < this.children.length) {
            FTPFile child = this.children[i];
            childNames[i] = child.getName();
            ++i;
        }
        return childNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doDelete() throws Exception {
        boolean ok;
        FTPClient ftpClient = this.ftpFs.getClient();
        try {
            ok = this.fileInfo.isDirectory() ? ftpClient.removeDirectory(this.relPath) : ftpClient.deleteFile(this.relPath);
            Object var4_3 = null;
            this.ftpFs.putClient(ftpClient);
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.ftpFs.putClient(ftpClient);
            throw throwable;
        }
        if (!ok) {
            throw new FileSystemException("vfs.provider.ftp/delete-file.error", this.getName());
        }
        this.fileInfo = null;
        this.children = EMPTY_FTP_FILE_ARRAY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doCreateFolder() throws Exception {
        boolean ok;
        FTPClient client = this.ftpFs.getClient();
        try {
            ok = client.makeDirectory(this.relPath);
            Object var4_3 = null;
            this.ftpFs.putClient(client);
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.ftpFs.putClient(client);
            throw throwable;
        }
        if (!ok) {
            throw new FileSystemException("vfs.provider.ftp/create-folder.error", this.getName());
        }
    }

    protected long doGetContentSize() throws Exception {
        return this.fileInfo.getSize();
    }

    protected long doGetLastModifiedTime() throws Exception {
        return this.fileInfo.getTimestamp().getTime().getTime();
    }

    protected void doSetLastModifiedTime(long modtime) throws Exception {
        Date d = new Date(modtime);
        GregorianCalendar c = new GregorianCalendar();
        c.setTime(d);
        this.fileInfo.setTimestamp((Calendar)c);
    }

    protected InputStream doGetInputStream() throws Exception {
        FTPClient client = this.ftpFs.getClient();
        InputStream instr = client.retrieveFileStream(this.relPath);
        return new FtpInputStream(client, instr);
    }

    protected OutputStream doGetOutputStream() throws Exception {
        FTPClient client = this.ftpFs.getClient();
        return new FtpOutputStream(client, client.storeFileStream(this.relPath));
    }

    private class FtpOutputStream
    extends MonitorOutputStream {
        private final FTPClient client;

        public FtpOutputStream(FTPClient client, OutputStream outstr) {
            super(outstr);
            this.client = client;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void onClose() throws IOException {
            boolean ok;
            try {
                ok = this.client.completePendingCommand();
                Object var3_2 = null;
                FtpFileObject.this.ftpFs.putClient(this.client);
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                FtpFileObject.this.ftpFs.putClient(this.client);
                throw throwable;
            }
            if (!ok) {
                throw new FileSystemException("vfs.provider.ftp/finish-put.error", FtpFileObject.this.getName());
            }
        }
    }

    private class FtpInputStream
    extends MonitorInputStream {
        private final FTPClient client;

        public FtpInputStream(FTPClient client, InputStream in) {
            super(in);
            this.client = client;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void onClose() throws IOException {
            boolean ok;
            try {
                ok = this.client.completePendingCommand();
                Object var3_2 = null;
                FtpFileObject.this.ftpFs.putClient(this.client);
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                FtpFileObject.this.ftpFs.putClient(this.client);
                throw throwable;
            }
            if (!ok) {
                throw new FileSystemException("vfs.provider.ftp/finish-get.error", FtpFileObject.this.getName());
            }
        }
    }
}

