/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.provider.webdav;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileType;
import org.apache.commons.vfs.provider.AbstractFileObject;
import org.apache.commons.vfs.provider.GenericFileName;
import org.apache.commons.vfs.provider.webdav.WebDavFileSystem;
import org.apache.commons.vfs.util.MonitorOutputStream;
import org.apache.util.HttpURL;
import org.apache.webdav.lib.BaseProperty;
import org.apache.webdav.lib.WebdavResource;
import org.apache.webdav.lib.methods.OptionsMethod;
import org.apache.webdav.lib.methods.XMLResponseMethodBase;

public class WebdavFileObject
extends AbstractFileObject
implements FileObject {
    private final WebDavFileSystem fileSystem;
    private WebdavResource resource;
    private HttpURL url;

    public WebdavFileObject(GenericFileName name, WebDavFileSystem fileSystem) {
        super(name, fileSystem);
        this.fileSystem = fileSystem;
    }

    protected void doAttach() throws Exception {
        GenericFileName name = (GenericFileName)this.getName();
        this.url = new HttpURL(name.getUserName(), name.getPassword(), name.getHostName(), name.getPort(), name.getPath());
        this.resource = new WebdavResource(this.fileSystem.getClient()){};
        this.resource.setHttpURL(this.url, 1, 1);
    }

    protected FileType doGetType() throws Exception {
        OptionsMethod optionsMethod = new OptionsMethod(this.getName().getPath());
        optionsMethod.setFollowRedirects(true);
        int status = this.fileSystem.getClient().executeMethod((HttpMethod)optionsMethod);
        if (status < 200 || status > 299) {
            return FileType.IMAGINARY;
        }
        this.resource.getHttpURL().setPath(optionsMethod.getPath());
        boolean exists = false;
        Enumeration enumeration = optionsMethod.getAllowedMethods();
        while (enumeration.hasMoreElements()) {
            String method = (String)enumeration.nextElement();
            if (!method.equals("GET")) continue;
            exists = true;
            break;
        }
        if (!exists) {
            return FileType.IMAGINARY;
        }
        boolean davResource = optionsMethod.getDavCapabilities().hasMoreElements();
        if (!davResource) {
            return FileType.FOLDER;
        }
        this.resource.setProperties(4, 1);
        if (this.resource.isCollection()) {
            return FileType.FOLDER;
        }
        return FileType.FILE;
    }

    protected String[] doListChildren() throws Exception {
        String[] children = this.resource.list();
        if (children == null) {
            throw new FileSystemException("vfs.provider.webdav/list-children.error", this.resource.getStatusMessage());
        }
        return children;
    }

    protected void doCreateFolder() throws Exception {
        this.resource.getHttpURL().setPath(this.getName().getPath() + '/');
        boolean ok = this.resource.mkcolMethod();
        if (!ok) {
            throw new FileSystemException("vfs.provider.webdav/create-collection.error", this.resource.getStatusMessage());
        }
    }

    protected void doDelete() throws Exception {
        boolean ok = this.resource.deleteMethod(this.url.getPath());
        if (!ok) {
            throw new FileSystemException("vfs.provider.webdav/delete-file.error", this.resource.getStatusMessage());
        }
    }

    protected InputStream doGetInputStream() throws Exception {
        return this.resource.getMethodData();
    }

    protected OutputStream doGetOutputStream() throws Exception {
        return new WebdavOutputStream();
    }

    protected long doGetContentSize() throws Exception {
        return this.resource.getGetContentLength();
    }

    protected long doGetLastModifiedTime() throws Exception {
        return this.resource.getGetLastModified();
    }

    protected Map doGetAttributes() throws Exception {
        HashMap<String, String> attributes = new HashMap<String, String>();
        Enumeration e = this.resource.propfindMethod(0);
        while (e.hasMoreElements()) {
            XMLResponseMethodBase.Response response = (XMLResponseMethodBase.Response)e.nextElement();
            Enumeration properties = response.getProperties();
            while (properties.hasMoreElements()) {
                BaseProperty property = (BaseProperty)properties.nextElement();
                attributes.put(property.getLocalName(), property.getPropertyAsString());
            }
        }
        return attributes;
    }

    private class WebdavOutputStream
    extends MonitorOutputStream {
        public WebdavOutputStream() {
            super(new ByteArrayOutputStream());
        }

        protected void onClose() throws IOException {
            ByteArrayOutputStream outstr = (ByteArrayOutputStream)this.out;
            WebdavFileObject.this.resource.getHttpURL().setPath(WebdavFileObject.this.getName().getPath());
            boolean ok = WebdavFileObject.this.resource.putMethod(outstr.toByteArray());
            if (!ok) {
                throw new FileSystemException("vfs.provider.webdav/write-file.error", WebdavFileObject.this.resource.getStatusMessage());
            }
        }
    }
}

