/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.rowset;

import java.io.ByteArrayInputStream;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringBufferInputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.AbstractList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.sql.RowSet;
import javax.sql.RowSetEvent;
import javax.sql.RowSetInternal;
import javax.sql.RowSetListener;
import javax.sql.RowSetMetaData;
import javax.sql.RowSetReader;
import javax.sql.RowSetWriter;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.rowset.OracleCachedRowSetReader;
import oracle.jdbc.rowset.OracleCachedRowSetWriter;
import oracle.jdbc.rowset.OracleRow;
import oracle.jdbc.rowset.OracleRowSetMetaData;
import oracle.jdbc.rowset.OracleSerialBlob;
import oracle.jdbc.rowset.OracleSerialClob;
import oracle.sql.BLOB;
import oracle.sql.CLOB;

public class OracleCachedRowSet
implements RowSet,
RowSetInternal,
Serializable,
Cloneable {
    private String dataSource;
    private String dataSourceName;
    private String url;
    private String username;
    private String password;
    private Map typeMap;
    private int maxFieldSize;
    private int maxRows;
    private int queryTimeout;
    private int fetchSize;
    private int transactionIsolation;
    private boolean escapeProcessing;
    private String command;
    private int concurrency;
    private boolean readOnly;
    private int fetchDirection;
    private int type;
    private SQLWarning sqlWarning;
    private int presentRow = 0;
    private boolean previousColumnWasNull = false;
    private Vector listener = new Vector();
    private OracleRow insertRow;
    private int insertRowPosition;
    private boolean insertRowFlag;
    private int updateRowPosition;
    private boolean updateRowFlag;
    private ResultSetMetaData rowsetMetaData;
    private RowSetEvent rowsetEvent;
    private transient ResultSet resultSet;
    private transient Connection connection;
    private Vector rows;
    private Vector param = new Vector();
    private String[] metaData;
    private int colCount;
    private int rowCount;
    private RowSetReader reader;
    private RowSetWriter writer;
    private boolean showDeleted;

    public OracleCachedRowSet() {
        this.rowsetEvent = new RowSetEvent(this);
        this.setReader(new OracleCachedRowSetReader());
        this.setWriter(new OracleCachedRowSetWriter());
        this.sqlWarning = new SQLWarning();
        this.escapeProcessing = false;
        this.insertRowFlag = false;
        this.updateRowFlag = false;
        this.type = 1005;
        this.fetchDirection = 1002;
        this.readOnly = true;
        this.showDeleted = false;
        this.maxFieldSize = 0;
        this.maxRows = 0;
        this.fetchSize = 0;
        this.queryTimeout = 0;
        this.url = "";
        this.username = "";
        this.password = "";
        this.command = "";
        this.typeMap = new HashMap();
        this.concurrency = 1007;
    }

    public boolean absolute(int n) throws SQLException {
        if (this.type == 1003) {
            throw new SQLException("The RowSet type is TYPE_FORWARD_ONLY");
        }
        if (n == 0 || Math.abs(n) > this.rowCount) {
            return false;
        }
        this.presentRow = n < 0 ? this.rowCount + n + 1 : n;
        this.notifyCursorMovement();
        return true;
    }

    public void acceptChanges() throws SQLException {
        this.getWriter().writeData(this);
        this.getReader().readData(this);
    }

    public void acceptChanges(Connection connection) throws SQLException {
        this.connection = connection;
        this.getWriter().writeData(this);
        this.getReader().readData(this);
    }

    public void addRowSetListener(RowSetListener rowSetListener) {
        int n = 0;
        while (n < this.listener.size()) {
            if (this.listener.elementAt(n).equals(rowSetListener)) {
                return;
            }
            ++n;
        }
        this.listener.add(rowSetListener);
    }

    public void afterLast() throws SQLException {
        this.presentRow = this.rowCount + 1;
    }

    public void beforeFirst() throws SQLException {
        this.presentRow = 0;
    }

    public void cancelRowDelete() throws SQLException {
        if (!this.getCurrentRow().isRowDeleted()) {
            throw new SQLException("The row is not deleted");
        }
        this.getCurrentRow().setRowDeleted(false);
    }

    public void cancelRowInsert() throws SQLException {
        if (!this.getCurrentRow().isRowInserted()) {
            throw new SQLException("The row is not inserted");
        }
        this.rows.remove(this.presentRow);
    }

    public void cancelRowUpdates() throws SQLException {
        if (!this.getCurrentRow().isRowUpdated()) {
            throw new SQLException("The row is not updated.");
        }
        this.updateRowFlag = false;
        this.getCurrentRow().setRowUpdated(false);
    }

    private final void checkColumnIndex(int n) throws SQLException {
        if (this.readOnly) {
            throw new SQLException("The RowSet is not write enabled");
        }
        if (n < 1 || n > this.colCount) {
            throw new SQLException("invalid index : " + n);
        }
    }

    private final void checkParamIndex(int n) throws SQLException {
        if (n < 1) {
            throw new SQLException("Invalid parameter index : " + n);
        }
    }

    public synchronized void clearParameters() throws SQLException {
        this.param = null;
        this.param = new Vector();
        System.gc();
    }

    public void clearWarnings() throws SQLException {
        new SQLWarning();
    }

    public Object clone() throws CloneNotSupportedException {
        try {
            return this.createCopy();
        }
        catch (SQLException sQLException) {
            throw new CloneNotSupportedException("SQL Error occured while cloning,\n" + sQLException.getMessage());
        }
    }

    public void close() throws SQLException {
        this.release();
    }

    public OracleCachedRowSet createCopy() throws SQLException {
        OracleCachedRowSet oracleCachedRowSet = this.createShared();
        int n = this.rows.size();
        oracleCachedRowSet.rows = new Vector(n);
        int n2 = 0;
        while (n2 < n) {
            oracleCachedRowSet.rows.add(((OracleRow)this.rows.elementAt(n2)).createCopy());
            ++n2;
        }
        return oracleCachedRowSet;
    }

    public OracleCachedRowSet createShared() throws SQLException {
        OracleCachedRowSet oracleCachedRowSet = new OracleCachedRowSet();
        oracleCachedRowSet.rows = this.rows;
        oracleCachedRowSet.setDataSource(this.getDataSource());
        oracleCachedRowSet.setDataSourceName(this.getDataSourceName());
        oracleCachedRowSet.setUsername(this.getUsername());
        oracleCachedRowSet.setPassword(this.getPassword());
        oracleCachedRowSet.setUrl(this.getUrl());
        oracleCachedRowSet.setTypeMap(this.getTypeMap());
        oracleCachedRowSet.setMaxFieldSize(this.getMaxFieldSize());
        oracleCachedRowSet.setMaxRows(this.getMaxRows());
        oracleCachedRowSet.setQueryTimeout(this.getQueryTimeout());
        oracleCachedRowSet.setFetchSize(this.getFetchSize());
        oracleCachedRowSet.setEscapeProcessing(this.getEscapeProcessing());
        oracleCachedRowSet.setConcurrency(this.getConcurrency());
        oracleCachedRowSet.setReadOnly(this.readOnly);
        this.type = this.getType();
        this.fetchDirection = this.getFetchDirection();
        oracleCachedRowSet.setCommand(this.getCommand());
        oracleCachedRowSet.setTransactionIsolation(this.getTransactionIsolation());
        oracleCachedRowSet.presentRow = this.presentRow;
        oracleCachedRowSet.colCount = this.colCount;
        oracleCachedRowSet.rowCount = this.rowCount;
        oracleCachedRowSet.showDeleted = this.showDeleted;
        int n = this.listener.size();
        int n2 = 0;
        while (n2 < n) {
            oracleCachedRowSet.listener.add(this.listener.elementAt(n2));
            ++n2;
        }
        oracleCachedRowSet.rowsetMetaData = new OracleRowSetMetaData(this.rowsetMetaData);
        n = this.param.size();
        int n3 = 0;
        while (n3 < n) {
            oracleCachedRowSet.param.add(this.param.elementAt(n3));
            ++n3;
        }
        oracleCachedRowSet.metaData = new String[this.metaData.length];
        System.arraycopy(this.metaData, 0, oracleCachedRowSet.metaData, 0, this.metaData.length);
        return oracleCachedRowSet;
    }

    public void deleteRow() throws SQLException {
        this.getCurrentRow().setRowDeleted(true);
        this.notifyRowChanged();
        this.notifyRowSetModified();
    }

    public synchronized void execute() throws SQLException {
        this.getReader().readData(this);
    }

    public int findColumn(String string) throws SQLException {
        return this.getColumnIndex(string);
    }

    public boolean first() throws SQLException {
        return this.absolute(1);
    }

    public Array getArray(int n) throws SQLException {
        Object object = this.getObject(n);
        if (object == null || object instanceof Array) {
            return (Array)object;
        }
        throw new SQLException("Invalid column type");
    }

    public Array getArray(String string) throws SQLException {
        return this.getArray(this.getColumnIndex(string));
    }

    public InputStream getAsciiStream(int n) throws SQLException {
        InputStream inputStream = this.getStream(n);
        return inputStream == null ? null : inputStream;
    }

    public InputStream getAsciiStream(String string) throws SQLException {
        return this.getAsciiStream(this.getColumnIndex(string));
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        BigDecimal bigDecimal = (BigDecimal)this.getNumber(n);
        return bigDecimal == null ? null : bigDecimal;
    }

    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        return this.getBigDecimal(n);
    }

    public BigDecimal getBigDecimal(String string) throws SQLException {
        return this.getBigDecimal(this.getColumnIndex(string));
    }

    public BigDecimal getBigDecimal(String string, int n) throws SQLException {
        return this.getBigDecimal(this.getColumnIndex(string), n);
    }

    public InputStream getBinaryStream(int n) throws SQLException {
        InputStream inputStream = this.getStream(n);
        return inputStream == null ? null : inputStream;
    }

    public InputStream getBinaryStream(String string) throws SQLException {
        return this.getBinaryStream(this.getColumnIndex(string));
    }

    public Blob getBlob(int n) throws SQLException {
        Object object = this.getObject(n);
        if (object instanceof OracleSerialBlob) {
            return object == null ? null : (Blob)object;
        }
        throw new SQLException("Invalid column type");
    }

    public Blob getBlob(String string) throws SQLException {
        return this.getBlob(this.getColumnIndex(string));
    }

    public boolean getBoolean(int n) throws SQLException {
        Object object = this.getObject(n);
        if (object == null) {
            return false;
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        if (object instanceof BigDecimal) {
            return ((BigDecimal)object).doubleValue() != 0.0;
        }
        throw new SQLException("Fail to convert to internal representation");
    }

    public boolean getBoolean(String string) throws SQLException {
        return this.getBoolean(this.getColumnIndex(string));
    }

    public byte getByte(int n) throws SQLException {
        Object object = this.getObject(n);
        if (object == null) {
            return 0;
        }
        if (object instanceof Byte) {
            return (Byte)object;
        }
        if (object instanceof BigDecimal) {
            return ((BigDecimal)object).toString().getBytes()[0];
        }
        if (object instanceof String) {
            return ((String)object).getBytes()[0];
        }
        if (object instanceof OracleSerialBlob) {
            OracleSerialBlob oracleSerialBlob = (OracleSerialBlob)object;
            return oracleSerialBlob.getBytes(0L, 1)[0];
        }
        if (object instanceof OracleSerialClob) {
            OracleSerialClob oracleSerialClob = (OracleSerialClob)object;
            return oracleSerialClob.getSubString(0L, 1).getBytes()[0];
        }
        throw new SQLException("Fail to convert to internal representation");
    }

    public byte getByte(String string) throws SQLException {
        return this.getByte(this.getColumnIndex(string));
    }

    public byte[] getBytes(int n) throws SQLException {
        Object object = this.getObject(n);
        if (object == null) {
            return (byte[])object;
        }
        if (object instanceof byte[]) {
            return (byte[])object;
        }
        if (object instanceof String) {
            return ((String)object).getBytes();
        }
        if (object instanceof BigDecimal) {
            return ((BigDecimal)object).toString().getBytes();
        }
        if (object instanceof OracleSerialBlob) {
            OracleSerialBlob oracleSerialBlob = (OracleSerialBlob)object;
            return oracleSerialBlob.getBytes(0L, (int)oracleSerialBlob.length());
        }
        if (object instanceof OracleSerialClob) {
            OracleSerialClob oracleSerialClob = (OracleSerialClob)object;
            return oracleSerialClob.getSubString(0L, (int)oracleSerialClob.length()).getBytes();
        }
        throw new SQLException("Fail to convert to internal representation");
    }

    public byte[] getBytes(String string) throws SQLException {
        return this.getBytes(this.getColumnIndex(string));
    }

    public synchronized Reader getCharacterStream(int n) throws SQLException {
        try {
            InputStream inputStream = this.getAsciiStream(n);
            if (inputStream == null) {
                return null;
            }
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = 0;
            while ((n2 = inputStream.read()) != -1) {
                stringBuffer.append((char)n2);
            }
            char[] cArray = new char[stringBuffer.length()];
            stringBuffer.getChars(0, stringBuffer.length(), cArray, 0);
            CharArrayReader charArrayReader = new CharArrayReader(cArray);
            cArray = null;
            return charArrayReader;
        }
        catch (IOException iOException) {
            throw new SQLException("Error: could not read from the stream");
        }
    }

    public Reader getCharacterStream(String string) throws SQLException {
        return this.getCharacterStream(this.getColumnIndex(string));
    }

    public Clob getClob(int n) throws SQLException {
        Object object = this.getObject(n);
        if (object instanceof OracleSerialClob) {
            return object == null ? null : (Clob)object;
        }
        throw new SQLException("Invalid column type");
    }

    public Clob getClob(String string) throws SQLException {
        return this.getClob(this.getColumnIndex(string));
    }

    private final int getColumnIndex(String string) throws SQLException {
        string = string.toUpperCase();
        int n = 0;
        while (n < this.metaData.length) {
            if (string.equals(this.metaData[n])) break;
            ++n;
        }
        if (n >= this.metaData.length) {
            throw new SQLException("Invalid column name: " + string);
        }
        return n + 1;
    }

    public String getCommand() {
        return this.command;
    }

    public int getConcurrency() throws SQLException {
        return this.concurrency;
    }

    public Connection getConnection() throws SQLException {
        return this.connection;
    }

    OracleRow getCurrentRow() throws SQLException {
        int n = this.presentRow - 1;
        if (this.presentRow < 1 || this.presentRow > this.rowCount) {
            throw new SQLException("Operation with out calling next/previous");
        }
        return (OracleRow)this.rows.elementAt(this.presentRow - 1);
    }

    public String getCursorName() throws SQLException {
        throw new SQLException("Getting the cursor name is not supported.");
    }

    public String getDataSource() {
        return this.dataSource;
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public Date getDate(int n) throws SQLException {
        Object object = this.getObject(n);
        if (object == null) {
            return (Date)object;
        }
        if (object instanceof Timestamp) {
            Timestamp timestamp = (Timestamp)object;
            return new Date(timestamp.getYear(), timestamp.getMonth(), timestamp.getDate());
        }
        throw new SQLException("Invalid column type");
    }

    public Date getDate(int n, Calendar calendar) throws SQLException {
        return this.getDate(n);
    }

    public Date getDate(String string) throws SQLException {
        return this.getDate(this.getColumnIndex(string));
    }

    public Date getDate(String string, Calendar calendar) throws SQLException {
        return this.getDate(this.getColumnIndex(string), calendar);
    }

    public double getDouble(int n) throws SQLException {
        Number number = this.getNumber(n);
        return number == null ? 0.0 : number.doubleValue();
    }

    public double getDouble(String string) throws SQLException {
        return this.getDouble(this.getColumnIndex(string));
    }

    public boolean getEscapeProcessing() throws SQLException {
        return this.escapeProcessing;
    }

    public int getFetchDirection() throws SQLException {
        return this.fetchDirection;
    }

    public int getFetchSize() throws SQLException {
        return this.fetchSize;
    }

    public float getFloat(int n) throws SQLException {
        Number number = this.getNumber(n);
        return number == null ? 0.0f : number.floatValue();
    }

    public float getFloat(String string) throws SQLException {
        return this.getFloat(this.getColumnIndex(string));
    }

    public int getInt(int n) throws SQLException {
        Number number = this.getNumber(n);
        return number == null ? 0 : number.intValue();
    }

    public int getInt(String string) throws SQLException {
        return this.getInt(this.getColumnIndex(string));
    }

    public long getLong(int n) throws SQLException {
        Number number = this.getNumber(n);
        return number == null ? 0L : number.longValue();
    }

    public long getLong(String string) throws SQLException {
        return this.getLong(this.getColumnIndex(string));
    }

    public int getMaxFieldSize() throws SQLException {
        return this.maxFieldSize;
    }

    public int getMaxRows() throws SQLException {
        return this.maxRows;
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        return this.rowsetMetaData;
    }

    private synchronized Number getNumber(int n) throws SQLException {
        Object object = this.getObject(n);
        if (object == null || object instanceof BigDecimal || object instanceof Number) {
            return (Number)object;
        }
        throw new SQLException("Fail to convert to internal representation");
    }

    public synchronized Object getObject(int n) throws SQLException {
        int n2 = this.presentRow * this.colCount + n - 1;
        Object object = null;
        object = !this.isUpdated(n) ? this.getCurrentRow().getColumn(n) : this.getCurrentRow().getModifiedColumn(n);
        this.previousColumnWasNull = object == null;
        return object;
    }

    public Object getObject(int n, Map map) throws SQLException {
        return this.getObject(n);
    }

    public synchronized Object getObject(String string) throws SQLException {
        return this.getObject(this.getColumnIndex(string));
    }

    public Object getObject(String string, Map map) throws SQLException {
        return this.getObject(this.getColumnIndex(string), map);
    }

    public ResultSet getOriginal() throws SQLException {
        OracleCachedRowSet oracleCachedRowSet = new OracleCachedRowSet();
        oracleCachedRowSet.rowsetMetaData = this.rowsetMetaData;
        oracleCachedRowSet.rowCount = 1;
        oracleCachedRowSet.presentRow = 0;
        oracleCachedRowSet.setReader(null);
        oracleCachedRowSet.setWriter(null);
        int n = this.rowsetMetaData.getColumnCount();
        OracleRow oracleRow = null;
        Iterator iterator = ((AbstractList)this.rows).iterator();
        while (iterator.hasNext()) {
            oracleRow = new OracleRow(n, ((OracleRow)((Object)iterator)).getOriginalRow());
            oracleCachedRowSet.rows.add(oracleRow);
        }
        return oracleCachedRowSet;
    }

    public ResultSet getOriginalRow() throws SQLException {
        OracleCachedRowSet oracleCachedRowSet = new OracleCachedRowSet();
        oracleCachedRowSet.rowsetMetaData = this.rowsetMetaData;
        oracleCachedRowSet.rowCount = 1;
        oracleCachedRowSet.colCount = this.colCount;
        oracleCachedRowSet.presentRow = 0;
        oracleCachedRowSet.setReader(null);
        oracleCachedRowSet.setWriter(null);
        OracleRow oracleRow = new OracleRow(this.rowsetMetaData.getColumnCount(), this.getCurrentRow().getOriginalRow());
        oracleCachedRowSet.rows.add(oracleRow);
        return oracleCachedRowSet;
    }

    public Object[] getParams() throws SQLException {
        return this.param.toArray();
    }

    public String getPassword() {
        return this.password;
    }

    public int getQueryTimeout() throws SQLException {
        return this.queryTimeout;
    }

    public RowSetReader getReader() {
        return this.reader;
    }

    public Ref getRef(int n) throws SQLException {
        Object object = this.getObject(n);
        if (object == null || object instanceof Ref) {
            return (Ref)object;
        }
        throw new SQLException("Invalid column type");
    }

    public Ref getRef(String string) throws SQLException {
        return this.getRef(this.getColumnIndex(string));
    }

    public int getRow() throws SQLException {
        if (this.presentRow > this.rowCount) {
            return this.rowCount;
        }
        if (this.presentRow == 0) {
            return 1;
        }
        return this.presentRow;
    }

    public short getShort(int n) throws SQLException {
        Number number = this.getNumber(n);
        return number == null ? (short)0 : number.shortValue();
    }

    public short getShort(String string) throws SQLException {
        return this.getShort(this.getColumnIndex(string));
    }

    public boolean getShowDeleted() {
        return this.showDeleted;
    }

    public Statement getStatement() throws SQLException {
        if (this.connection == null || this.connection.isClosed()) {
            throw new SQLException("Connection not open");
        }
        if (this.resultSet == null) {
            throw new SQLException("ResultSet not open");
        }
        return this.resultSet.getStatement();
    }

    private synchronized InputStream getStream(int n) throws SQLException {
        Object object = this.getObject(n);
        if (object == null) {
            return null;
        }
        if (object instanceof InputStream) {
            return (InputStream)object;
        }
        if (object instanceof String) {
            return new ByteArrayInputStream(((String)object).getBytes());
        }
        if (object instanceof byte[]) {
            return new ByteArrayInputStream((byte[])object);
        }
        if (object instanceof OracleSerialClob) {
            return ((OracleSerialClob)object).getAsciiStream();
        }
        if (object instanceof OracleSerialBlob) {
            return ((OracleSerialBlob)object).getBinaryStream();
        }
        throw new SQLException("Could not convert the column into a stream type");
    }

    public String getString(int n) throws SQLException {
        Object object = this.getObject(n);
        if (object == null) {
            return (String)object;
        }
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof BigDecimal) {
            return object.toString();
        }
        if (object instanceof byte[]) {
            return new String((byte[])object);
        }
        if (object instanceof OracleSerialClob) {
            OracleSerialClob oracleSerialClob = (OracleSerialClob)object;
            return oracleSerialClob.getSubString(0L, (int)oracleSerialClob.length());
        }
        if (object instanceof OracleSerialBlob) {
            OracleSerialBlob oracleSerialBlob = (OracleSerialBlob)object;
            return new String(oracleSerialBlob.getBytes(0L, (int)oracleSerialBlob.length()));
        }
        throw new SQLException("Fail to convert to internal representation");
    }

    public String getString(String string) throws SQLException {
        return this.getString(this.getColumnIndex(string));
    }

    public Time getTime(int n) throws SQLException {
        Object object = this.getObject(n);
        if (object == null) {
            return (Time)object;
        }
        if (object instanceof Timestamp) {
            Timestamp timestamp = (Timestamp)object;
            return new Time(timestamp.getHours(), timestamp.getMinutes(), timestamp.getSeconds());
        }
        throw new SQLException("Invalid column type");
    }

    public Time getTime(int n, Calendar calendar) throws SQLException {
        return this.getTime(n);
    }

    public Time getTime(String string) throws SQLException {
        return this.getTime(this.getColumnIndex(string));
    }

    public Time getTime(String string, Calendar calendar) throws SQLException {
        return this.getTime(this.getColumnIndex(string), calendar);
    }

    public Timestamp getTimestamp(int n) throws SQLException {
        Object object = this.getObject(n);
        if (object == null || object instanceof Timestamp) {
            return (Timestamp)object;
        }
        throw new SQLException("Invalid column type");
    }

    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        return this.getTimestamp(n);
    }

    public Timestamp getTimestamp(String string) throws SQLException {
        return this.getTimestamp(this.getColumnIndex(string));
    }

    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        return this.getTimestamp(this.getColumnIndex(string), calendar);
    }

    public int getTransactionIsolation() {
        return this.transactionIsolation;
    }

    public int getType() throws SQLException {
        return this.type;
    }

    public Map getTypeMap() throws SQLException {
        return this.typeMap;
    }

    public URL getURL(int n) throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
        return null;
    }

    public URL getURL(String string) throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
        return null;
    }

    public InputStream getUnicodeStream(int n) throws SQLException {
        Object object = this.getObject(n);
        if (object == null) {
            return (InputStream)object;
        }
        if (object instanceof String) {
            return new StringBufferInputStream((String)object);
        }
        throw new SQLException("Fail to convert to internal representation");
    }

    public InputStream getUnicodeStream(String string) throws SQLException {
        return this.getUnicodeStream(this.getColumnIndex(string));
    }

    public String getUrl() {
        return this.url;
    }

    public String getUsername() {
        return this.username;
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.sqlWarning;
    }

    public RowSetWriter getWriter() {
        return this.writer;
    }

    public void insertRow() throws SQLException {
        if (!this.insertRowFlag) {
            throw new SQLException("Current row not inserted/updated.");
        }
        if (!this.insertRow.isRowFullyPopulated()) {
            throw new SQLException("All the columns of the row are not set");
        }
        this.insertRow.insertRow();
        this.rows.insertElementAt(this.insertRow, this.insertRowPosition - 1);
        this.insertRowFlag = false;
        ++this.rowCount;
        this.notifyRowChanged();
        this.notifyRowSetModified();
    }

    public boolean isAfterLast() throws SQLException {
        return this.rowCount > 0 && this.presentRow == this.rowCount + 1;
    }

    public boolean isBeforeFirst() throws SQLException {
        return this.rowCount > 0 && this.presentRow == 0;
    }

    public boolean isFirst() throws SQLException {
        return this.presentRow == 1;
    }

    public boolean isLast() throws SQLException {
        return this.presentRow == this.rowCount;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    private final boolean isUpdated(int n) throws SQLException {
        if (n < 1 || n > this.colCount) {
            throw new SQLException("Invalid index : " + n);
        }
        return this.getCurrentRow().isColumnChanged(n);
    }

    public boolean last() throws SQLException {
        return this.absolute(-1);
    }

    public void moveToCurrentRow() throws SQLException {
        this.insertRowFlag = false;
        this.updateRowFlag = false;
        this.absolute(this.presentRow);
    }

    public void moveToInsertRow() throws SQLException {
        this.insertRow = new OracleRow(this.colCount, true);
        this.insertRowFlag = true;
        this.insertRowPosition = this.isAfterLast() ? this.presentRow : this.presentRow + 1;
    }

    public boolean next() throws SQLException {
        if (this.rowCount < 0) {
            return false;
        }
        if (this.fetchDirection == 1000 || this.fetchDirection == 1002) {
            if (this.presentRow + 1 <= this.rowCount) {
                ++this.presentRow;
                if (!this.showDeleted && this.getCurrentRow().isRowDeleted()) {
                    return this.next();
                }
                this.notifyCursorMovement();
                return true;
            }
            this.presentRow = this.rowCount + 1;
            return false;
        }
        if (this.fetchDirection == 1001) {
            if (this.presentRow - 1 > 0) {
                --this.presentRow;
                if (!this.showDeleted && this.getCurrentRow().isRowDeleted()) {
                    return this.next();
                }
                this.notifyCursorMovement();
                return true;
            }
            this.presentRow = 0;
            return false;
        }
        return false;
    }

    private final synchronized void notifyCursorMovement() {
        int n;
        if (this.insertRowFlag) {
            this.insertRowFlag = false;
            this.insertRow.setRowUpdated(false);
            this.sqlWarning.setNextWarning(new SQLWarning("Cancelling insertion, due to cursor movement."));
        } else if (this.updateRowFlag) {
            try {
                this.updateRowFlag = false;
                n = this.presentRow;
                this.presentRow = this.updateRowPosition;
                this.getCurrentRow().setRowUpdated(false);
                this.presentRow = n;
                this.sqlWarning.setNextWarning(new SQLWarning("Cancelling all updates, due to cursor movement."));
            }
            catch (SQLException sQLException) {}
        }
        n = this.listener.size();
        if (n > 0) {
            int n2 = 0;
            while (n2 < n) {
                ((RowSetListener)this.listener.elementAt(n2)).cursorMoved(this.rowsetEvent);
                ++n2;
            }
        }
    }

    private final void notifyRowChanged() {
        int n = this.listener.size();
        if (n > 0) {
            int n2 = 0;
            while (n2 < n) {
                ((RowSetListener)this.listener.elementAt(n2)).rowChanged(this.rowsetEvent);
                ++n2;
            }
        }
    }

    private final void notifyRowSetModified() {
        int n = this.listener.size();
        if (n > 0) {
            int n2 = 0;
            while (n2 < n) {
                ((RowSetListener)this.listener.elementAt(n2)).rowSetChanged(this.rowsetEvent);
                ++n2;
            }
        }
    }

    private final void notifyUpdateListeners() {
        int n = this.listener.size();
        if (n > 0) {
            int n2 = 0;
            while (n2 < n) {
                ((RowSetListener)this.listener.elementAt(n2)).rowChanged(this.rowsetEvent);
                ++n2;
            }
        }
    }

    public synchronized void populate(ResultSet resultSet) throws SQLException {
        this.rows = new Vector(50, 10);
        this.rowsetMetaData = new OracleRowSetMetaData(resultSet.getMetaData());
        this.colCount = this.rowsetMetaData.getColumnCount();
        this.metaData = new String[this.colCount];
        int n = 0;
        while (n < this.colCount) {
            this.metaData[n] = this.rowsetMetaData.getColumnName(n + 1);
            ++n;
        }
        this.populateInit(resultSet);
        this.rowCount = 0;
        OracleRow oracleRow = null;
        while (resultSet.next()) {
            oracleRow = new OracleRow(this.colCount);
            int n2 = 1;
            while (n2 <= this.colCount) {
                Object object = null;
                try {
                    object = resultSet.getObject(n2, this.typeMap);
                }
                catch (Exception exception) {
                    object = resultSet.getObject(n2);
                }
                catch (AbstractMethodError abstractMethodError) {
                    object = resultSet.getObject(n2);
                }
                if (object instanceof Clob || object instanceof CLOB) {
                    oracleRow.setColumnValue(n2, new OracleSerialClob((Clob)object));
                } else if (object instanceof Blob || object instanceof BLOB) {
                    oracleRow.setColumnValue(n2, new OracleSerialBlob((Blob)object));
                } else {
                    oracleRow.setColumnValue(n2, object);
                }
                ++n2;
            }
            this.rows.add(oracleRow);
            ++this.rowCount;
        }
        this.notifyRowSetModified();
    }

    private final void populateInit(ResultSet resultSet) throws SQLException {
        this.resultSet = resultSet;
        Statement statement = resultSet.getStatement();
        this.maxFieldSize = statement.getMaxFieldSize();
        this.maxRows = statement.getMaxRows();
        this.fetchSize = statement.getFetchSize();
        this.queryTimeout = statement.getQueryTimeout();
        this.connection = statement.getConnection();
        this.transactionIsolation = this.connection.getTransactionIsolation();
        this.typeMap = this.connection.getTypeMap();
        DatabaseMetaData databaseMetaData = this.connection.getMetaData();
        this.url = databaseMetaData.getURL();
        this.username = databaseMetaData.getUserName();
    }

    public boolean previous() throws SQLException {
        if (this.rowCount < 0) {
            return false;
        }
        if (this.fetchDirection == 1001) {
            if (this.presentRow + 1 <= this.rowCount) {
                ++this.presentRow;
                if (!this.showDeleted && this.getCurrentRow().isRowDeleted()) {
                    return this.previous();
                }
                this.notifyCursorMovement();
                return true;
            }
            this.presentRow = this.rowCount + 1;
            return false;
        }
        if (this.fetchDirection == 1000 || this.fetchDirection == 1002) {
            if (this.presentRow - 1 > 0) {
                --this.presentRow;
                if (!this.showDeleted && this.getCurrentRow().isRowDeleted()) {
                    return this.previous();
                }
                this.notifyCursorMovement();
                return true;
            }
            this.presentRow = 0;
            return false;
        }
        return false;
    }

    public void refreshRow() throws SQLException {
        OracleRow oracleRow = this.getCurrentRow();
        if (oracleRow.isRowUpdated()) {
            oracleRow.cancelRowUpdates();
        }
    }

    public boolean relative(int n) throws SQLException {
        return this.absolute(this.presentRow + n);
    }

    public void release() throws SQLException {
        this.rows = null;
        this.rows = new Vector();
        if (this.connection != null && !this.connection.isClosed()) {
            this.connection.close();
        }
        this.rowCount = 0;
        this.presentRow = 0;
    }

    public void removeRowSetListener(RowSetListener rowSetListener) {
        int n = 0;
        while (n < this.listener.size()) {
            if (this.listener.elementAt(n).equals(rowSetListener)) {
                this.listener.remove(n);
            }
            ++n;
        }
    }

    public void restoreOriginal() throws SQLException {
        boolean bl = false;
        int n = 0;
        while (n < this.rowCount) {
            OracleRow oracleRow = (OracleRow)this.rows.elementAt(n);
            if (oracleRow.isRowInserted()) {
                this.rows.remove(n);
                --this.rowCount;
                --n;
                bl = true;
            } else if (oracleRow.isRowUpdated()) {
                oracleRow.setRowUpdated(false);
                bl = true;
            } else if (oracleRow.isRowDeleted()) {
                oracleRow.setRowDeleted(false);
                bl = true;
            }
            ++n;
        }
        if (!bl) {
            throw new SQLException("None of the rows are changed");
        }
        this.presentRow = 0;
        System.gc();
    }

    public boolean rowDeleted() throws SQLException {
        return this.getCurrentRow().isRowDeleted();
    }

    public boolean rowInserted() throws SQLException {
        return this.getCurrentRow().isRowInserted();
    }

    public boolean rowUpdated() throws SQLException {
        return this.getCurrentRow().isRowUpdated();
    }

    public void setArray(int n, Array array) throws SQLException {
        this.checkParamIndex(n);
        this.param.add(n - 1, array);
    }

    public void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.checkParamIndex(n);
        Object[] objectArray = new Object[]{inputStream, new Integer(n2), new Integer(819)};
        this.param.add(n - 1, objectArray);
    }

    public void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        this.checkParamIndex(n);
        this.param.add(n - 1, bigDecimal);
    }

    public void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.checkParamIndex(n);
        Object[] objectArray = new Object[]{inputStream, new Integer(n2), new Integer(546)};
        this.param.add(n - 1, objectArray);
    }

    public void setBlob(int n, Blob blob) throws SQLException {
        this.checkParamIndex(n);
        this.param.add(n - 1, blob);
    }

    public void setBoolean(int n, boolean bl) throws SQLException {
        this.checkParamIndex(n);
        this.param.add(n - 1, new Boolean(bl));
    }

    public void setByte(int n, byte by) throws SQLException {
        this.checkParamIndex(n);
        this.param.add(n - 1, new Byte(by));
    }

    public void setBytes(int n, byte[] byArray) throws SQLException {
        this.checkParamIndex(n);
        this.param.add(n - 1, byArray);
    }

    public void setCharacterStream(int n, Reader reader, int n2) throws SQLException {
        this.checkParamIndex(n);
        Object[] objectArray = new Object[]{reader, new Integer(n2)};
        this.param.add(n - 1, objectArray);
    }

    public void setClob(int n, Clob clob) throws SQLException {
        this.checkParamIndex(n);
        this.param.add(n - 1, clob);
    }

    public void setCommand(String string) throws SQLException {
        this.command = string;
    }

    public void setConcurrency(int n) throws SQLException {
        if (n != 1007 && n != 1008) {
            throw new SQLException("Invalid concurrancy mode");
        }
        this.concurrency = n;
    }

    public void setDataSource(String string) {
        this.dataSource = string;
    }

    public void setDataSourceName(String string) throws SQLException {
        this.dataSourceName = string;
    }

    public void setDate(int n, Date date) throws SQLException {
        this.checkParamIndex(n);
        this.param.add(n - 1, date);
    }

    public void setDate(int n, Date date, Calendar calendar) throws SQLException {
        this.checkParamIndex(n);
        Object[] objectArray = new Object[]{date, calendar};
        this.param.add(n - 1, objectArray);
    }

    public void setDouble(int n, double d) throws SQLException {
        this.checkParamIndex(n);
        this.param.add(n - 1, new Double(d));
    }

    public void setEscapeProcessing(boolean bl) throws SQLException {
        this.escapeProcessing = bl;
    }

    public void setFetchDirection(int n) throws SQLException {
        if (this.type == 1005) {
            throw new SQLException("Fetch direction cannot be applied when RowSet type is TYPE_SCROLL_SENSITIVE");
        }
        switch (n) {
            case 1000: 
            case 1002: {
                this.presentRow = 0;
                break;
            }
            case 1001: {
                if (this.type == 1003) {
                    throw new SQLException("FETCH_REVERSE cannot be applied when RowSet type is TYPE_FORWARD_ONLY");
                }
                this.presentRow = this.rowCount + 1;
                break;
            }
            default: {
                throw new SQLException("Illegal fetch direction");
            }
        }
        this.fetchDirection = n;
    }

    public void setFetchSize(int n) throws SQLException {
        this.fetchSize = n;
    }

    public void setFloat(int n, float f) throws SQLException {
        this.checkParamIndex(n);
        this.param.add(n - 1, new Float(f));
    }

    public void setInt(int n, int n2) throws SQLException {
        this.checkParamIndex(n);
        this.param.add(n - 1, new Integer(n2));
    }

    public void setLong(int n, long l) throws SQLException {
        this.checkParamIndex(n);
        this.param.add(n - 1, new Long(l));
    }

    public void setMaxFieldSize(int n) throws SQLException {
        this.maxFieldSize = n;
    }

    public void setMaxRows(int n) throws SQLException {
        this.maxRows = n;
    }

    public void setMetaData(RowSetMetaData rowSetMetaData) {
        this.rowsetMetaData = rowSetMetaData;
    }

    public void setNull(int n, int n2) throws SQLException {
        this.checkParamIndex(n);
        this.param.add(n - 1, null);
    }

    public void setNull(int n, int n2, String string) throws SQLException {
        this.checkParamIndex(n);
        Object[] objectArray = new Object[]{new Integer(n2), string};
        this.param.add(n - 1, objectArray);
    }

    public void setObject(int n, Object object) throws SQLException {
        this.checkParamIndex(n);
        this.param.add(n - 1, object);
    }

    public void setObject(int n, Object object, int n2) throws SQLException {
        this.checkParamIndex(n);
        Object[] objectArray = new Object[]{object, new Integer(n2)};
        this.param.add(n - 1, objectArray);
    }

    public void setObject(int n, Object object, int n2, int n3) throws SQLException {
        this.checkParamIndex(n);
        Object[] objectArray = new Object[]{object, new Integer(n2), new Integer(n3)};
        this.param.add(n - 1, objectArray);
    }

    public void setPassword(String string) throws SQLException {
        this.password = string;
    }

    public void setQueryTimeout(int n) throws SQLException {
        this.queryTimeout = n;
    }

    public void setReadOnly(boolean bl) throws SQLException {
        this.readOnly = bl;
    }

    public void setReader(RowSetReader rowSetReader) {
        this.reader = rowSetReader;
    }

    public void setRef(int n, Ref ref) throws SQLException {
        this.checkParamIndex(n);
        this.param.add(n - 1, ref);
    }

    public void setShort(int n, short s) throws SQLException {
        this.checkParamIndex(n);
        this.param.add(n - 1, new Short(s));
    }

    public void setShowDeleted(boolean bl) {
        this.showDeleted = bl;
    }

    public void setString(int n, String string) throws SQLException {
        this.checkParamIndex(n);
        this.param.add(n - 1, string);
    }

    public void setTime(int n, Time time) throws SQLException {
        this.checkParamIndex(n);
        this.param.add(n - 1, time);
    }

    public void setTime(int n, Time time, Calendar calendar) throws SQLException {
        this.checkParamIndex(n);
        Object[] objectArray = new Object[]{time, calendar};
        this.param.add(n - 1, objectArray);
    }

    public void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        this.checkParamIndex(n);
        this.param.add(n - 1, timestamp);
    }

    public void setTimestamp(int n, Timestamp timestamp, Calendar calendar) throws SQLException {
        this.checkParamIndex(n);
        Object[] objectArray = new Object[]{timestamp, calendar};
        this.param.add(n - 1, objectArray);
    }

    public void setTransactionIsolation(int n) throws SQLException {
        this.transactionIsolation = n;
    }

    public void setType(int n) throws SQLException {
        if (n != 1003 && n != 1004 && n != 1005) {
            throw new SQLException("Unknown RowSet type");
        }
        this.type = n;
    }

    public void setTypeMap(Map map) throws SQLException {
        this.typeMap = map;
    }

    public void setUnicodeStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.checkParamIndex(n);
        Object[] objectArray = new Object[]{inputStream, new Integer(n2), new Integer(273)};
        this.param.add(n - 1, objectArray);
    }

    public void setUrl(String string) {
        this.url = string;
    }

    public void setUsername(String string) throws SQLException {
        this.username = string;
    }

    public void setWriter(RowSetWriter rowSetWriter) {
        this.writer = rowSetWriter;
    }

    public Collection toCollection() throws SQLException {
        Vector<Collection> vector = new Vector<Collection>(this.rowCount);
        int n = 0;
        while (n < this.rowCount) {
            vector.add(((OracleRow)this.rows.elementAt(n)).toCollection());
            ++n;
        }
        return vector;
    }

    public Collection toCollection(int n) throws SQLException {
        Vector<Object> vector = new Vector<Object>(1);
        OracleRow oracleRow = this.getCurrentRow();
        vector.add(oracleRow.isColumnChanged(n) ? oracleRow.getModifiedColumn(n) : oracleRow.getColumn(n));
        return vector;
    }

    public void updateArray(int n, Array array) throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
    }

    public void updateArray(String string, Array array) throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
    }

    public synchronized void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        try {
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            char[] cArray = new char[n2];
            int n3 = 0;
            while ((n3 += inputStreamReader.read(cArray, 0, n2 - n3)) != -1) {
            }
            this.updateObject(n, (Object)new CharArrayReader(cArray));
            cArray = null;
        }
        catch (IOException iOException) {
            throw new SQLException("Error while reading the Stream\n" + iOException.getMessage());
        }
    }

    public void updateAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        this.updateAsciiStream(this.getColumnIndex(string), inputStream, n);
    }

    public void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        this.updateObject(n, (Object)bigDecimal);
    }

    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        this.updateBigDecimal(this.getColumnIndex(string), bigDecimal);
    }

    public synchronized void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        try {
            byte[] byArray = new byte[n2];
            int n3 = 0;
            while ((n3 += inputStream.read(byArray, 0, n2 - n3)) != -1) {
            }
            this.updateObject(n, (Object)new ByteArrayInputStream(byArray));
            byArray = null;
        }
        catch (IOException iOException) {
            throw new SQLException("Error while reading the Stream\n" + iOException.getMessage());
        }
    }

    public void updateBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        this.updateBinaryStream(this.getColumnIndex(string), inputStream, n);
    }

    public void updateBlob(int n, Blob blob) throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
    }

    public void updateBlob(String string, Blob blob) throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
    }

    public void updateBoolean(int n, boolean bl) throws SQLException {
        this.updateObject(n, (Object)new Boolean(bl));
    }

    public void updateBoolean(String string, boolean bl) throws SQLException {
        this.updateBoolean(this.getColumnIndex(string), bl);
    }

    public void updateByte(int n, byte by) throws SQLException {
        this.updateObject(n, (Object)new Byte(by));
    }

    public void updateByte(String string, byte by) throws SQLException {
        this.updateByte(this.getColumnIndex(string), by);
    }

    public void updateBytes(int n, byte[] byArray) throws SQLException {
        this.updateObject(n, (Object)byArray);
    }

    public void updateBytes(String string, byte[] byArray) throws SQLException {
        this.updateBytes(this.getColumnIndex(string), byArray);
    }

    public synchronized void updateCharacterStream(int n, Reader reader, int n2) throws SQLException {
        this.checkColumnIndex(n);
        try {
            char[] cArray = new char[n2];
            int n3 = 0;
            while ((n3 += reader.read(cArray, 0, n2 - n3)) != -1) {
            }
            this.updateObject(n, (Object)new CharArrayReader(cArray));
            cArray = null;
        }
        catch (IOException iOException) {
            throw new SQLException("Error while reading the Stream\n" + iOException.getMessage());
        }
    }

    public void updateCharacterStream(String string, Reader reader, int n) throws SQLException {
        this.updateCharacterStream(this.getColumnIndex(string), reader, n);
    }

    public void updateClob(int n, Clob clob) throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
    }

    public void updateClob(String string, Clob clob) throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
    }

    public void updateDate(int n, Date date) throws SQLException {
        this.updateObject(n, (Object)new Timestamp(date.getYear(), date.getMonth(), date.getDate(), 0, 0, 0, 0));
    }

    public void updateDate(String string, Date date) throws SQLException {
        this.updateDate(this.getColumnIndex(string), date);
    }

    public void updateDouble(int n, double d) throws SQLException {
        this.updateObject(n, (Object)new Double(d));
    }

    public void updateDouble(String string, double d) throws SQLException {
        this.updateDouble(this.getColumnIndex(string), d);
    }

    public void updateFloat(int n, float f) throws SQLException {
        this.updateObject(n, (Object)new Float(f));
    }

    public void updateFloat(String string, float f) throws SQLException {
        this.updateFloat(this.getColumnIndex(string), f);
    }

    public void updateInt(int n, int n2) throws SQLException {
        this.updateObject(n, (Object)new Integer(n2));
    }

    public void updateInt(String string, int n) throws SQLException {
        this.updateInt(this.getColumnIndex(string), n);
    }

    public void updateLong(int n, long l) throws SQLException {
        this.updateObject(n, (Object)new Long(l));
    }

    public void updateLong(String string, long l) throws SQLException {
        this.updateLong(this.getColumnIndex(string), l);
    }

    public void updateNull(int n) throws SQLException {
        this.updateObject(n, null);
    }

    public void updateNull(String string) throws SQLException {
        this.updateNull(this.getColumnIndex(string));
    }

    public synchronized void updateObject(int n, Object object) throws SQLException {
        this.checkColumnIndex(n);
        if (this.insertRowFlag) {
            this.insertRow.updateObject(n, object);
        } else if (!this.isBeforeFirst() && !this.isAfterLast()) {
            this.updateRowFlag = true;
            this.updateRowPosition = this.presentRow;
            this.getCurrentRow().updateObject(n, object);
        } else {
            throw new SQLException("Updation not allowed on this column");
        }
    }

    public void updateObject(int n, Object object, int n2) throws SQLException {
        if (!(object instanceof Number)) {
            throw new SQLException("Passed object is not Numeric type");
        }
        this.updateObject(n, (Object)new BigDecimal(new BigInteger(((Number)object).toString()), n2));
    }

    public void updateObject(String string, Object object) throws SQLException {
        this.updateObject(this.getColumnIndex(string), object);
    }

    public void updateObject(String string, Object object, int n) throws SQLException {
        this.updateObject(this.getColumnIndex(string), object, n);
    }

    public void updateRef(int n, Ref ref) throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
    }

    public void updateRef(String string, Ref ref) throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
    }

    public void updateRow() throws SQLException {
        if (!this.updateRowFlag) {
            throw new SQLException("Current row not updated");
        }
        this.updateRowFlag = false;
        this.getCurrentRow().setRowUpdated(true);
        this.notifyUpdateListeners();
        this.notifyRowChanged();
        this.notifyRowSetModified();
    }

    public void updateShort(int n, short s) throws SQLException {
        this.updateObject(n, (Object)new Short(s));
    }

    public void updateShort(String string, short s) throws SQLException {
        this.updateShort(this.getColumnIndex(string), s);
    }

    public void updateString(int n, String string) throws SQLException {
        this.updateObject(n, (Object)string);
    }

    public void updateString(String string, String string2) throws SQLException {
        this.updateString(this.getColumnIndex(string), string2);
    }

    public void updateTime(int n, Time time) throws SQLException {
        this.updateObject(n, (Object)new Timestamp(0, 0, 0, time.getHours(), time.getMinutes(), time.getSeconds(), 0));
    }

    public void updateTime(String string, Time time) throws SQLException {
        this.updateTime(this.getColumnIndex(string), time);
    }

    public void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
        this.updateObject(n, (Object)timestamp);
    }

    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        this.updateTimestamp(this.getColumnIndex(string), timestamp);
    }

    public boolean wasNull() throws SQLException {
        return this.previousColumnWasNull;
    }
}

