/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.rowset;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.StringTokenizer;
import javax.sql.RowSet;
import javax.sql.RowSetInternal;
import javax.sql.RowSetWriter;
import oracle.jdbc.rowset.OracleCachedRowSet;
import oracle.jdbc.rowset.OracleCachedRowSetReader;
import oracle.jdbc.rowset.OracleRow;

public class OracleCachedRowSetWriter
implements RowSetWriter,
Serializable {
    private StringBuffer updateClause = new StringBuffer("");
    private StringBuffer deleteClause = new StringBuffer("");
    private StringBuffer insertClause = new StringBuffer("");
    private PreparedStatement insertStmt;
    private PreparedStatement updateStmt;
    private PreparedStatement deleteStmt;
    private ResultSetMetaData rsmd;
    private transient Connection connection;
    private int columnCount;

    private boolean deleteRow(OracleRow oracleRow) throws SQLException {
        this.deleteStmt.clearParameters();
        int n = 1;
        while (n <= this.columnCount) {
            this.deleteStmt.setObject(n, oracleRow.getColumn(n));
            ++n;
        }
        return this.deleteStmt.executeUpdate() == 1;
    }

    private String getSchemaName(RowSet rowSet) throws SQLException {
        return rowSet.getUsername();
    }

    private String getTableName(RowSet rowSet) throws SQLException {
        String string = rowSet.getCommand().toUpperCase();
        int n = string.indexOf(" FROM ");
        if (n == -1) {
            throw new SQLException("Could not parse the SQL String to get the table name.\n" + (string != "" ? string : "Please use RowSet.setCommand (String) to set the SQL query string."));
        }
        String string2 = string.substring(n + 6).trim();
        StringTokenizer stringTokenizer = new StringTokenizer(string2);
        if (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
        }
        return string2;
    }

    private void initSQLStatement(RowSet rowSet) throws SQLException {
        this.insertClause = new StringBuffer("INSERT INTO " + this.getTableName(rowSet) + "(");
        this.updateClause = new StringBuffer("UPDATE " + this.getTableName(rowSet) + " SET ");
        this.deleteClause = new StringBuffer("DELETE FROM " + this.getTableName(rowSet) + " WHERE ");
        this.rsmd = rowSet.getMetaData();
        this.columnCount = this.rsmd.getColumnCount();
        int n = 0;
        while (n < this.columnCount) {
            if (n != 0) {
                this.insertClause.append(", ");
            }
            this.insertClause.append(this.rsmd.getColumnName(n + 1));
            if (n != 0) {
                this.updateClause.append(", ");
            }
            this.updateClause.append(String.valueOf(this.rsmd.getColumnName(n + 1)) + " = ?");
            if (n != 0) {
                this.deleteClause.append(" AND ");
            }
            this.deleteClause.append(String.valueOf(this.rsmd.getColumnName(n + 1)) + " = ?");
            ++n;
        }
        this.insertClause.append(") VALUES (");
        this.updateClause.append(" WHERE ");
        int n2 = 0;
        while (n2 < this.columnCount) {
            if (n2 != 0) {
                this.insertClause.append(", ");
            }
            this.insertClause.append("?");
            if (n2 != 0) {
                this.updateClause.append(" AND ");
            }
            this.updateClause.append(String.valueOf(this.rsmd.getColumnName(n2 + 1)) + " = ?");
            ++n2;
        }
        this.insertClause.append(")");
        this.insertStmt = this.connection.prepareStatement(this.insertClause.toString());
        this.updateStmt = this.connection.prepareStatement(this.updateClause.toString());
        this.deleteStmt = this.connection.prepareStatement(this.deleteClause.toString());
    }

    private boolean insertRow(OracleRow oracleRow) throws SQLException {
        this.insertStmt.clearParameters();
        int n = 1;
        while (n <= this.columnCount) {
            Object object = null;
            Object object2 = object = oracleRow.isColumnChanged(n) ? oracleRow.getModifiedColumn(n) : oracleRow.getColumn(n);
            if (object == null) {
                this.insertStmt.setNull(n, this.rsmd.getColumnType(n));
            } else {
                this.insertStmt.setObject(n, object);
            }
            ++n;
        }
        return this.insertStmt.executeUpdate() == 1;
    }

    private boolean updateRow(OracleRow oracleRow) throws SQLException {
        this.updateStmt.clearParameters();
        int n = 1;
        while (n <= this.columnCount) {
            Object object = null;
            Object object2 = object = oracleRow.isColumnChanged(n) ? oracleRow.getModifiedColumn(n) : oracleRow.getColumn(n);
            if (object == null) {
                this.updateStmt.setNull(n, this.rsmd.getColumnType(n));
            } else {
                this.updateStmt.setObject(n, object);
            }
            ++n;
        }
        int n2 = 1;
        while (n2 <= this.columnCount) {
            this.updateStmt.setObject(n2 + this.columnCount, oracleRow.getColumn(n2));
            ++n2;
        }
        return this.updateStmt.executeUpdate() == 1;
    }

    public synchronized boolean writeData(RowSetInternal rowSetInternal) throws SQLException {
        OracleCachedRowSet oracleCachedRowSet = (OracleCachedRowSet)rowSetInternal;
        this.connection = ((OracleCachedRowSetReader)oracleCachedRowSet.getReader()).getConnection(rowSetInternal);
        if (this.connection == null) {
            throw new SQLException("Unable to get Connection");
        }
        if (this.connection.getAutoCommit()) {
            this.connection.setAutoCommit(false);
        }
        this.connection.setTransactionIsolation(oracleCachedRowSet.getTransactionIsolation());
        this.initSQLStatement(oracleCachedRowSet);
        if (this.columnCount < 1) {
            this.connection.close();
            return true;
        }
        boolean bl = oracleCachedRowSet.getShowDeleted();
        oracleCachedRowSet.setShowDeleted(true);
        oracleCachedRowSet.beforeFirst();
        boolean bl2 = true;
        boolean bl3 = true;
        boolean bl4 = true;
        OracleRow oracleRow = null;
        while (oracleCachedRowSet.next()) {
            if (oracleCachedRowSet.rowInserted()) {
                oracleRow = oracleCachedRowSet.getCurrentRow();
                bl3 = this.insertRow(oracleRow) || bl3;
                continue;
            }
            if (oracleCachedRowSet.rowUpdated()) {
                oracleRow = oracleCachedRowSet.getCurrentRow();
                bl2 = this.updateRow(oracleRow) || bl2;
                continue;
            }
            if (!oracleCachedRowSet.rowDeleted()) continue;
            oracleRow = oracleCachedRowSet.getCurrentRow();
            boolean bl5 = bl4 = this.deleteRow(oracleRow) || bl4;
        }
        if (bl2 && bl3 && bl4) {
            this.connection.commit();
        } else {
            this.connection.rollback();
        }
        this.insertStmt.close();
        this.updateStmt.close();
        this.deleteStmt.close();
        this.connection.close();
        oracleCachedRowSet.setShowDeleted(bl);
        return true;
    }
}

