/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.BfileAccessor;
import oracle.jdbc.driver.BinaryDoubleAccessor;
import oracle.jdbc.driver.BinaryFloatAccessor;
import oracle.jdbc.driver.Binder;
import oracle.jdbc.driver.BlobAccessor;
import oracle.jdbc.driver.CharAccessor;
import oracle.jdbc.driver.ClobAccessor;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.DateAccessor;
import oracle.jdbc.driver.IntervaldsAccessor;
import oracle.jdbc.driver.IntervalymAccessor;
import oracle.jdbc.driver.LongAccessor;
import oracle.jdbc.driver.LongRawAccessor;
import oracle.jdbc.driver.NamedTypeAccessor;
import oracle.jdbc.driver.NumberAccessor;
import oracle.jdbc.driver.OraclePreparedStatement;
import oracle.jdbc.driver.RawAccessor;
import oracle.jdbc.driver.RefTypeAccessor;
import oracle.jdbc.driver.RowidAccessor;
import oracle.jdbc.driver.T2CConnection;
import oracle.jdbc.driver.T2CNamedTypeAccessor;
import oracle.jdbc.driver.T2CResultSetAccessor;
import oracle.jdbc.driver.TimestampAccessor;
import oracle.jdbc.driver.TimestampltzAccessor;
import oracle.jdbc.driver.TimestamptzAccessor;
import oracle.jdbc.driver.VarcharAccessor;
import oracle.jdbc.oracore.OracleTypeADT;

class T2CPreparedStatement
extends OraclePreparedStatement {
    T2CConnection connection = null;
    int userResultSetType = -1;
    int userResultSetConcur = -1;
    static int T2C_EXTEND_BUFFER = -3;
    long[] t2cOutput = new long[10];
    private static final String _Copyright_2003_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "040121";

    T2CPreparedStatement(T2CConnection t2CConnection, String string, int n, int n2) throws SQLException {
        super(t2CConnection, string, n, n2);
        this.connection = t2CConnection;
    }

    T2CPreparedStatement(T2CConnection t2CConnection, String string, int n, int n2, int n3, int n4) throws SQLException {
        super(t2CConnection, string, n, n2, n3, n4);
        this.userResultSetType = n3;
        this.userResultSetConcur = n4;
        this.connection = t2CConnection;
    }

    Accessor allocateAccessor(int n, int n2, int n3, int n4, short s, String string, boolean bl) throws SQLException {
        if (n == 109) {
            if (string == null) {
                if (bl) {
                    DatabaseError.throwSqlException(12, "sqlType=" + n2);
                } else {
                    DatabaseError.throwSqlException(60, "Unable to resolve type \"null\"");
                }
            }
            T2CNamedTypeAccessor t2CNamedTypeAccessor = new T2CNamedTypeAccessor(this, string, s, n2, bl, n3 - 1);
            ((Accessor)t2CNamedTypeAccessor).initMetadata();
            return t2CNamedTypeAccessor;
        }
        if (n == 116 || n == 102) {
            if (bl && string != null) {
                DatabaseError.throwSqlException(12, "sqlType=" + n2);
            }
            T2CResultSetAccessor t2CResultSetAccessor = new T2CResultSetAccessor(this, n4, s, n2, bl);
            return t2CResultSetAccessor;
        }
        return super.allocateAccessor(n, n2, n3, n4, s, string, bl);
    }

    String bytes2String(byte[] byArray, int n, int n2) throws SQLException {
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        return this.connection.conversion.CharBytesToString(byArray2, n2);
    }

    void closeQuery() throws SQLException {
        if (this.streamList != null) {
            while (this.nextStream != null) {
                try {
                    this.nextStream.close();
                }
                catch (IOException iOException) {
                    DatabaseError.throwSqlException(iOException);
                }
                this.nextStream = this.nextStream.nextStream;
            }
        }
    }

    void closeUsedStreams(int n) throws SQLException {
        block5: {
            while (this.nextStream != null && this.nextStream.columnIndex < n) {
                try {
                    this.nextStream.close();
                }
                catch (IOException iOException) {
                    DatabaseError.throwSqlException(iOException);
                }
                this.nextStream = this.nextStream.nextStream;
            }
            if (this.nextStream == null) break block5;
            try {
                this.nextStream.needBytes();
            }
            catch (IOException iOException) {
                DatabaseError.throwSqlException(iOException);
            }
        }
    }

    void doDefineExecuteFetch() throws SQLException {
        short[] sArray = null;
        if (this.need_to_prepare_define_buffer || this.need_to_parse) {
            this.setupForDefine();
            sArray = this.connection.queryMetaData1;
        }
        this.t2cOutput[0] = 0L;
        this.t2cOutput[2] = 0L;
        byte[] byArray = this.m_sql.getSqlBytes();
        this.valid_rows = this.t2cDefineExecuteFetch(this.c_state, this.number_of_define_positions, this.number_of_bind_positions, this.number_of_bind_rows_allocated, this.first_row_in_batch, false, this.need_to_parse, byArray, byArray.length, this.sql_kind, this.row_prefetch, this.batch, this.bindIndicators, this.bindIndicatorOffset, this.bindBytes, this.bindChars, this.bindByteOffset, this.bindCharOffset, sArray, this.connection.queryMetaData2, this.connection.queryMetaData1Offset, this.connection.queryMetaData2Offset, this.prepared_all_binds, this.prepared_char_binds, this.accessors, this.parameterDatum, this.t2cOutput, this.defineBytes, this.accessorByteOffset, this.defineChars, this.accessorCharOffset, this.defineIndicators, this.accessorShortOffset);
        if (this.valid_rows == -1) {
            this.connection.checkError(this.valid_rows);
        }
        if (this.t2cOutput[2] != 0L) {
            this.connection.checkError(1);
        }
        this.connection.endToEndECIDSequenceNumber = (short)this.t2cOutput[4];
        this.need_to_parse = false;
    }

    void doDefineFetch() throws SQLException {
        if (!this.need_to_prepare_define_buffer) {
            throw new Error("doDefineFetch called when need_to_prepare_define_buffer=false " + this.m_sql.getSql());
        }
        this.setupForDefine();
        this.valid_rows = this.t2cDefineFetch(this.c_state, this.row_prefetch, this.connection.queryMetaData1, this.connection.queryMetaData2, this.connection.queryMetaData1Offset, this.connection.queryMetaData2Offset, this.accessors, this.defineBytes, this.accessorByteOffset, this.defineChars, this.accessorCharOffset, this.defineIndicators, this.accessorShortOffset);
        if (this.valid_rows == -1) {
            this.connection.checkError(this.valid_rows);
        }
    }

    void do_close() throws SQLException {
        int n;
        if (this.defineBytes != null) {
            this.defineBytes = null;
            this.accessorByteOffset = 0;
        }
        if (this.defineChars != null) {
            this.defineChars = null;
            this.accessorCharOffset = 0;
        }
        if (this.defineIndicators != null) {
            this.defineIndicators = null;
            this.accessorShortOffset = 0;
        }
        if ((n = this.t2cCloseStatement(this.c_state)) != 0) {
            this.connection.checkError(n);
        }
        this.t2cOutput = null;
    }

    void do_describe(boolean bl) throws SQLException {
        boolean bl2;
        if (this.closed) {
            DatabaseError.throwSqlException(9);
        }
        if (this.described) {
            return;
        }
        do {
            bl2 = false;
            this.number_of_define_positions = this.t2cDescribe(this.c_state, this.connection.queryMetaData1, this.connection.queryMetaData2, this.connection.queryMetaData1Offset, this.connection.queryMetaData2Offset, this.connection.queryMetaData1Size, this.connection.queryMetaData2Size);
            if (this.number_of_define_positions == -1) {
                this.connection.checkError(this.number_of_define_positions);
            }
            if (this.number_of_define_positions != T2C_EXTEND_BUFFER) continue;
            bl2 = true;
            this.connection.reallocateQueryMetaData(this.connection.queryMetaData1Size * 2, this.connection.queryMetaData2Size * 2);
        } while (bl2);
        this.processDescribeData();
    }

    void execute_for_describe() throws SQLException {
        boolean bl;
        this.t2cOutput[0] = 0L;
        this.t2cOutput[2] = 0L;
        boolean bl2 = this.described ^ true;
        boolean bl3 = false;
        do {
            bl = false;
            if (this.connection.endToEndAnyChanged) {
                this.pushEndToEndValues();
                this.connection.endToEndAnyChanged = false;
            }
            byte[] byArray = this.m_sql.getSqlBytes();
            int n = this.t2cParseExecuteDescribe(this.c_state, this.number_of_bind_positions, this.number_of_bind_rows_allocated, this.first_row_in_batch, false, this.need_to_parse, bl2, bl3, byArray, byArray.length, this.sql_kind, this.row_prefetch, this.batch, this.bindIndicators, this.bindIndicatorOffset, this.bindBytes, this.bindChars, this.bindByteOffset, this.bindCharOffset, this.ibtBindIndicators, this.ibtBindIndicatorOffset, this.ibtBindIndicatorSize, this.ibtBindBytes, this.ibtBindChars, this.ibtBindByteOffset, this.ibtBindCharOffset, this.connection.queryMetaData1, this.connection.queryMetaData2, this.connection.queryMetaData1Offset, this.connection.queryMetaData2Offset, this.connection.queryMetaData1Size, this.connection.queryMetaData2Size, this.prepared_all_binds, this.prepared_char_binds, this.accessors, this.parameterDatum, this.t2cOutput, this.defineBytes, this.accessorByteOffset, this.defineChars, this.accessorCharOffset, this.defineIndicators, this.accessorShortOffset, this.connection.plsqlCompilerWarnings);
            this.valid_rows = (int)this.t2cOutput[1];
            if (n == -1) {
                this.connection.checkError(n);
            } else if (n == T2C_EXTEND_BUFFER) {
                n = this.connection.queryMetaData1Size * 2;
            }
            if (this.t2cOutput[3] != 0L) {
                this.connection.foundPlsqlCompilerWarning();
            } else if (this.t2cOutput[2] != 0L) {
                this.connection.checkError(1);
            }
            this.connection.endToEndECIDSequenceNumber = (short)this.t2cOutput[4];
            this.need_to_parse = false;
            bl3 = true;
            if (this.sql_kind == 0) {
                this.number_of_define_positions = n;
                if (this.number_of_define_positions <= this.connection.queryMetaData1Size) continue;
                bl = true;
                bl3 = true;
                this.connection.reallocateQueryMetaData(this.number_of_define_positions, this.number_of_define_positions * 8);
                continue;
            }
            this.number_of_define_positions = 0;
            this.valid_rows = n;
        } while (bl);
        this.processDescribeData();
    }

    void execute_for_rows(boolean bl) throws SQLException {
        if (this.connection.endToEndAnyChanged) {
            this.pushEndToEndValues();
            this.connection.endToEndAnyChanged = false;
        }
        if (!bl) {
            if (this.number_of_define_positions > 0) {
                this.doDefineExecuteFetch();
            } else {
                this.execute_for_describe();
            }
        } else if (this.number_of_define_positions > 0) {
            this.doDefineFetch();
        }
        this.need_to_prepare_define_buffer = false;
    }

    void fetch() throws SQLException {
        if (this.number_of_define_positions > 0) {
            if (this.need_to_prepare_define_buffer) {
                this.doDefineFetch();
            } else {
                this.valid_rows = this.t2cFetch(this.c_state, this.need_to_prepare_define_buffer, this.row_prefetch, this.accessors, this.defineBytes, this.accessorByteOffset, this.defineChars, this.accessorCharOffset, this.defineIndicators, this.accessorShortOffset);
                if (this.valid_rows == -1) {
                    this.connection.checkError(this.valid_rows);
                }
            }
        }
    }

    void initializeIndicatorSubRange() {
        this.bindIndicatorSubRange = this.number_of_bind_positions * 5;
    }

    void prepareBindPreambles(int n, int n2) {
        int n3 = this.bindIndicatorSubRange;
        this.initializeIndicatorSubRange();
        int n4 = this.bindIndicatorSubRange;
        this.bindIndicatorSubRange = n3;
        int n5 = this.bindIndicatorSubRange - n4;
        OracleTypeADT[] oracleTypeADTArray = this.parameterOtype == null ? null : this.parameterOtype[this.first_row_in_batch];
        int n6 = 0;
        while (n6 < this.number_of_bind_positions) {
            int n7;
            OracleTypeADT oracleTypeADT;
            Binder binder = this.lastBinders[n6];
            OracleTypeADT oracleTypeADT2 = oracleTypeADT = oracleTypeADTArray == null ? null : oracleTypeADTArray[n6];
            if (this.outBindAccessors == null) {
                n7 = 0;
            } else {
                Accessor accessor = this.outBindAccessors[n6];
                if (accessor == null) {
                    n7 = 0;
                } else if (binder == this.theOutBinder) {
                    n7 = 1;
                    if (oracleTypeADT == null) {
                        oracleTypeADT = (OracleTypeADT)accessor.t_otype;
                    }
                } else {
                    n7 = 2;
                }
            }
            if (binder == this.theSetCHARBinder) {
                n7 = (short)(n7 | 4);
            }
            this.bindIndicators[n5++] = n7;
            if (oracleTypeADT != null) {
                long l = oracleTypeADT.getTDO_C_STATE();
                this.bindIndicators[n5] = (short)(l >> 48 & 0xFFFFL);
                this.bindIndicators[n5 + 1] = (short)(l >> 32 & 0xFFFFL);
                this.bindIndicators[n5 + 2] = (short)(l >> 16 & 0xFFFFL);
                this.bindIndicators[n5 + 3] = (short)(l & 0xFFFFL);
            }
            n5 += 4;
            ++n6;
        }
    }

    void processDescribeData() throws SQLException {
        this.described = true;
        this.describedWithNames = true;
        if (this.accessors == null || this.number_of_define_positions > this.accessors.length) {
            this.accessors = new Accessor[this.number_of_define_positions];
        }
        int n = this.connection.queryMetaData1Offset;
        int n2 = this.connection.queryMetaData2Offset;
        short[] sArray = this.connection.queryMetaData1;
        byte[] byArray = this.connection.queryMetaData2;
        int n3 = 0;
        while (n3 < this.number_of_define_positions) {
            Accessor accessor;
            short s = sArray[n];
            short s2 = sArray[n + 1];
            short s3 = sArray[n + 11];
            boolean bl = sArray[n + 2] != 0;
            short s4 = sArray[n + 3];
            short s5 = sArray[n + 4];
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            short s6 = sArray[n + 5];
            short s7 = sArray[n + 6];
            String string = this.bytes2String(byArray, n2, s7);
            short s8 = sArray[n + 12];
            String string2 = null;
            OracleTypeADT oracleTypeADT = null;
            n2 += s7;
            if (s8 > 0) {
                string2 = this.bytes2String(byArray, n2, s8);
                n2 += s8;
                oracleTypeADT = new OracleTypeADT(string2);
                oracleTypeADT.tdo_c_state = ((long)sArray[n + 7] & 0xFFFFL) << 48 | ((long)sArray[n + 8] & 0xFFFFL) << 32 | ((long)sArray[n + 9] & 0xFFFFL) << 16 | (long)sArray[n + 10] & 0xFFFFL;
            }
            if ((accessor = this.accessors[n3]) != null && !accessor.useForDescribeIfPossible(s, s2, bl, n4, s4, s5, n5, n6, s6, string2)) {
                accessor = null;
            }
            if (accessor == null) {
                switch (s) {
                    case 1: {
                        accessor = new VarcharAccessor(this, s2, bl, n4, s4, s5, n5, n6, s6);
                        if (s3 <= 0) break;
                        accessor.setDisplaySize(s3);
                        break;
                    }
                    case 96: {
                        accessor = new CharAccessor(this, s2, bl, n4, s4, s5, n5, n6, s6);
                        if (s3 <= 0) break;
                        accessor.setDisplaySize(s3);
                        break;
                    }
                    case 2: {
                        accessor = new NumberAccessor(this, s2, bl, n4, s4, s5, n5, n6, s6);
                        break;
                    }
                    case 23: {
                        accessor = new RawAccessor(this, s2, bl, n4, s4, s5, n5, n6, s6);
                        break;
                    }
                    case 100: {
                        accessor = new BinaryFloatAccessor(this, s2, bl, n4, s4, s5, n5, n6, s6);
                        break;
                    }
                    case 101: {
                        accessor = new BinaryDoubleAccessor(this, s2, bl, n4, s4, s5, n5, n6, s6);
                        break;
                    }
                    case 8: {
                        accessor = new LongAccessor(this, n3 + 1, s2, bl, n4, s4, s5, n5, n6, s6);
                        this.row_prefetch = 1;
                        break;
                    }
                    case 24: {
                        accessor = new LongRawAccessor(this, n3 + 1, s2, bl, n4, s4, s5, n5, n6, s6);
                        this.row_prefetch = 1;
                        break;
                    }
                    case 104: {
                        accessor = new RowidAccessor(this, s2, bl, n4, s4, s5, n5, n6, s6);
                        break;
                    }
                    case 102: 
                    case 116: {
                        accessor = new T2CResultSetAccessor(this, s2, bl, n4, s4, s5, n5, n6, s6);
                        break;
                    }
                    case 12: {
                        accessor = new DateAccessor(this, s2, bl, n4, s4, s5, n5, n6, s6);
                        break;
                    }
                    case 180: {
                        accessor = new TimestampAccessor(this, s2, bl, n4, s4, s5, n5, n6, s6);
                        break;
                    }
                    case 181: {
                        accessor = new TimestamptzAccessor(this, s2, bl, n4, s4, s5, n5, n6, s6);
                        break;
                    }
                    case 231: {
                        accessor = new TimestampltzAccessor(this, s2, bl, n4, s4, s5, n5, n6, s6);
                        break;
                    }
                    case 182: {
                        accessor = new IntervalymAccessor(this, s2, bl, n4, s4, s5, n5, n6, s6);
                        break;
                    }
                    case 183: {
                        accessor = new IntervaldsAccessor(this, s2, bl, n4, s4, s5, n5, n6, s6);
                        break;
                    }
                    case 112: {
                        accessor = new ClobAccessor(this, s2, bl, n4, s4, s5, n5, n6, s6);
                        break;
                    }
                    case 113: {
                        accessor = new BlobAccessor(this, s2, bl, n4, s4, s5, n5, n6, s6);
                        break;
                    }
                    case 114: {
                        accessor = new BfileAccessor(this, s2, bl, n4, s4, s5, n5, n6, s6);
                        break;
                    }
                    case 109: {
                        accessor = new NamedTypeAccessor(this, s2, bl, n4, s4, s5, n5, n6, s6, string2, oracleTypeADT);
                        break;
                    }
                    case 111: {
                        accessor = new RefTypeAccessor(this, s2, bl, n4, s4, s5, n5, n6, s6, string2, oracleTypeADT);
                        break;
                    }
                    default: {
                        throw new SQLException("Unknown or unimplemented accessor type: " + s);
                    }
                    case 998: 
                }
                this.accessors[n3] = accessor;
            } else if (oracleTypeADT != null) {
                accessor.initMetadata();
            }
            accessor.columnName = string;
            ++n3;
            n += 13;
        }
    }

    void pushEndToEndValues() throws SQLException {
        T2CConnection t2CConnection = this.connection;
        byte[] byArray = new byte[]{};
        byte[] byArray2 = new byte[]{};
        byte[] byArray3 = new byte[]{};
        byte[] byArray4 = new byte[]{};
        if (t2CConnection.endToEndValues != null) {
            String string;
            if (t2CConnection.endToEndHasChanged[0]) {
                string = t2CConnection.endToEndValues[0];
                if (string != null) {
                    byArray = DBConversion.stringToDriverCharBytes(string, t2CConnection.m_clientCharacterSet);
                }
                t2CConnection.endToEndHasChanged[0] = false;
            }
            if (t2CConnection.endToEndHasChanged[1]) {
                string = t2CConnection.endToEndValues[1];
                if (string != null) {
                    byArray2 = DBConversion.stringToDriverCharBytes(string, t2CConnection.m_clientCharacterSet);
                }
                t2CConnection.endToEndHasChanged[1] = false;
            }
            if (t2CConnection.endToEndHasChanged[2]) {
                string = t2CConnection.endToEndValues[2];
                if (string != null) {
                    byArray3 = DBConversion.stringToDriverCharBytes(string, t2CConnection.m_clientCharacterSet);
                }
                t2CConnection.endToEndHasChanged[2] = false;
            }
            if (t2CConnection.endToEndHasChanged[3]) {
                string = t2CConnection.endToEndValues[3];
                if (string != null) {
                    byArray4 = DBConversion.stringToDriverCharBytes(string, t2CConnection.m_clientCharacterSet);
                }
                t2CConnection.endToEndHasChanged[3] = false;
            }
            this.t2cEndToEndUpdate(this.c_state, byArray, byArray.length, byArray2, byArray2.length, byArray3, byArray3.length, byArray4, byArray4.length, t2CConnection.endToEndECIDSequenceNumber);
        }
    }

    void setupForDefine() throws SQLException {
        short[] sArray = this.connection.queryMetaData1;
        int n = this.connection.queryMetaData1Offset;
        int n2 = 0;
        while (n2 < this.number_of_define_positions) {
            Accessor accessor = this.accessors[n2];
            if (accessor == null) {
                DatabaseError.throwSqlException(21);
            }
            sArray[n] = (short)accessor.d_type;
            sArray[n + 11] = (short)accessor.charLength;
            sArray[n + 1] = (short)accessor.byteLength;
            sArray[n + 5] = accessor.formOfUse;
            if (accessor.t_otype != null) {
                long l = ((OracleTypeADT)accessor.t_otype).getTDO_C_STATE();
                sArray[n + 7] = (short)((l & 0xFFFF000000000000L) >> 48);
                sArray[n + 8] = (short)((l & 0xFFFF00000000L) >> 32);
                sArray[n + 9] = (short)((l & 0xFFFF0000L) >> 16);
                sArray[n + 10] = (short)(l & 0xFFFFL);
            }
            ++n2;
            n += 13;
        }
    }

    native int t2cCloseStatement(long var1);

    native int t2cDefineExecuteFetch(long var1, int var3, int var4, int var5, int var6, boolean var7, boolean var8, byte[] var9, int var10, byte var11, int var12, int var13, short[] var14, int var15, byte[] var16, char[] var17, int var18, int var19, short[] var20, byte[] var21, int var22, int var23, boolean var24, boolean var25, Accessor[] var26, byte[][][] var27, long[] var28, byte[] var29, int var30, char[] var31, int var32, short[] var33, int var34);

    native int t2cDefineFetch(long var1, int var3, short[] var4, byte[] var5, int var6, int var7, Accessor[] var8, byte[] var9, int var10, char[] var11, int var12, short[] var13, int var14);

    native int t2cDescribe(long var1, short[] var3, byte[] var4, int var5, int var6, int var7, int var8);

    native int t2cEndToEndUpdate(long var1, byte[] var3, int var4, byte[] var5, int var6, byte[] var7, int var8, byte[] var9, int var10, int var11);

    native int t2cFetch(long var1, boolean var3, int var4, Accessor[] var5, byte[] var6, int var7, char[] var8, int var9, short[] var10, int var11);

    native int t2cParseExecuteDescribe(long var1, int var3, int var4, int var5, boolean var6, boolean var7, boolean var8, boolean var9, byte[] var10, int var11, byte var12, int var13, int var14, short[] var15, int var16, byte[] var17, char[] var18, int var19, int var20, short[] var21, int var22, int var23, byte[] var24, char[] var25, int var26, int var27, short[] var28, byte[] var29, int var30, int var31, int var32, int var33, boolean var34, boolean var35, Accessor[] var36, byte[][][] var37, long[] var38, byte[] var39, int var40, char[] var41, int var42, short[] var43, int var44, boolean var45);
}

