/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.sql.SQLException;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.oracore.OracleNamedType;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.jdbc.oracore.OracleTypeCOLLECTION;
import oracle.jdbc.oracore.OracleTypeUPT;

public class TDSPatch {
    static final int S_NORMAL_PATCH = 0;
    static final int S_SIMPLE_PATCH = 1;
    int typeId;
    OracleType owner;
    long position;
    int uptCode;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Wed_Jul_25_08:30:23_PDT_2007";
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;

    public TDSPatch(int n2, OracleType oracleType, long l2, int n3) throws SQLException {
        this.typeId = n2;
        this.owner = oracleType;
        this.position = l2;
        this.uptCode = n3;
    }

    int getType() throws SQLException {
        return this.typeId;
    }

    OracleNamedType getOwner() throws SQLException {
        return (OracleNamedType)this.owner;
    }

    long getPosition() throws SQLException {
        return this.position;
    }

    byte getUptTypeCode() throws SQLException {
        return (byte)this.uptCode;
    }

    void apply(OracleType oracleType) throws SQLException {
        this.apply(oracleType, -1);
    }

    void apply(OracleType oracleType, int n2) throws SQLException {
        if (this.typeId == 0) {
            OracleTypeUPT oracleTypeUPT = (OracleTypeUPT)this.owner;
            oracleTypeUPT.realType = (OracleTypeADT)oracleType;
            if (oracleType instanceof OracleNamedType) {
                OracleNamedType oracleNamedType = (OracleNamedType)oracleType;
                oracleNamedType.setParent(oracleTypeUPT.getParent());
                oracleNamedType.setOrder(oracleTypeUPT.getOrder());
            }
        } else if (this.typeId == 1) {
            OracleTypeCOLLECTION oracleTypeCOLLECTION = (OracleTypeCOLLECTION)this.owner;
            oracleTypeCOLLECTION.opcode = n2;
            oracleTypeCOLLECTION.elementType = oracleType;
            if (oracleType instanceof OracleNamedType) {
                OracleNamedType oracleNamedType = (OracleNamedType)oracleType;
                oracleNamedType.setParent(oracleTypeCOLLECTION);
                oracleNamedType.setOrder(1);
            }
        } else {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 1);
        }
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        return null;
    }
}

