/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.sort;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.CardinalityChecker;
import net.sf.saxon.expr.ComputedExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.FirstItemExpression;
import net.sf.saxon.expr.Optimizer;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMinor;
import net.sf.saxon.om.EmptyIterator;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.sort.FixedSortKeyDefinition;
import net.sf.saxon.sort.SortKeyDefinition;
import net.sf.saxon.sort.SortedIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.Value;

public class SortExpression
extends ComputedExpression {
    private Expression select = null;
    private SortKeyDefinition[] sortKeys = null;
    private FixedSortKeyDefinition[] fixedSortKeys = null;

    public SortExpression(Expression expression, SortKeyDefinition[] sortKeyDefinitionArray) {
        this.select = expression;
        this.sortKeys = sortKeyDefinitionArray;
        boolean bl = true;
        for (int i = 0; i < sortKeyDefinitionArray.length; ++i) {
            sortKeyDefinitionArray[i].setParentExpression(this);
            if (sortKeyDefinitionArray[i] instanceof FixedSortKeyDefinition) continue;
            bl = false;
        }
        if (bl) {
            this.fixedSortKeys = new FixedSortKeyDefinition[sortKeyDefinitionArray.length];
            System.arraycopy(sortKeyDefinitionArray, 0, this.fixedSortKeys, 0, sortKeyDefinitionArray.length);
        }
        Iterator iterator = this.iterateSubExpressions();
        while (iterator.hasNext()) {
            Expression expression2 = (Expression)iterator.next();
            this.adoptChildExpression(expression2);
        }
    }

    public Iterator iterateSubExpressions() {
        ArrayList<Expression> arrayList = new ArrayList<Expression>(8);
        arrayList.add(this.select);
        for (int i = 0; i < this.sortKeys.length; ++i) {
            arrayList.add(this.sortKeys[i].getSortKey());
            Expression expression = this.sortKeys[i].order;
            if (expression != null && !(expression instanceof Value)) {
                arrayList.add(expression);
            }
            if ((expression = this.sortKeys[i].caseOrder) != null && !(expression instanceof Value)) {
                arrayList.add(expression);
            }
            if ((expression = this.sortKeys[i].dataTypeExpression) != null && !(expression instanceof Value)) {
                arrayList.add(expression);
            }
            if ((expression = this.sortKeys[i].language) != null && !(expression instanceof Value)) {
                arrayList.add(expression);
            }
            if ((expression = this.sortKeys[i].collationName) == null || expression instanceof Value) continue;
            arrayList.add(expression);
        }
        return arrayList.iterator();
    }

    public Expression simplify(StaticContext staticContext) throws XPathException {
        this.select = this.select.simplify(staticContext);
        return this;
    }

    public Expression typeCheck(StaticContext staticContext, ItemType itemType) throws XPathException {
        this.select = this.select.typeCheck(staticContext, itemType);
        for (int i = 0; i < this.sortKeys.length; ++i) {
            Expression expression = this.sortKeys[i].getSortKey();
            if (staticContext.isInBackwardsCompatibleMode()) {
                expression = new FirstItemExpression(expression);
            } else {
                RoleLocator roleLocator = new RoleLocator(4, "xsl:sort/select", 0, null);
                roleLocator.setErrorCode("XTTE1020");
                expression = CardinalityChecker.makeCardinalityChecker(expression, 24576, roleLocator);
            }
            this.sortKeys[i].setSortKey(expression);
            if (this.fixedSortKeys == null) continue;
            this.fixedSortKeys[i].setSortKey(expression);
        }
        return this;
    }

    public Expression optimize(Optimizer optimizer, StaticContext staticContext, ItemType itemType) throws XPathException {
        if (Cardinality.allowsMany(this.select.getCardinality())) {
            return this;
        }
        if (this.select instanceof ComputedExpression) {
            ((ComputedExpression)this.select).setParentExpression(this.getParentExpression());
        }
        return this.select;
    }

    public Expression promote(PromotionOffer promotionOffer) throws XPathException {
        Expression expression = promotionOffer.accept(this);
        if (expression != null) {
            return expression;
        }
        this.select = this.doPromotion(this.select, promotionOffer);
        for (int i = 0; i < this.sortKeys.length; ++i) {
            this.sortKeys[i].setSortKey(this.sortKeys[i].getSortKey().promote(promotionOffer));
            if (this.sortKeys[i].caseOrder != null) {
                this.sortKeys[i].caseOrder = this.sortKeys[i].caseOrder.promote(promotionOffer);
            }
            if (this.sortKeys[i].dataTypeExpression != null) {
                this.sortKeys[i].dataTypeExpression = this.sortKeys[i].dataTypeExpression.promote(promotionOffer);
            }
            if (this.sortKeys[i].language != null) {
                this.sortKeys[i].language = this.sortKeys[i].language.promote(promotionOffer);
            }
            if (this.sortKeys[i].collationName == null) continue;
            this.sortKeys[i].collationName = this.sortKeys[i].collationName.promote(promotionOffer);
        }
        return this;
    }

    public boolean isSortKey(Expression expression) {
        for (int i = 0; i < this.sortKeys.length; ++i) {
            Expression expression2 = this.sortKeys[i].getSortKey();
            if (expression2 != expression) continue;
            return true;
        }
        return false;
    }

    public int computeCardinality() {
        return this.select.getCardinality();
    }

    public ItemType getItemType(TypeHierarchy typeHierarchy) {
        return this.select.getItemType(typeHierarchy);
    }

    public int computeSpecialProperties() {
        int n = 0;
        if ((this.select.getSpecialProperties() & 0x10000) != 0) {
            n |= 0x10000;
        }
        if ((this.select.getSpecialProperties() & 0x800000) != 0) {
            n |= 0x800000;
        }
        if ((this.select.getSpecialProperties() & 0x400000) != 0) {
            n |= 0x400000;
        }
        return n;
    }

    public SequenceIterator iterate(XPathContext xPathContext) throws XPathException {
        FixedSortKeyDefinition[] fixedSortKeyDefinitionArray;
        SequenceIterator sequenceIterator = this.select.iterate(xPathContext);
        if (sequenceIterator instanceof EmptyIterator) {
            return sequenceIterator;
        }
        XPathContextMinor xPathContextMinor = xPathContext.newMinorContext();
        xPathContextMinor.setOrigin(this);
        if (this.fixedSortKeys != null) {
            fixedSortKeyDefinitionArray = this.fixedSortKeys;
        } else {
            fixedSortKeyDefinitionArray = new FixedSortKeyDefinition[this.sortKeys.length];
            for (int i = 0; i < this.sortKeys.length; ++i) {
                fixedSortKeyDefinitionArray[i] = this.sortKeys[i].reduce(xPathContextMinor);
            }
        }
        sequenceIterator = new SortedIterator(xPathContextMinor, sequenceIterator, fixedSortKeyDefinitionArray);
        ((SortedIterator)sequenceIterator).setHostLanguage(this.getHostLanguage());
        return sequenceIterator;
    }

    public void display(int n, PrintStream printStream, Configuration configuration) {
        printStream.println(ExpressionTool.indent(n) + "sort");
        this.select.display(n + 1, printStream, configuration);
    }
}

