/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.util.StringTokenizer;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.DecimalValue;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.MonthDurationValue;
import net.sf.saxon.value.SecondsDurationValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.value.ValidationErrorValue;
import net.sf.saxon.value.Value;

public class DurationValue
extends AtomicValue {
    protected boolean negative = false;
    protected int years = 0;
    protected int months = 0;
    protected int days = 0;
    protected int hours = 0;
    protected int minutes = 0;
    protected int seconds = 0;
    protected int microseconds = 0;
    private boolean normalized = false;
    static /* synthetic */ Class class$net$sf$saxon$value$DurationValue;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$CharSequence;
    static /* synthetic */ Class class$java$lang$Object;

    protected DurationValue() {
    }

    public DurationValue(boolean bl, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        this.negative = !bl;
        this.years = n;
        this.months = n2;
        this.days = n3;
        this.hours = n4;
        this.minutes = n5;
        this.seconds = n6;
        this.microseconds = n7;
        this.normalizeZeroDuration();
        this.normalized = n2 < 12 && n4 < 24 && n5 < 60 && n6 < 60 && n7 < 1000000;
    }

    protected void normalizeZeroDuration() {
        if (this.years == 0 && this.months == 0 && this.days == 0 && this.hours == 0 && this.minutes == 0 && this.seconds == 0 && this.microseconds == 0) {
            this.negative = false;
        }
    }

    public DurationValue(CharSequence charSequence) throws XPathException {
        StringTokenizer stringTokenizer = new StringTokenizer(((Object)DurationValue.trimWhitespace(charSequence)).toString(), "-+.PYMDTHS", true);
        int n = 0;
        try {
            String string;
            if (!stringTokenizer.hasMoreElements()) {
                this.badDuration("empty string", charSequence);
            }
            if ("+".equals(string = (String)stringTokenizer.nextElement())) {
                this.badDuration("+ sign not allowed in a duration", charSequence);
            } else if ("-".equals(string)) {
                this.negative = true;
                string = (String)stringTokenizer.nextElement();
            }
            if (!"P".equals(string)) {
                this.badDuration("missing 'P'", charSequence);
            }
            int n2 = 0;
            block10: while (stringTokenizer.hasMoreElements()) {
                string = (String)stringTokenizer.nextElement();
                if ("T".equals(string)) {
                    n2 = 4;
                    if (!stringTokenizer.hasMoreElements()) {
                        this.badDuration("T must be followed by time components", charSequence);
                    }
                    string = (String)stringTokenizer.nextElement();
                }
                int n3 = Integer.parseInt(string);
                if (!stringTokenizer.hasMoreElements()) {
                    this.badDuration("missing unit letter at end", charSequence);
                }
                char c = ((String)stringTokenizer.nextElement()).charAt(0);
                switch (c) {
                    case 'Y': {
                        if (n2 > 0) {
                            this.badDuration("Y is out of sequence", charSequence);
                        }
                        this.years = n3;
                        n2 = 1;
                        ++n;
                        continue block10;
                    }
                    case 'M': {
                        if (n2 == 4 || n2 == 5) {
                            this.minutes = n3;
                            n2 = 6;
                            ++n;
                            continue block10;
                        }
                        if (n2 == 0 || n2 == 1) {
                            this.months = n3;
                            n2 = 2;
                            ++n;
                            continue block10;
                        }
                        this.badDuration("M is out of sequence", charSequence);
                    }
                    case 'D': {
                        if (n2 > 2) {
                            this.badDuration("D is out of sequence", charSequence);
                        }
                        this.days = n3;
                        n2 = 3;
                        ++n;
                        continue block10;
                    }
                    case 'H': {
                        if (n2 != 4) {
                            this.badDuration("H is out of sequence", charSequence);
                        }
                        this.hours = n3;
                        n2 = 5;
                        ++n;
                        continue block10;
                    }
                    case '.': {
                        if (n2 < 4 || n2 > 6) {
                            this.badDuration("misplaced decimal point", charSequence);
                        }
                        this.seconds = n3;
                        n2 = 7;
                        continue block10;
                    }
                    case 'S': {
                        if (n2 < 4 || n2 > 7) {
                            this.badDuration("S is out of sequence", charSequence);
                        }
                        if (n2 == 7) {
                            while (string.length() < 6) {
                                string = string + "0";
                            }
                            if (string.length() > 6) {
                                string = string.substring(0, 6);
                            }
                            this.microseconds = Integer.parseInt(string);
                        } else {
                            this.seconds = n3;
                        }
                        n2 = 8;
                        ++n;
                        continue block10;
                    }
                }
                this.badDuration("misplaced " + c, charSequence);
            }
            if (n == 0) {
                this.badDuration("Duration specifies no components", charSequence);
            }
            this.normalizeZeroDuration();
        }
        catch (NumberFormatException numberFormatException) {
            this.badDuration("non-numeric component", charSequence);
        }
    }

    protected void badDuration(String string, CharSequence charSequence) throws XPathException {
        DynamicError dynamicError = new DynamicError("Invalid duration value '" + charSequence + "' (" + string + ')');
        dynamicError.setErrorCode("FORG0001");
        throw dynamicError;
    }

    public AtomicValue convertPrimitive(BuiltInAtomicType builtInAtomicType, boolean bl, XPathContext xPathContext) {
        switch (builtInAtomicType.getPrimitiveType()) {
            case 88: 
            case 518: 
            case 643: {
                return this;
            }
            case 513: {
                return new StringValue(this.getStringValueCS());
            }
            case 642: {
                return new UntypedAtomicValue(this.getStringValueCS());
            }
            case 644: {
                return MonthDurationValue.fromMonths((this.years * 12 + this.months) * (this.negative ? -1 : 1));
            }
            case 645: {
                try {
                    return new SecondsDurationValue(this.negative ? -1 : 1, this.days, this.hours, this.minutes, this.seconds, this.microseconds);
                }
                catch (ValidationException validationException) {
                    return new ValidationErrorValue(validationException);
                }
            }
        }
        ValidationException validationException = new ValidationException("Cannot convert duration to " + builtInAtomicType.getDisplayName());
        validationException.setErrorCode("XPTY0004");
        validationException.setIsTypeError(true);
        return new ValidationErrorValue(validationException);
    }

    public DurationValue normalizeDuration() {
        int n = this.years * 12 + this.months;
        int n2 = n / 12;
        int n3 = n % 12;
        long l = ((((long)this.days * 24L + (long)this.hours) * 60L + (long)this.minutes) * 60L + (long)this.seconds) * 1000000L + (long)this.microseconds;
        int n4 = (int)(l % 1000000L);
        int n5 = (int)(l / 1000000L);
        int n6 = n5 % 60;
        int n7 = n5 / 60;
        int n8 = n7 % 60;
        int n9 = n7 / 60;
        int n10 = n9 % 24;
        int n11 = n9 / 24;
        return new DurationValue(!this.negative, n2, n3, n11, n10, n8, n6, n4);
    }

    public String getStringValue() {
        return ((Object)this.getStringValueCS()).toString();
    }

    public CharSequence getStringValueCS() {
        if (this.years == 0 && this.months == 0 && this.days == 0 && this.hours == 0 && this.minutes == 0 && this.seconds == 0 && this.microseconds == 0) {
            return "PT0S";
        }
        if (!this.normalized) {
            return this.normalizeDuration().getStringValueCS();
        }
        FastStringBuffer fastStringBuffer = new FastStringBuffer(32);
        if (this.negative) {
            fastStringBuffer.append('-');
        }
        fastStringBuffer.append("P");
        if (this.years != 0) {
            fastStringBuffer.append(this.years + "Y");
        }
        if (this.months != 0) {
            fastStringBuffer.append(this.months + "M");
        }
        if (this.days != 0) {
            fastStringBuffer.append(this.days + "D");
        }
        if (this.hours != 0 || this.minutes != 0 || this.seconds != 0 || this.microseconds != 0) {
            fastStringBuffer.append("T");
        }
        if (this.hours != 0) {
            fastStringBuffer.append(this.hours + "H");
        }
        if (this.minutes != 0) {
            fastStringBuffer.append(this.minutes + "M");
        }
        if (this.seconds != 0 || this.microseconds != 0) {
            if (this.seconds != 0 && this.microseconds == 0) {
                fastStringBuffer.append(this.seconds + "S");
            } else {
                long l = this.seconds * 1000000 + this.microseconds;
                String string = l + "";
                if (this.seconds == 0) {
                    string = "0000000" + string;
                    string = string.substring(string.length() - 7);
                }
                fastStringBuffer.append(string.substring(0, string.length() - 6));
                fastStringBuffer.append('.');
                int n = string.length() - 1;
                while (string.charAt(n) == '0') {
                    --n;
                }
                fastStringBuffer.append(string.substring(string.length() - 6, n + 1));
                fastStringBuffer.append('S');
            }
        }
        return fastStringBuffer;
    }

    public double getLengthInSeconds() {
        double d = this.years;
        d = d * 12.0 + (double)this.months;
        d = d * 30.43684991666667 + (double)this.days;
        d = d * 24.0 + (double)this.hours;
        d = d * 60.0 + (double)this.minutes;
        d = d * 60.0 + (double)this.seconds;
        return this.negative ? -d : (d += (double)this.microseconds / 1000000.0);
    }

    public ItemType getItemType(TypeHierarchy typeHierarchy) {
        return Type.DURATION_TYPE;
    }

    public Object convertToJava(Class clazz, XPathContext xPathContext) throws XPathException {
        if (clazz.isAssignableFrom(class$net$sf$saxon$value$DurationValue == null ? (class$net$sf$saxon$value$DurationValue = DurationValue.class$("net.sf.saxon.value.DurationValue")) : class$net$sf$saxon$value$DurationValue)) {
            return this;
        }
        if (clazz == (class$java$lang$String == null ? (class$java$lang$String = DurationValue.class$("java.lang.String")) : class$java$lang$String) || clazz == (class$java$lang$CharSequence == null ? (class$java$lang$CharSequence = DurationValue.class$("java.lang.CharSequence")) : class$java$lang$CharSequence)) {
            return this.getStringValue();
        }
        if (clazz == (class$java$lang$Object == null ? (class$java$lang$Object = DurationValue.class$("java.lang.Object")) : class$java$lang$Object)) {
            return this.getStringValue();
        }
        Object object = super.convertToJava(clazz, xPathContext);
        if (object == null) {
            DynamicError dynamicError = new DynamicError("Conversion of duration to " + clazz.getName() + " is not supported");
            dynamicError.setXPathContext(xPathContext);
            dynamicError.setErrorCode("SAXON:0000");
        }
        return object;
    }

    public AtomicValue getComponent(int n) throws XPathException {
        switch (n) {
            case 1: {
                return new IntegerValue(this.negative ? -this.years : this.years);
            }
            case 2: {
                return new IntegerValue(this.negative ? -this.months : this.months);
            }
            case 3: {
                return new IntegerValue(this.negative ? -this.days : this.days);
            }
            case 4: {
                return new IntegerValue(this.negative ? -this.hours : this.hours);
            }
            case 5: {
                return new IntegerValue(this.negative ? -this.minutes : this.minutes);
            }
            case 6: {
                FastStringBuffer fastStringBuffer = new FastStringBuffer(16);
                String string = "000000" + this.microseconds;
                string = string.substring(string.length() - 6);
                fastStringBuffer.append((this.negative ? "-" : "") + this.seconds + '.' + string);
                return DecimalValue.makeDecimalValue(fastStringBuffer, false);
            }
        }
        throw new IllegalArgumentException("Unknown component for duration: " + n);
    }

    public boolean equals(Object object) {
        DurationValue durationValue = (DurationValue)((AtomicValue)object).getPrimitiveValue();
        DurationValue durationValue2 = this.normalizeDuration();
        DurationValue durationValue3 = durationValue.normalizeDuration();
        return durationValue2.negative == durationValue3.negative && durationValue2.years == durationValue3.years && durationValue2.months == durationValue3.months && durationValue2.days == durationValue3.days && durationValue2.hours == durationValue3.hours && durationValue2.minutes == durationValue3.minutes && durationValue2.seconds == durationValue3.seconds && durationValue2.microseconds == durationValue3.microseconds;
    }

    public int hashCode() {
        return new Double(this.getLengthInSeconds()).hashCode();
    }

    public boolean schemaEquals(Value value) {
        if (value instanceof AtomicValue) {
            value = ((AtomicValue)value).getPrimitiveValue();
        }
        if (value instanceof DurationValue) {
            DurationValue durationValue = (DurationValue)value;
            this.negative = durationValue.negative && this.years == durationValue.years && this.months == durationValue.months && this.days == durationValue.days && this.hours == durationValue.hours && this.minutes == durationValue.minutes && this.seconds == durationValue.seconds && this.microseconds == durationValue.microseconds;
            return this.negative;
        }
        return false;
    }

    public DurationValue add(DurationValue durationValue, XPathContext xPathContext) throws XPathException {
        throw new DynamicError("Only subtypes of xs:duration can be added");
    }

    public DurationValue subtract(DurationValue durationValue, XPathContext xPathContext) throws XPathException {
        throw new DynamicError("Only subtypes of xs:duration can be subtracted");
    }

    public DurationValue multiply(double d, XPathContext xPathContext) throws XPathException {
        throw new DynamicError("Only subtypes of xs:duration can be multiplied by a number");
    }

    public DecimalValue divide(DurationValue durationValue, XPathContext xPathContext) throws XPathException {
        throw new DynamicError("Only subtypes of xs:duration can be divided by another duration");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

