/*
 * Decompiled with CFR 0.152.
 */
package com.ttv.SCTE130.client;

import com.ttv.SCTE130.client.SCTE130ClientInterface;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import javax.xml.rpc.ServiceException;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPConnectionFactory;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.jboss.util.Base64;
import org.w3c.dom.Element;

public class SCTE130Client
implements SCTE130ClientInterface {
    private String[] optionArgs = null;
    private String URL = null;
    private String login = null;
    private String password = null;
    private Integer timeout = new Integer(0);
    private SOAPConnectionFactory conFactory = null;
    private SOAPConnection con = null;
    SOAPBody[] bodyArray = null;

    public SCTE130Client() {
    }

    public SCTE130Client(String[] optionArgs, String URL2, String login, String password) {
        this.setCallOptions(optionArgs);
        this.setDestinationURL(URL2);
        this.setLoginPassword(login, password);
    }

    public void disconnect() {
        if (this.con != null) {
            try {
                this.con.close();
                this.con = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public String getLogin() {
        return this.login;
    }

    public String[] getOptionArgs() {
        return this.optionArgs;
    }

    public String getPassword() {
        return this.password;
    }

    public String getDestinationURL() {
        return this.URL;
    }

    public void setCallOptions(String[] args) {
        this.optionArgs = args;
    }

    public void setDestinationURL(String URL2) {
        this.URL = URL2;
    }

    public void setLoginPassword(String login, String password) {
        this.login = login;
        this.password = password;
    }

    public void addAttachment(File attachment) {
    }

    public Element invoke(SOAPElement request) throws RemoteException, MalformedURLException, ServiceException, Exception {
        MessageFactory mf = MessageFactory.newInstance();
        SOAPMessage reqMsg = mf.createMessage();
        reqMsg.getSOAPBody().addChildElement(request);
        if (this.getLogin() != null && this.getLogin().length() > 0) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(this.getLogin());
            buffer.append(":");
            buffer.append(this.getPassword());
            String encoded = Base64.encodeBytes((byte[])buffer.toString().getBytes());
            String authString = "Basic " + encoded;
            reqMsg.getMimeHeaders().addHeader("Authorization", authString);
        }
        if (this.conFactory == null) {
            this.conFactory = SOAPConnectionFactory.newInstance();
            this.con = this.conFactory.createConnection();
        }
        SOAPMessage resMsg = this.con.call(reqMsg, (Object)new URL(this.URL));
        try {
            return resMsg.getSOAPBody().getParentElement();
        }
        catch (SOAPException ignore) {
            return null;
        }
    }

    public void invokeOneWay(SOAPElement element) throws RemoteException, MalformedURLException, ServiceException, Exception {
        this.invokeAndDiscardResponse(element);
    }

    public void invokeAndDiscardResponse(SOAPElement request) throws RemoteException, MalformedURLException, ServiceException, Exception {
        MessageFactory mf = MessageFactory.newInstance();
        SOAPMessage reqMsg = mf.createMessage();
        reqMsg.getSOAPBody().addChildElement(request);
        if (this.getLogin() != null && this.getLogin().length() > 0) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(this.getLogin());
            buffer.append(":");
            buffer.append(this.getPassword());
            String encoded = Base64.encodeBytes((byte[])buffer.toString().getBytes());
            String authString = "Basic " + encoded;
            reqMsg.getMimeHeaders().addHeader("Authorization", authString);
        }
        if (this.conFactory == null) {
            this.conFactory = SOAPConnectionFactory.newInstance();
            this.con = this.conFactory.createConnection();
        }
        this.con.call(reqMsg, (Object)new URL(this.URL));
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    public void setTimeout(Integer timeout) {
        this.timeout = timeout;
    }
}

