/*
 * Decompiled with CFR 0.152.
 */
package com.ttv.SCTE130.client;

import com.ttv.SCTE130.client.SCTE130Client;
import com.ttv.SCTE130.client.SCTE130ClientInterface;
import com.ttv.SCTE130.client.SCTE130HTTPClient;
import com.ttv.SCTE130.client.SCTE130SocketClient;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class SCTE130ConnectionPool {
    private final Logger log = Logger.getLogger(SCTE130ConnectionPool.class);
    public static final int MAX_POOL_SIZE_DEFAULT = 5;
    private int maxPoolSize = 5;
    private int timeOut = 60000;
    private int threadSleepTime = 500;
    private int retries = 0;
    private int port;
    private String host = null;
    private String[] optionArgs = null;
    private String URL = null;
    private String transport = null;
    private String login = null;
    private String password = null;
    List<SCTE130ClientInterface> connectionPool = null;
    List<SCTE130ClientInterface> connectionsInUse = null;

    public SCTE130ConnectionPool(String[] optionArgs, String URL2, String transportType, String login, String password) {
        this.optionArgs = optionArgs;
        this.URL = URL2;
        this.transport = transportType;
        this.login = login;
        this.password = password;
        this.connectionPool = new ArrayList<SCTE130ClientInterface>();
        this.connectionsInUse = new ArrayList<SCTE130ClientInterface>();
    }

    public SCTE130ConnectionPool(String host, int port) {
        this.host = host;
        this.port = port;
        this.transport = "SOCKET";
        this.URL = host + ":" + port;
        this.connectionPool = new ArrayList<SCTE130ClientInterface>();
        this.connectionsInUse = new ArrayList<SCTE130ClientInterface>();
    }

    public Integer getTimeout() {
        return new Integer(this.timeOut);
    }

    public void setTimeout(Integer timeout) {
        this.timeOut = timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeConnectionsAndReleasePool() {
        ArrayList<SCTE130ClientInterface> clientList = new ArrayList<SCTE130ClientInterface>(this.connectionPool);
        clientList.addAll(this.connectionsInUse);
        for (int indx = 0; indx < clientList.size(); ++indx) {
            SCTE130ClientInterface client = (SCTE130ClientInterface)clientList.get(indx);
            client.disconnect();
        }
        List<SCTE130ClientInterface> list = this.connectionPool;
        synchronized (list) {
            this.connectionPool.clear();
            this.connectionsInUse.clear();
        }
        this.log.info((Object)"Connections closed and Connection Pool cleared.");
    }

    private SCTE130ClientInterface allocateSOAPClient() {
        SCTE130Client client = new SCTE130Client(this.getOptionArgs(), this.getURL(), this.getLogin(), this.getPassword());
        return client;
    }

    private SCTE130ClientInterface allocateHTTPClient() {
        SCTE130HTTPClient client = new SCTE130HTTPClient(this.getURL(), this.getLogin(), this.getPassword());
        return client;
    }

    private SCTE130ClientInterface allocateSOCKETClient() throws IOException {
        SCTE130SocketClient client = new SCTE130SocketClient(this.getHost(), this.getPort());
        client.setTimeout(this.timeOut);
        client.connect();
        return client;
    }

    private SCTE130ClientInterface allocateNewClient() throws IOException {
        if (this.transport.equalsIgnoreCase("SOAP")) {
            return this.allocateSOAPClient();
        }
        if (this.transport.equalsIgnoreCase("HTTP")) {
            return this.allocateHTTPClient();
        }
        if (this.transport.equalsIgnoreCase("SOCKET")) {
            return this.allocateSOCKETClient();
        }
        if (this.getURL().toString().contains("SOAPServiceEndpoint")) {
            return this.allocateSOAPClient();
        }
        if (this.getURL().toString().contains("HTTPServiceEndpoint")) {
            return this.allocateHTTPClient();
        }
        return this.allocateSOAPClient();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SCTE130ClientInterface getConnectionFromPool() throws IOException {
        SCTE130ClientInterface client = null;
        int counter = 0;
        while (this.retries == 0 || counter < this.retries) {
            ++counter;
            List<SCTE130ClientInterface> list = this.connectionPool;
            synchronized (list) {
                if (this.connectionPool.size() > 0) {
                    client = this.connectionPool.remove(0);
                } else if (this.connectionsInUse.size() <= this.getMaxPoolSize() - 1) {
                    client = this.allocateNewClient();
                } else {
                    try {
                        this.log.debug((Object)"Thread waits. Connection pool currently contains no resources.");
                        this.connectionPool.wait(this.threadSleepTime);
                    }
                    catch (InterruptedException ignore) {
                        // empty catch block
                    }
                    if (counter == this.retries) {
                        this.log.warn((Object)("Connection pool is currently exhausted for address: " + this.getURL()));
                        break;
                    }
                    continue;
                }
                this.connectionsInUse.add(client);
                break;
            }
        }
        return client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void returnConnectionToPool(SCTE130ClientInterface client) {
        List<SCTE130ClientInterface> list = this.connectionPool;
        synchronized (list) {
            this.connectionPool.add(client);
            this.connectionsInUse.remove(client);
            this.connectionPool.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnectionFromPool(SCTE130ClientInterface client) {
        List<SCTE130ClientInterface> list = this.connectionPool;
        synchronized (list) {
            this.connectionsInUse.remove(client);
            this.connectionPool.notify();
        }
    }

    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public void setMaxPoolSize(int maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
    }

    public String getHost() {
        return this.host;
    }

    public String getLogin() {
        return this.login;
    }

    public String[] getOptionArgs() {
        return this.optionArgs;
    }

    public String getPassword() {
        return this.password;
    }

    public int getPort() {
        return this.port;
    }

    public String getURL() {
        return this.URL;
    }

    public int getThreadSleepTime() {
        return this.threadSleepTime;
    }

    public void setThreadSleepTime(int threadSleepTime) {
        this.threadSleepTime = threadSleepTime;
    }

    public int getRetries() {
        return this.retries;
    }

    public void setRetries(int retries) {
        this.retries = retries;
    }
}

