/*
 * Decompiled with CFR 0.152.
 */
package com.ttv.SCTE130.client;

import com.ttv.SCTE130.client.SCTE130ClientInterface;
import com.ttv.SCTE130.utils.SCTE130Utils;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import javax.xml.rpc.ServiceException;
import javax.xml.soap.SOAPElement;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.ByteArrayRequestEntity;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.w3c.dom.Element;

public class SCTE130HTTPClient
implements SCTE130ClientInterface {
    private int resultCode;
    private String theURL = null;
    private String login = null;
    private String password = null;
    private HttpClient httpClient = null;
    private Integer timeout = new Integer(0);

    public SCTE130HTTPClient() {
    }

    public SCTE130HTTPClient(String URL2, String login, String password) {
        this.setDestinationURL(URL2);
        this.setLoginPassword(login, password);
    }

    public void disconnect() {
        this.httpClient.getHttpConnectionManager().closeIdleConnections(0L);
    }

    public int getLastResultCode() {
        return this.resultCode;
    }

    public String getLogin() {
        return this.login;
    }

    public String getPassword() {
        return this.password;
    }

    public String getDestinationURL() {
        return this.theURL;
    }

    public void setDestinationURL(String URL2) {
        this.theURL = URL2;
    }

    public void setLoginPassword(String login, String password) {
        this.login = login;
        this.password = password;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Element invoke(SOAPElement request) throws RemoteException, MalformedURLException, ServiceException, Exception {
        PostMethod post = new PostMethod(this.getDestinationURL());
        ByteArrayRequestEntity entity = new ByteArrayRequestEntity(SCTE130Utils.SOAPElementToByteArray(request));
        post.setRequestEntity((RequestEntity)entity);
        if (this.httpClient == null) {
            this.httpClient = new HttpClient();
            if (this.timeout != null) {
                this.httpClient.getHttpConnectionManager().getParams().setSoTimeout(this.timeout.intValue());
            }
            if (this.getLogin() != null && this.getPassword() != null) {
                URL url = new URL(this.theURL);
                AuthScope authScope = new AuthScope(url.getHost(), url.getPort());
                UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(this.getLogin(), this.getPassword());
                this.httpClient.getState().setCredentials(authScope, (Credentials)credentials);
                post.setDoAuthentication(true);
            }
        }
        try {
            Element element;
            this.resultCode = this.httpClient.executeMethod((HttpMethod)post);
            byte[] response = post.getResponseBody();
            if (response != null) {
                element = SCTE130Utils.getElementFromByteArray(response);
                return element;
            }
            element = null;
            return element;
        }
        finally {
            post.releaseConnection();
        }
    }

    public void invokeOneWay(SOAPElement element) throws RemoteException, MalformedURLException, ServiceException, Exception {
        throw new ServiceException("InvokeOneWay Notimplemented.");
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    public void setTimeout(Integer timeout) {
        this.timeout = timeout;
    }
}

