/*
 * Decompiled with CFR 0.152.
 */
package com.ttv.SCTE130.client;

import com.ttv.SCTE130.client.SCTE130ClientInterface;
import com.ttv.SCTE130.utils.SCTE130MessageHolder;
import com.ttv.SCTE130.utils.SCTE130Utils;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import javax.xml.soap.SOAPElement;
import org.apache.log4j.Logger;
import org.w3c.dom.Element;

public class SCTE130SocketClient
implements SCTE130ClientInterface {
    private final Logger log = Logger.getLogger(SCTE130SocketClient.class);
    private String host = null;
    private int port;
    private int timeOut = 60000;
    byte[] bArray = null;
    private DataOutputStream dOutputStream = null;
    private DataInputStream dInputStream = null;
    private Socket socket = null;

    public SCTE130SocketClient() {
    }

    public SCTE130SocketClient(String host, int port) {
        this.host = host;
        this.port = port;
    }

    public boolean isConnected() {
        return this.socket != null;
    }

    public Socket getSocket() {
        return this.socket;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public void connect() throws UnknownHostException, IOException {
        try {
            this.socket = new Socket();
            this.setTimeout(new Integer(this.timeOut));
            this.socket.bind(null);
            this.socket.connect(new InetSocketAddress(this.host, this.port), this.timeOut);
            this.socket.setKeepAlive(true);
            this.dOutputStream = new DataOutputStream(this.socket.getOutputStream());
            this.dInputStream = new DataInputStream(this.socket.getInputStream());
            this.log.debug((Object)"Successfully connected to remote SCTE130 socket interface.");
        }
        catch (IOException e) {
            this.socket = null;
            this.log.error((Object)"Failed to create and connect socket!", (Throwable)e);
            throw e;
        }
    }

    public void disconnect() {
        try {
            this.socket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Integer getTimeout() {
        return new Integer(this.timeOut);
    }

    public void setTimeout(Integer timeout) {
        this.timeOut = timeout;
        if (this.socket != null) {
            try {
                this.socket.setSoTimeout(this.timeOut);
            }
            catch (SocketException se) {
                this.log.error((Object)"Caught SocketException attempting to set Socket Timeout value.", (Throwable)se);
            }
        }
    }

    public Element invoke(SOAPElement element) throws IOException, ClassNotFoundException, Exception {
        byte[] message = SCTE130Utils.SOAPElementToByteArray(element);
        SCTE130MessageHolder returnMsg = this.sendMessageTwoWay(new SCTE130MessageHolder(message));
        return SCTE130Utils.getElementFromByteArray(returnMsg.getMessage());
    }

    public SCTE130MessageHolder getOneWayResponse() throws IOException {
        int bytesRead = 0;
        int amountToRead = this.dInputStream.readInt();
        this.bArray = new byte[amountToRead];
        for (int amountRead = 0; amountRead != amountToRead; amountRead += bytesRead) {
            bytesRead = this.dInputStream.read(this.bArray, amountRead, amountToRead - amountRead);
        }
        return new SCTE130MessageHolder(this.bArray);
    }

    public void invokeOneWay(SOAPElement element) throws IOException, ClassNotFoundException, Exception {
        this.sendMessageOneWay(new SCTE130MessageHolder(SCTE130Utils.SOAPElementToByteArray(element)));
    }

    public SCTE130MessageHolder sendMessageTwoWay(SCTE130MessageHolder message) throws IOException, ClassNotFoundException, Exception {
        if (this.dInputStream.available() > 0) {
            this.dInputStream.skip(this.dInputStream.available());
        }
        this.dOutputStream.writeInt(message.getMessage().length);
        this.dOutputStream.write(message.getMessage());
        this.dOutputStream.flush();
        int bytesRead = 0;
        int amountToRead = this.dInputStream.readInt();
        this.bArray = new byte[amountToRead];
        for (int amountRead = 0; amountRead != amountToRead; amountRead += bytesRead) {
            bytesRead = this.dInputStream.read(this.bArray, amountRead, amountToRead - amountRead);
        }
        return new SCTE130MessageHolder(this.bArray);
    }

    public void sendMessageOneWay(SCTE130MessageHolder message) throws IOException {
        this.dOutputStream.writeInt(message.getMessage().length);
        this.dOutputStream.write(message.getMessage());
        this.dOutputStream.flush();
    }
}

