/*
 * Decompiled with CFR 0.152.
 */
package com.ttv.SCTE130.client;

import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;

public class Util {

    public static class HMSfd
    extends HMSf {
        public final double fps;
        public final boolean dropFrame;
        public static final double FPS_30 = 30.0;
        public static final double FPS_29_97 = 29.970029970029973;
        public static final double FPS_25 = 25.0;

        public HMSfd(int h, int m, int s, int f, double fps, boolean dropFrame) {
            super(h, m, s, f);
            this.dropFrame = dropFrame;
            this.fps = fps;
        }

        public HMSfd(long frameNumber, double fps, boolean dropFrame) {
            super(frameNumber, fps, dropFrame);
            this.dropFrame = dropFrame;
            this.fps = fps;
        }

        public long frameNumber() {
            return this.frameNumber(this.fps, this.dropFrame);
        }

        public static HMSfd parse(String smpte, double fps, boolean dropFrame) {
            String[] parts = smpte.split(":");
            if (parts.length != 4) {
                throw new IllegalArgumentException("HMSfd.parse() requires hh:mm:ss:ff smpte timecode");
            }
            return new HMSfd(Integer.parseInt(parts[0]), Integer.parseInt(parts[1]), Integer.parseInt(parts[2]), Integer.parseInt(parts[3]), fps, dropFrame);
        }

        public String asNPT() {
            NumberFormat nf2 = NumberFormat.getNumberInstance();
            nf2.setMinimumIntegerDigits(2);
            NumberFormat d = NumberFormat.getNumberInstance();
            d.setMinimumIntegerDigits(2);
            d.setMaximumFractionDigits(3);
            double rs = (double)this.s + (double)this.f / Math.ceil(this.fps);
            return nf2.format(this.h) + ':' + nf2.format(this.m) + ':' + d.format(rs);
        }

        public double asNPTDouble() {
            return (double)this.frameNumber(this.fps, this.dropFrame) / this.fps;
        }

        public long asNPTMillis() {
            return Math.round(this.asNPTDouble() * 1000.0);
        }

        public static String millisToString(long millis, double fps, boolean dropFrame) {
            HMSfd t = new HMSfd(Math.round((double)millis / 1000.0 * fps), fps, dropFrame);
            return t.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class HMSf {
        final int h;
        final int m;
        final int s;
        final int f;

        public HMSf(long frameNumber, double fps, boolean dropFrame) {
            long x = dropFrame && HMSf.permittedDropFrameRate(fps) ? HMSf.adjust(frameNumber) : frameNumber;
            int fpsI = (int)Math.ceil(fps);
            this.f = (int)(x % (long)fpsI);
            this.s = (int)((x /= (long)fpsI) % 60L);
            this.m = (int)((x /= 60L) % 60L);
            this.h = (int)(x / 60L);
        }

        public HMSf(int h, int m, int s, int f) {
            this.h = h;
            this.m = m;
            this.s = s;
            this.f = f;
        }

        private static long adjust(long frameNumber) {
            long a = frameNumber - 2L * ((frameNumber - 30L) / 17982L);
            long m10 = (a - 2L) / 17980L;
            long minute = (a - 2L) / 1798L;
            return frameNumber + 2L * (minute - m10);
        }

        public String toString() {
            NumberFormat nf2 = NumberFormat.getNumberInstance();
            nf2.setMinimumIntegerDigits(2);
            return nf2.format(this.h) + ':' + nf2.format(this.m) + ':' + nf2.format(this.s) + ':' + nf2.format(this.f);
        }

        public static long frameNumberOf(ArrayList<String> parts, double fps, boolean dropFrame) throws ParseException {
            try {
                HMSf x = HMSf.parse(parts);
                return x.frameNumber(fps, dropFrame);
            }
            catch (NumberFormatException e) {
                throw new ParseException(e.getMessage(), -1);
            }
        }

        public static HMSf parse(ArrayList<String> parts) throws ParseException {
            int expected = 4;
            if (parts.size() > 4) {
                throw new ParseException("too many (>4) components in ':'-separated string", 0);
            }
            while (parts.size() < 4) {
                parts.add(0, "0");
            }
            HMSf x = new HMSf(Integer.parseInt(parts.get(0)), Integer.parseInt(parts.get(1)), Integer.parseInt(parts.get(2)), Integer.parseInt(parts.get(3)));
            return x;
        }

        public long frameNumber(double fps, boolean dropFrame) {
            int fpsI = (int)Math.ceil(fps);
            int a = 0;
            if (dropFrame) {
                if (!HMSf.permittedDropFrameRate(fps)) {
                    throw new IllegalArgumentException("drop frame should only be used with 29.97Hz");
                }
                int m2 = 60 * this.h + this.m;
                a = m2 - m2 / 10;
            }
            return (((long)this.h * 60L + (long)this.m) * 60L + (long)this.s) * (long)fpsI + (long)this.f - (long)(2 * a);
        }

        public static boolean permittedDropFrameRate(double fps) {
            return 0.01 > Math.abs(fps - 29.970029970029973);
        }

        public boolean illegal(boolean dropFrame) {
            return dropFrame && this.m % 10 != 0 && this.s == 0 && this.f < 2;
        }
    }
}

