/*
 * Decompiled with CFR 0.152.
 */
package com.ttv.SCTE130.messages.adi;

import com.ttv.SCTE130.SCTE130MessageFactory;
import com.ttv.SCTE130.SCTE130MessageFactoryLocator;
import com.ttv.SCTE130.SCTE130Namespaces;
import com.ttv.SCTE130.messages.MessageInterface;
import com.ttv.SCTE130.messages.adi.Content;
import com.ttv.SCTE130.messages.adi.Metadata;
import com.ttv.SCTE130.utils.SCTE130Utils;
import java.util.ArrayList;
import java.util.List;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Asset
implements MessageInterface {
    private Metadata metadata = null;
    private Content content = null;
    private List<Asset> assets = null;
    public static String ELE_ASSET = "Asset";

    public Asset(Element element) throws Exception {
        NodeList list = element.getChildNodes();
        for (int indx = 0; indx < list.getLength(); ++indx) {
            Node node = list.item(indx);
            if (!(node instanceof Element)) continue;
            Element child = (Element)node;
            SCTE130MessageFactory factory = SCTE130MessageFactoryLocator.getMessageFactory(child);
            Object obj = factory.allocateSCTE130Message(child);
            if (obj instanceof Asset) {
                if (this.assets == null) {
                    this.assets = new ArrayList<Asset>();
                }
                this.assets.add((Asset)obj);
            }
            if (obj instanceof Metadata) {
                this.metadata = (Metadata)obj;
            }
            if (!(obj instanceof Content)) continue;
            this.content = (Content)obj;
        }
    }

    public Asset(Metadata metadata, Content content, List<Asset> assets) {
        this.metadata = metadata;
        this.content = content;
        this.assets = assets;
    }

    @Override
    public boolean equals(MessageInterface obj) {
        Asset other = (Asset)obj;
        SCTE130Utils dUtils = SCTE130Utils.getInstance();
        if (!SCTE130Utils.objectsEqual(this.getMetadata(), other.getMetadata())) {
            dUtils.devLog("Asset equality check failed. Metadata items don't match.");
            return false;
        }
        if (!SCTE130Utils.objectsEqual(this.getContent(), other.getContent())) {
            dUtils.devLog("Asset equality check failed. Content items don't match.");
            return false;
        }
        if (!SCTE130Utils.listsEqual(this.getAssets(), other.getAssets())) {
            dUtils.devLog("Asset equality check failed. Assets don't match.");
            return false;
        }
        return true;
    }

    @Override
    public SOAPElement getSOAPElement() throws SOAPException {
        SCTE130Namespaces nameSpaces = SCTE130Namespaces.getInstance();
        SOAPFactory factory = SOAPFactory.newInstance();
        SOAPElement asset = factory.createElement(ELE_ASSET, "adi", nameSpaces.getURIForName("adi"));
        nameSpaces.populateNamespace(asset, "adi");
        SCTE130Utils.addChildElement(asset, this.getMetadata());
        SCTE130Utils.addChildElement(asset, this.getContent());
        SCTE130Utils.addChildElementList(asset, this.getAssets());
        return asset;
    }

    public Content getContent() {
        return this.content;
    }

    public List<Asset> getAssets() {
        return this.assets;
    }

    public Metadata getMetadata() {
        return this.metadata;
    }
}

