/*
 * Decompiled with CFR 0.152.
 */
package com.ttv.SCTE130.messages.adm;

import com.ttv.SCTE130.SCTE130Namespaces;
import com.ttv.SCTE130.messages.MessageInterface;
import com.ttv.SCTE130.utils.SCTE130Utils;
import java.util.TreeMap;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class ADMData
implements MessageInterface {
    private String otherData = null;
    private TreeMap<String, String> anyAttributes = new TreeMap();
    private String[] namedAttributes = new String[0];
    public static final String ELE_ADM_DATA = "ADMData";

    public ADMData(Element element) throws Exception {
        this.anyAttributes = SCTE130Utils.locateOtherAttributes(this.namedAttributes, element.getAttributes());
        NodeList list = element.getChildNodes();
        for (int indx = 0; indx < list.getLength(); ++indx) {
            Node node = list.item(indx);
            if (!(node instanceof Text)) continue;
            this.otherData = ((Text)node).getData();
        }
    }

    public ADMData() {
    }

    public ADMData(String otherData) {
        this.otherData = otherData;
    }

    public boolean equals(MessageInterface obj) {
        ADMData other = (ADMData)obj;
        SCTE130Utils dUtils = SCTE130Utils.getInstance();
        if (!SCTE130Utils.stringsEqual(this.getOtherData(), other.getOtherData())) {
            dUtils.devLog("ADMData equality check failed. Data don't match.");
            return false;
        }
        return true;
    }

    public SOAPElement getSOAPElement() throws SOAPException {
        SCTE130Namespaces nameSpaces = SCTE130Namespaces.getInstance();
        SOAPFactory factory = SOAPFactory.newInstance();
        SOAPElement admData = factory.createElement(ELE_ADM_DATA, "adm", nameSpaces.getURIForName("adm"));
        nameSpaces.populateNamespace(admData, "adm");
        SCTE130Utils.addOtherAttributes(admData, this.anyAttributes);
        admData.addTextNode(this.getOtherData());
        return admData;
    }

    public void addAnyAttribute(String attributeName, String attributeValue) {
        this.anyAttributes.put(attributeName, attributeValue);
    }

    public String getOtherData() {
        return this.otherData;
    }

    public void setOtherData(String otherData) {
        this.otherData = otherData;
    }
}

