/*
 * Decompiled with CFR 0.152.
 */
package com.ttv.SCTE130.messages.adm;

import com.ttv.SCTE130.SCTE130MessageFactory;
import com.ttv.SCTE130.SCTE130MessageFactoryLocator;
import com.ttv.SCTE130.SCTE130Namespaces;
import com.ttv.SCTE130.messages.MessageInterface;
import com.ttv.SCTE130.messages.adm.TargetCode;
import com.ttv.SCTE130.messages.adm.TerminalAddress;
import com.ttv.SCTE130.messages.core.CurrentDateTime;
import com.ttv.SCTE130.messages.core.Ext;
import com.ttv.SCTE130.utils.SCTE130Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Client
implements MessageInterface {
    private CurrentDateTime currentTime = null;
    private TerminalAddress terminalAddress = null;
    private List<TargetCode> targetCodes = null;
    private TreeMap<String, String> anyAttributes = new TreeMap();
    private String[] namedAttributes = new String[0];
    private Ext ext = null;
    public static final String ELE_CLIENT = "Client";

    public Client(Element element) throws Exception {
        this.anyAttributes = SCTE130Utils.locateOtherAttributes(this.namedAttributes, element.getAttributes());
        NodeList list = element.getChildNodes();
        for (int indx = 0; indx < list.getLength(); ++indx) {
            Node node = list.item(indx);
            if (!(node instanceof Element)) continue;
            Element child = (Element)node;
            SCTE130MessageFactory factory = SCTE130MessageFactoryLocator.getMessageFactory(child);
            Object obj = factory.allocateSCTE130Message(child);
            if (obj instanceof CurrentDateTime) {
                this.currentTime = (CurrentDateTime)obj;
            }
            if (obj instanceof TargetCode) {
                if (this.targetCodes == null) {
                    this.targetCodes = new ArrayList<TargetCode>();
                }
                this.targetCodes.add((TargetCode)obj);
            }
            if (obj instanceof TerminalAddress) {
                this.terminalAddress = (TerminalAddress)obj;
            }
            if (!(obj instanceof Ext)) continue;
            this.ext = (Ext)obj;
        }
    }

    public Client() {
    }

    public Client(CurrentDateTime currentTime, List<TargetCode> targetCodes, TerminalAddress terminalAddress, Ext ext) {
        this.currentTime = currentTime;
        this.targetCodes = targetCodes;
        this.terminalAddress = terminalAddress;
        this.ext = ext;
    }

    @Override
    public boolean equals(MessageInterface obj) {
        Client other = (Client)obj;
        SCTE130Utils dUtils = SCTE130Utils.getInstance();
        if (!SCTE130Utils.objectsEqual(this.getCurrentTime(), other.getCurrentTime())) {
            dUtils.devLog("Client equality check failed. CurrentTimes don't match.");
            return false;
        }
        if (!SCTE130Utils.listsEqual(this.getTargetCodes(), other.getTargetCodes())) {
            dUtils.devLog("Client equality check failed. Targeting codes don't match.");
            return false;
        }
        if (!SCTE130Utils.objectsEqual(this.getTerminalAddress(), other.getTerminalAddress())) {
            dUtils.devLog("Client equality check failed. TerminalAddresses don't match.");
            return false;
        }
        if (!SCTE130Utils.objectsEqual(this.getExt(), other.getExt())) {
            dUtils.devLog("Client equality check failed. Exts don't match.");
            return false;
        }
        return true;
    }

    @Override
    public SOAPElement getSOAPElement() throws SOAPException {
        SCTE130Namespaces nameSpaces = SCTE130Namespaces.getInstance();
        SOAPFactory factory = SOAPFactory.newInstance();
        SOAPElement client = factory.createElement(ELE_CLIENT, "adm", nameSpaces.getURIForName("adm"));
        nameSpaces.populateNamespace(client, "adm");
        SCTE130Utils.addOtherAttributes(client, this.anyAttributes);
        SCTE130Utils.addChildElement(client, this.getCurrentTime());
        SCTE130Utils.addChildElement(client, this.getTerminalAddress());
        SCTE130Utils.addChildElementList(client, this.getTargetCodes());
        SCTE130Utils.addChildElement(client, this.getExt());
        return client;
    }

    public void addAnyAttribute(String attributeName, String attributeValue) {
        this.anyAttributes.put(attributeName, attributeValue);
    }

    public Ext getExt() {
        return this.ext;
    }

    public void setExt(Ext ext) {
        this.ext = ext;
    }

    public void setTargetCodes(List<TargetCode> targetCodes) {
        this.targetCodes = targetCodes;
    }

    public CurrentDateTime getCurrentTime() {
        return this.currentTime;
    }

    public List<TargetCode> getTargetCodes() {
        return this.targetCodes;
    }

    public TerminalAddress getTerminalAddress() {
        return this.terminalAddress;
    }

    public void setCurrentTime(CurrentDateTime currentTime) {
        this.currentTime = currentTime;
    }

    public void setTerminalAddress(TerminalAddress terminalAddress) {
        this.terminalAddress = terminalAddress;
    }
}

