/*
 * Decompiled with CFR 0.152.
 */
package com.ttv.SCTE130.messages.adm;

import com.ttv.SCTE130.SCTE130MessageFactory;
import com.ttv.SCTE130.SCTE130MessageFactoryLocator;
import com.ttv.SCTE130.SCTE130Namespaces;
import com.ttv.SCTE130.messages.MessageInterface;
import com.ttv.SCTE130.messages.core.ContentDataModel;
import com.ttv.SCTE130.utils.SCTE130Utils;
import java.util.TreeMap;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ContentProvider
implements MessageInterface {
    private String providerId = null;
    private TreeMap<String, String> anyAttributes = new TreeMap();
    private ContentDataModel contentDataModel = null;
    public static final String ELE_CONTENT_PROVIDER = "ContentProvider";
    private static final String ATTR_PROVIDER_ID = "providerID";
    private String[] namedAttributes = new String[]{"providerID"};

    public ContentProvider(Element element) throws Exception {
        this.providerId = element.getAttribute(ATTR_PROVIDER_ID);
        this.anyAttributes = SCTE130Utils.locateOtherAttributes(this.namedAttributes, element.getAttributes());
        NodeList list = element.getChildNodes();
        for (int indx = 0; indx < list.getLength(); ++indx) {
            Element child;
            SCTE130MessageFactory factory;
            Object obj;
            Node node = list.item(indx);
            if (!(node instanceof Element) || !((obj = (factory = SCTE130MessageFactoryLocator.getMessageFactory(child = (Element)node)).allocateSCTE130Message(child)) instanceof ContentDataModel)) continue;
            this.contentDataModel = (ContentDataModel)obj;
        }
    }

    public ContentProvider() {
    }

    public ContentProvider(String providerId, ContentDataModel contentDataModel) {
        this.providerId = providerId;
        this.contentDataModel = contentDataModel;
    }

    public boolean equals(MessageInterface obj) {
        ContentProvider other = (ContentProvider)obj;
        SCTE130Utils dUtils = SCTE130Utils.getInstance();
        if (!SCTE130Utils.stringsEqual(this.getProviderId(), other.getProviderId())) {
            dUtils.devLog("Provider equality check failed. providerIds don't match.");
            return false;
        }
        if (!SCTE130Utils.objectsEqual(this.getContentDataModel(), other.getContentDataModel())) {
            dUtils.devLog("Provider equality check failed. DataModels don't match.");
            return false;
        }
        return true;
    }

    public SOAPElement getSOAPElement() throws SOAPException {
        SCTE130Namespaces nameSpaces = SCTE130Namespaces.getInstance();
        SOAPFactory factory = SOAPFactory.newInstance();
        SOAPElement provider = factory.createElement(ELE_CONTENT_PROVIDER, "adm", nameSpaces.getURIForName("adm"));
        nameSpaces.populateNamespace(provider, "adm");
        SCTE130Utils.setAttribute(provider, ATTR_PROVIDER_ID, this.getProviderId());
        SCTE130Utils.addOtherAttributes(provider, this.anyAttributes);
        SCTE130Utils.addChildElement(provider, this.getContentDataModel());
        return provider;
    }

    public void addAnyAttribute(String attributeName, String attributeValue) {
        this.anyAttributes.put(attributeName, attributeValue);
    }

    public ContentDataModel getContentDataModel() {
        return this.contentDataModel;
    }

    public void setContentDataModel(ContentDataModel contentDataModel) {
        this.contentDataModel = contentDataModel;
    }

    public String getProviderId() {
        return this.providerId;
    }

    public void setProviderId(String providerId) {
        this.providerId = providerId;
    }
}

