/*
 * Decompiled with CFR 0.152.
 */
package com.ttv.SCTE130.messages.adm;

import com.ttv.SCTE130.SCTE130MessageFactory;
import com.ttv.SCTE130.SCTE130MessageFactoryLocator;
import com.ttv.SCTE130.SCTE130Namespaces;
import com.ttv.SCTE130.messages.MessageInterface;
import com.ttv.SCTE130.messages.adm.EntertainmentNPT;
import com.ttv.SCTE130.messages.core.Content;
import com.ttv.SCTE130.messages.core.Ext;
import com.ttv.SCTE130.utils.SCTE130Utils;
import java.util.TreeMap;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Entertainment
implements MessageInterface {
    private Content content = null;
    private EntertainmentNPT npt = null;
    private Ext ext = null;
    private TreeMap<String, String> anyAttributes = new TreeMap();
    private String[] namedAttributes = new String[0];
    public static final String ELE_ENTERTAINMENT = "Entertainment";

    public Entertainment(Element element) throws Exception {
        this.anyAttributes = SCTE130Utils.locateOtherAttributes(this.namedAttributes, element.getAttributes());
        NodeList list = element.getChildNodes();
        for (int indx = 0; indx < list.getLength(); ++indx) {
            Node node = list.item(indx);
            if (!(node instanceof Element)) continue;
            Element child = (Element)node;
            SCTE130MessageFactory factory = SCTE130MessageFactoryLocator.getMessageFactory(child);
            Object obj = factory.allocateSCTE130Message(child);
            if (obj instanceof Content) {
                this.content = (Content)obj;
            }
            if (obj instanceof EntertainmentNPT) {
                this.npt = (EntertainmentNPT)obj;
            }
            if (!(obj instanceof Ext)) continue;
            this.ext = (Ext)obj;
        }
    }

    public Entertainment() {
    }

    public Entertainment(Content content, EntertainmentNPT npt, Ext ext) {
        this.content = content;
        this.npt = npt;
        this.ext = ext;
    }

    public boolean equals(MessageInterface obj) {
        Entertainment other = (Entertainment)obj;
        SCTE130Utils dUtils = SCTE130Utils.getInstance();
        if (!SCTE130Utils.objectsEqual(this.getContent(), other.getContent())) {
            dUtils.devLog("Entertainment equality check failed. Contents don't match.");
            return false;
        }
        if (!SCTE130Utils.objectsEqual(this.getNPT(), other.getNPT())) {
            dUtils.devLog("Entertainment equality check failed. NPTs don't match.");
            return false;
        }
        if (!SCTE130Utils.objectsEqual(this.getExt(), other.getExt())) {
            dUtils.devLog("Entertainment equality check failed. Exts don't match.");
            return false;
        }
        return true;
    }

    public SOAPElement getSOAPElement() throws SOAPException {
        SCTE130Namespaces nameSpaces = SCTE130Namespaces.getInstance();
        SOAPFactory factory = SOAPFactory.newInstance();
        SOAPElement notification = factory.createElement(ELE_ENTERTAINMENT, "adm", nameSpaces.getURIForName("adm"));
        nameSpaces.populateNamespace(notification, "adm");
        SCTE130Utils.addOtherAttributes(notification, this.anyAttributes);
        SCTE130Utils.addChildElement(notification, this.getContent());
        SCTE130Utils.addChildElement(notification, this.getNPT());
        SCTE130Utils.addChildElement(notification, this.getExt());
        return notification;
    }

    public void addAnyAttribute(String attributeName, String attributeValue) {
        this.anyAttributes.put(attributeName, attributeValue);
    }

    public Content getContent() {
        return this.content;
    }

    public void setContent(Content content) {
        this.content = content;
    }

    public Ext getExt() {
        return this.ext;
    }

    public void setExt(Ext ext) {
        this.ext = ext;
    }

    public EntertainmentNPT getNPT() {
        return this.npt;
    }

    public void setNPT(EntertainmentNPT npt) {
        this.npt = npt;
    }
}

