/*
 * Decompiled with CFR 0.152.
 */
package com.ttv.SCTE130.messages.adm;

import com.ttv.SCTE130.SCTE130MessageFactory;
import com.ttv.SCTE130.SCTE130MessageFactoryLocator;
import com.ttv.SCTE130.SCTE130Namespaces;
import com.ttv.SCTE130.messages.MessageInterface;
import com.ttv.SCTE130.messages.adm.Client;
import com.ttv.SCTE130.messages.adm.Entertainment;
import com.ttv.SCTE130.messages.adm.Events;
import com.ttv.SCTE130.messages.adm.SpotScopedEvents;
import com.ttv.SCTE130.messages.adm.SystemContext;
import com.ttv.SCTE130.utils.DateUtils;
import com.ttv.SCTE130.utils.SCTE130Utils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TreeMap;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntertainmentScopedEvents
implements MessageInterface {
    private Date eventRangeStartDateTime = null;
    private Date eventRangeEndDateTime = null;
    private TreeMap<String, String> anyAttributes = new TreeMap();
    private SystemContext systemContext = null;
    private Client client = null;
    private Entertainment entertainment = null;
    private List<Events> events = null;
    private List<SpotScopedEvents> spotEvents = null;
    public static final String ELE_ENTERTAINMENT_SCOPED_EVENTS = "EntertainmentScopedEvents";
    private static final String ATTR_EVENT_RANGE_START = "eventRangeStartDateTime";
    private static final String ATTR_EVENT_RANGE_END = "eventRangeEndDateTime";
    private String[] namedAttributes = new String[]{"eventRangeStartDateTime", "eventRangeEndDateTime"};

    public EntertainmentScopedEvents(Element element) throws Exception {
        String remoteEventRangeStart = element.getAttribute(ATTR_EVENT_RANGE_START);
        String remoteEventRangeEnd = element.getAttribute(ATTR_EVENT_RANGE_END);
        if (remoteEventRangeStart != null && remoteEventRangeStart.length() > 0) {
            try {
                this.eventRangeStartDateTime = DateUtils.parseXSDDateTime(remoteEventRangeStart);
            }
            catch (Exception e) {
                SCTE130Utils.getInstance().devLog("Failed to parse StartTime in EntertainmentScopedEvents.");
            }
        }
        if (remoteEventRangeEnd != null && remoteEventRangeEnd.length() > 0) {
            try {
                this.eventRangeEndDateTime = DateUtils.parseXSDDateTime(remoteEventRangeEnd);
            }
            catch (Exception e) {
                SCTE130Utils.getInstance().devLog("Failed to parse EndTime in EntertainmentScopedEvents.");
            }
        }
        this.anyAttributes = SCTE130Utils.locateOtherAttributes(this.namedAttributes, element.getAttributes());
        this.events = new ArrayList<Events>();
        this.spotEvents = new ArrayList<SpotScopedEvents>();
        NodeList list = element.getChildNodes();
        for (int indx = 0; indx < list.getLength(); ++indx) {
            Node node = list.item(indx);
            if (!(node instanceof Element)) continue;
            Element child = (Element)node;
            SCTE130MessageFactory factory = SCTE130MessageFactoryLocator.getMessageFactory(child);
            Object obj = factory.allocateSCTE130Message(child);
            if (obj instanceof Entertainment) {
                this.entertainment = (Entertainment)obj;
            }
            if (obj instanceof SpotScopedEvents) {
                this.spotEvents.add((SpotScopedEvents)obj);
            }
            if (!(obj instanceof Events)) continue;
            this.events.add((Events)obj);
        }
    }

    public EntertainmentScopedEvents() {
    }

    public EntertainmentScopedEvents(Date eventRangeStartDateTime, Date eventRangeEndDateTime, Entertainment entertainment, List<Events> events, List<SpotScopedEvents> spotEvents) {
        this.eventRangeStartDateTime = eventRangeStartDateTime;
        this.eventRangeEndDateTime = eventRangeEndDateTime;
        this.entertainment = entertainment;
        this.events = events;
        this.spotEvents = spotEvents;
    }

    @Override
    public boolean equals(MessageInterface obj) {
        EntertainmentScopedEvents other = (EntertainmentScopedEvents)obj;
        SCTE130Utils dUtils = SCTE130Utils.getInstance();
        if (this.getEventRangeStartDateTime().compareTo(other.getEventRangeStartDateTime()) != 0) {
            dUtils.devLog("EntertainmentScopedEvents equality check failed. EventRange StartTimes don't match.");
            return false;
        }
        if (this.getEventRangeEndDateTime().compareTo(other.getEventRangeEndDateTime()) != 0) {
            dUtils.devLog("EntertainmentScopedEvents equality check failed. EventRange EndTimes don't match.");
            return false;
        }
        if (!SCTE130Utils.objectsEqual(this.getEntertainment(), other.getEntertainment())) {
            dUtils.devLog("EntertainmentScopedEvents equality check failed. Entertainment don't match.");
            return false;
        }
        if (!SCTE130Utils.listsEqual(this.getSpotEvents(), other.getSpotEvents())) {
            dUtils.devLog("EntertainmentScopedEvents equality check failed. SpotScopedEvents don't match.");
            return false;
        }
        if (!SCTE130Utils.listsEqual(this.getEvents(), other.getEvents())) {
            dUtils.devLog("EntertainmentScopedEvents equality check failed. Events don't match.");
            return false;
        }
        return true;
    }

    @Override
    public SOAPElement getSOAPElement() throws SOAPException {
        SCTE130Namespaces nameSpaces = SCTE130Namespaces.getInstance();
        SOAPFactory factory = SOAPFactory.newInstance();
        SOAPElement scopedEvents = factory.createElement(ELE_ENTERTAINMENT_SCOPED_EVENTS, "adm", nameSpaces.getURIForName("adm"));
        nameSpaces.populateNamespace(scopedEvents, "adm");
        SCTE130Utils.setAttribute(scopedEvents, ATTR_EVENT_RANGE_START, this.getEventRangeStartDateTimeAsStr());
        SCTE130Utils.setAttribute(scopedEvents, ATTR_EVENT_RANGE_END, this.getEventRangeEndDateTimeAsStr());
        SCTE130Utils.addOtherAttributes(scopedEvents, this.anyAttributes);
        SCTE130Utils.addChildElement(scopedEvents, this.getEntertainment());
        SCTE130Utils.addChildElementList(scopedEvents, this.getEvents());
        SCTE130Utils.addChildElementList(scopedEvents, this.getSpotEvents());
        return scopedEvents;
    }

    public void addAnyAttribute(String attributeName, String attributeValue) {
        this.anyAttributes.put(attributeName, attributeValue);
    }

    public Client getClient() {
        return this.client;
    }

    public void setClient(Client client) {
        this.client = client;
    }

    public Entertainment getEntertainment() {
        return this.entertainment;
    }

    public void setEntertainment(Entertainment entertainment) {
        this.entertainment = entertainment;
    }

    public List<SpotScopedEvents> getSpotEvents() {
        return this.spotEvents;
    }

    public void setSpotEvents(List<SpotScopedEvents> spotEvents) {
        this.spotEvents = spotEvents;
    }

    public SystemContext getSystemContext() {
        return this.systemContext;
    }

    public void setSystemContext(SystemContext systemContext) {
        this.systemContext = systemContext;
    }

    public Date getEventRangeEndDateTime() {
        return this.eventRangeEndDateTime;
    }

    public String getEventRangeEndDateTimeAsStr() {
        return DateUtils.formatXSDDateTime(this.eventRangeEndDateTime);
    }

    public void setEventRangeEndDateTime(Date eventRangeEndDateTime) {
        this.eventRangeEndDateTime = eventRangeEndDateTime;
    }

    public Date getEventRangeStartDateTime() {
        return this.eventRangeStartDateTime;
    }

    public String getEventRangeStartDateTimeAsStr() {
        return DateUtils.formatXSDDateTime(this.eventRangeStartDateTime);
    }

    public void setEventRangeStartDateTime(Date eventRangeStartDateTime) {
        this.eventRangeStartDateTime = eventRangeStartDateTime;
    }

    public List<Events> getEvents() {
        return this.events;
    }

    public void setEvents(List<Events> events) {
        this.events = events;
    }
}

