/*
 * Decompiled with CFR 0.152.
 */
package com.ttv.SCTE130.messages.adm;

import com.ttv.SCTE130.SCTE130MessageFactory;
import com.ttv.SCTE130.SCTE130MessageFactoryLocator;
import com.ttv.SCTE130.SCTE130Namespaces;
import com.ttv.SCTE130.messages.MessageInterface;
import com.ttv.SCTE130.messages.adm.Client;
import com.ttv.SCTE130.messages.adm.Entertainment;
import com.ttv.SCTE130.messages.adm.EntertainmentNPT;
import com.ttv.SCTE130.messages.adm.NPT;
import com.ttv.SCTE130.messages.adm.Spot;
import com.ttv.SCTE130.messages.adm.SpotNPT;
import com.ttv.SCTE130.messages.adm.SystemContext;
import com.ttv.SCTE130.messages.core.Ext;
import com.ttv.SCTE130.messages.core.StatusCode;
import com.ttv.SCTE130.utils.DateUtils;
import com.ttv.SCTE130.utils.SCTE130Utils;
import java.util.Date;
import java.util.TreeMap;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Event
implements MessageInterface {
    private String type = null;
    private Date time = null;
    private String identityADM = null;
    private String systemADM = null;
    private String identityADS = null;
    private String messageRef = null;
    protected TreeMap<String, String> anyAttributes = new TreeMap();
    private StatusCode statusCode = null;
    private SystemContext systemContext = null;
    private Client client = null;
    private Entertainment entertainment = null;
    private EntertainmentNPT entertainmentNPT = null;
    private Spot spot = null;
    private SpotNPT spotNPT = null;
    private NPT npt = null;
    private Ext ext = null;
    public static final String ELE_EVENT = "Event";
    protected static final String ATTR_TYPE = "type";
    protected static final String ATTR_TIME = "time";
    protected static final String ATTR_IDENTITY_ADM = "identityADM";
    protected static final String ATTR_SYSTEM_ADM = "systemADM";
    protected static final String ATTR_IDENTITY_ADS = "identityADS";
    protected static final String ATTR_MESSAGE_REF = "messageRef";
    protected static final String ATTR_EVENT_SOURCE = "eventSource";
    protected String[] namedAttributes = new String[]{"type", "time", "identityADM", "systemADM", "identityADS", "messageRef", "eventSource"};

    public Event(Element element) throws Exception {
        String remoteTime = element.getAttribute(ATTR_TIME);
        if (remoteTime != null && remoteTime.length() > 0) {
            this.time = DateUtils.parseXSDDateTime(remoteTime);
        }
        this.type = element.getAttribute(ATTR_TYPE);
        this.identityADM = element.getAttribute(ATTR_IDENTITY_ADM);
        this.systemADM = element.getAttribute(ATTR_SYSTEM_ADM);
        this.identityADS = element.getAttribute(ATTR_IDENTITY_ADS);
        this.messageRef = element.getAttribute(ATTR_MESSAGE_REF);
        this.anyAttributes = SCTE130Utils.locateOtherAttributes(this.namedAttributes, element.getAttributes());
        NodeList list = element.getChildNodes();
        for (int indx = 0; indx < list.getLength(); ++indx) {
            Node node = list.item(indx);
            if (!(node instanceof Element)) continue;
            Element child = (Element)node;
            SCTE130MessageFactory factory = SCTE130MessageFactoryLocator.getMessageFactory(child);
            Object obj = factory.allocateSCTE130Message(child);
            if (obj instanceof StatusCode) {
                this.statusCode = (StatusCode)obj;
            }
            if (obj instanceof SystemContext) {
                this.systemContext = (SystemContext)obj;
            }
            if (obj instanceof Client) {
                this.client = (Client)obj;
            }
            if (obj instanceof Entertainment) {
                this.entertainment = (Entertainment)obj;
            }
            if (obj instanceof EntertainmentNPT) {
                this.entertainmentNPT = (EntertainmentNPT)obj;
            }
            if (obj instanceof Spot) {
                this.spot = (Spot)obj;
            }
            if (obj instanceof SpotNPT) {
                this.spotNPT = (SpotNPT)obj;
            }
            if (obj instanceof NPT) {
                this.npt = (NPT)obj;
            }
            if (!(obj instanceof Ext)) continue;
            this.ext = (Ext)obj;
        }
    }

    public Event() {
    }

    public Event(String type, Date time, String identityADM, String systemADM, String identityADS, String messageRef, StatusCode statusCode, SystemContext systemContext, Client client, Entertainment entertainment, EntertainmentNPT entertainmentNPT, Spot spot, SpotNPT spotNPT, NPT npt, Ext ext) {
        this.type = type;
        this.time = time;
        this.identityADM = identityADM;
        this.systemADM = systemADM;
        this.identityADS = identityADS;
        this.messageRef = messageRef;
        this.statusCode = statusCode;
        this.systemContext = systemContext;
        this.client = client;
        this.entertainment = entertainment;
        this.entertainmentNPT = entertainmentNPT;
        this.spot = spot;
        this.spotNPT = spotNPT;
        this.npt = npt;
        this.ext = ext;
    }

    public boolean equals(MessageInterface obj) {
        Event other = (Event)obj;
        SCTE130Utils dUtils = SCTE130Utils.getInstance();
        if (!SCTE130Utils.stringsEqual(this.getType(), other.getType())) {
            dUtils.devLog("Event equality check failed. Types don't match.");
            return false;
        }
        if (this.getTime().compareTo(other.getTime()) != 0) {
            dUtils.devLog("Event equality check failed. Times don't match.");
            return false;
        }
        if (!SCTE130Utils.stringsEqual(this.getIdentityADM(), other.getIdentityADM())) {
            dUtils.devLog("Event equality check failed. IdentitieADMs don't match.");
            return false;
        }
        if (!SCTE130Utils.stringsEqual(this.getSystemADM(), other.getSystemADM())) {
            dUtils.devLog("Event equality check failed. SytemADMs don't match.");
            return false;
        }
        if (!SCTE130Utils.stringsEqual(this.getIdentityADS(), other.getIdentityADS())) {
            dUtils.devLog("Event equality check failed. IdentityADS don't match.");
            return false;
        }
        if (!SCTE130Utils.stringsEqual(this.getMessageRef(), other.getMessageRef())) {
            dUtils.devLog("Event equality check failed. MessageRefs don't match.");
            return false;
        }
        if (!SCTE130Utils.objectsEqual(this.getStatusCode(), other.getStatusCode())) {
            dUtils.devLog("Event equality check failed. StatusCodes don't match.");
            return false;
        }
        if (!SCTE130Utils.objectsEqual(this.getSystemContext(), other.getSystemContext())) {
            dUtils.devLog("Event equality check failed. SystemContexts don't match.");
            return false;
        }
        if (!SCTE130Utils.objectsEqual(this.getClient(), other.getClient())) {
            dUtils.devLog("Event equality check failed. Client values don't match.");
            return false;
        }
        if (!SCTE130Utils.objectsEqual(this.getEntertainment(), other.getEntertainment())) {
            dUtils.devLog("Event equality check failed. Entertainment values don't match.");
            return false;
        }
        if (!SCTE130Utils.objectsEqual(this.getEntertainmentNPT(), other.getEntertainmentNPT())) {
            dUtils.devLog("Event equality check failed. EntertainmentNPT values don't match.");
            return false;
        }
        if (!SCTE130Utils.objectsEqual(this.getSpot(), other.getSpot())) {
            dUtils.devLog("Event equality check failed. Spot values don't match.");
            return false;
        }
        if (!SCTE130Utils.objectsEqual(this.getSpotNPT(), other.getSpotNPT())) {
            dUtils.devLog("Event equality check failed. SpotNPT values don't match.");
            return false;
        }
        if (!SCTE130Utils.objectsEqual(this.getNpt(), other.getNpt())) {
            dUtils.devLog("Event equality check failed. NPT values don't match.");
            return false;
        }
        if (!SCTE130Utils.objectsEqual(this.getExt(), other.getExt())) {
            dUtils.devLog("Event equality check failed. Ext values don't match.");
            return false;
        }
        return true;
    }

    public SOAPElement getSOAPElement() throws SOAPException {
        SCTE130Namespaces nameSpaces = SCTE130Namespaces.getInstance();
        SOAPFactory factory = SOAPFactory.newInstance();
        SOAPElement event = factory.createElement(ELE_EVENT, "adm", nameSpaces.getURIForName("adm"));
        nameSpaces.populateNamespace(event, "adm");
        SCTE130Utils.setAttribute(event, ATTR_TYPE, this.getType());
        SCTE130Utils.setAttribute(event, ATTR_TIME, this.getTimeAsStr());
        SCTE130Utils.setAttribute(event, ATTR_IDENTITY_ADM, this.getIdentityADM());
        SCTE130Utils.setAttribute(event, ATTR_SYSTEM_ADM, this.getSystemADM());
        SCTE130Utils.setAttribute(event, ATTR_IDENTITY_ADS, this.getIdentityADS());
        SCTE130Utils.setAttribute(event, ATTR_MESSAGE_REF, this.getMessageRef());
        SCTE130Utils.addOtherAttributes(event, this.anyAttributes);
        SCTE130Utils.addChildElement(event, this.getStatusCode());
        SCTE130Utils.addChildElement(event, this.getSystemContext());
        SCTE130Utils.addChildElement(event, this.getClient());
        SCTE130Utils.addChildElement(event, this.getEntertainment());
        SCTE130Utils.addChildElement(event, this.getEntertainmentNPT());
        SCTE130Utils.addChildElement(event, this.getSpot());
        SCTE130Utils.addChildElement(event, this.getSpotNPT());
        SCTE130Utils.addChildElement(event, this.getNpt());
        SCTE130Utils.addChildElement(event, this.getExt());
        return event;
    }

    public void addAnyAttribute(String attributeName, String attributeValue) {
        this.anyAttributes.put(attributeName, attributeValue);
    }

    public Client getClient() {
        return this.client;
    }

    public void setClient(Client client) {
        this.client = client;
    }

    public Entertainment getEntertainment() {
        return this.entertainment;
    }

    public void setEntertainment(Entertainment entertainment) {
        this.entertainment = entertainment;
    }

    public EntertainmentNPT getEntertainmentNPT() {
        return this.entertainmentNPT;
    }

    public void setEntertainmentNPT(EntertainmentNPT entertainmentNPT) {
        this.entertainmentNPT = entertainmentNPT;
    }

    public Ext getExt() {
        return this.ext;
    }

    public void setExt(Ext ext) {
        this.ext = ext;
    }

    public String getIdentityADM() {
        return this.identityADM;
    }

    public void setIdentityADM(String identityADM) {
        this.identityADM = identityADM;
    }

    public String getIdentityADS() {
        return this.identityADS;
    }

    public void setIdentityADS(String identityADS) {
        this.identityADS = identityADS;
    }

    public String getMessageRef() {
        return this.messageRef;
    }

    public void setMessageRef(String messageRef) {
        this.messageRef = messageRef;
    }

    public NPT getNpt() {
        return this.npt;
    }

    public void setNpt(NPT npt) {
        this.npt = npt;
    }

    public Spot getSpot() {
        return this.spot;
    }

    public void setSpot(Spot spot) {
        this.spot = spot;
    }

    public SpotNPT getSpotNPT() {
        return this.spotNPT;
    }

    public void setSpotNPT(SpotNPT spotNPT) {
        this.spotNPT = spotNPT;
    }

    public StatusCode getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(StatusCode statusCode) {
        this.statusCode = statusCode;
    }

    public String getSystemADM() {
        return this.systemADM;
    }

    public void setSystemADM(String systemADM) {
        this.systemADM = systemADM;
    }

    public SystemContext getSystemContext() {
        return this.systemContext;
    }

    public void setSystemContext(SystemContext systemContext) {
        this.systemContext = systemContext;
    }

    public Date getTime() {
        return this.time;
    }

    public String getTimeAsStr() {
        return DateUtils.formatXSDDateTime(this.time);
    }

    public void setTime(Date time) {
        this.time = time;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }
}

