/*
 * Decompiled with CFR 0.152.
 */
package com.ttv.SCTE130.messages.adm;

import com.ttv.SCTE130.SCTE130Namespaces;
import com.ttv.SCTE130.messages.MessageInterface;
import com.ttv.SCTE130.messages.adm.OpportunityBinding;
import com.ttv.SCTE130.messages.adm.ProviderAvailID;
import com.ttv.SCTE130.messages.adm.Window;
import com.ttv.SCTE130.utils.SCTE130Utils;
import java.util.List;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinearAvailBinding
extends OpportunityBinding
implements MessageInterface {
    private List<ProviderAvailID> providerAvailIds = null;
    private Window window = null;
    private int spliceEventID;
    public static final String ELE_LINEAR_AVAIL_BINDING = "LinearAvailBinding";
    private static final String ATTR_SPLICE_EVENT_ID = "spliceEventID";

    public LinearAvailBinding(Element element) throws Exception {
        super(element);
        String remoteSpliceEventId = element.getAttribute(ATTR_SPLICE_EVENT_ID);
        if (remoteSpliceEventId != null && remoteSpliceEventId.length() > 0) {
            this.spliceEventID = Integer.parseInt(remoteSpliceEventId);
        }
    }

    public LinearAvailBinding() {
    }

    public LinearAvailBinding(String opportunityType, int opportunityNumber, int opportunitiesExpected, int spliceEventID, List<ProviderAvailID> providerAvailIds, Window window) {
        super(opportunityType, opportunityNumber, opportunitiesExpected);
        this.providerAvailIds = providerAvailIds;
        this.window = window;
        this.spliceEventID = spliceEventID;
    }

    @Override
    public boolean equals(MessageInterface obj) {
        if (!super.equals(obj)) {
            return false;
        }
        LinearAvailBinding other = (LinearAvailBinding)obj;
        SCTE130Utils dUtils = SCTE130Utils.getInstance();
        if (!SCTE130Utils.listsEqual(other.getProviderAvailIds(), this.getProviderAvailIds())) {
            dUtils.devLog("LinearAvailBinding equality check failed. LinearAvailBinding ProviderAvailIds don't match.");
            return false;
        }
        if (!SCTE130Utils.objectsEqual(other.getWindow(), this.getWindow())) {
            dUtils.devLog("LinearAvailBinding equality check failed. LinearAvailBinding Windows don't match.");
            return false;
        }
        if (this.getSpliceEventID() != other.getSpliceEventID()) {
            dUtils.devLog("LinearAvailBinding equality check failed. SpliceEventIDs don't match.");
            return false;
        }
        return true;
    }

    @Override
    public SOAPElement getSOAPElement() throws SOAPException {
        SCTE130Namespaces nameSpaces = SCTE130Namespaces.getInstance();
        SOAPFactory factory = SOAPFactory.newInstance();
        SOAPElement linear = factory.createElement(ELE_LINEAR_AVAIL_BINDING, "adm", nameSpaces.getURIForName("adm"));
        nameSpaces.populateNamespace(linear, "adm");
        SCTE130Utils.setAttribute(linear, "opportunityType", this.getOpportunityType());
        SCTE130Utils.setAttribute(linear, "opportunityNumber", this.getOpportunityNumberAsStr());
        SCTE130Utils.setAttribute(linear, "opportunitiesExpected", this.getOpportunitiesExpectedAsStr());
        SCTE130Utils.setAttribute(linear, ATTR_SPLICE_EVENT_ID, this.getSpliceEventIDAsStr());
        SCTE130Utils.addOtherAttributes(linear, this.anyAttributes);
        SCTE130Utils.addChildElementList(linear, this.getProviderAvailIds());
        SCTE130Utils.addChildElement(linear, this.getWindow());
        return linear;
    }

    public List<ProviderAvailID> getProviderAvailIds() {
        return this.providerAvailIds;
    }

    public void setProviderAvailIds(List<ProviderAvailID> providerAvailIds) {
        this.providerAvailIds = providerAvailIds;
    }

    public Window getWindow() {
        return this.window;
    }

    public void setWindow(Window window) {
        this.window = window;
    }

    public int getSpliceEventID() {
        return this.spliceEventID;
    }

    public String getSpliceEventIDAsStr() {
        return "" + this.spliceEventID;
    }

    public void setSpliceEventID(int spliceEventID) {
        this.spliceEventID = spliceEventID;
    }
}

