/*
 * Decompiled with CFR 0.152.
 */
package com.ttv.SCTE130.messages.adm;

import com.ttv.SCTE130.SCTE130Namespaces;
import com.ttv.SCTE130.messages.MessageInterface;
import com.ttv.SCTE130.utils.SCTE130Utils;
import java.security.InvalidParameterException;
import java.util.TreeMap;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class MaxDuration
implements MessageInterface {
    private String duration = null;
    private String durationYears = "0";
    private String durationMonths = "0";
    private String durationDays = "0";
    private String durationHours = "0";
    private String durationMinutes = "0";
    private String durationSeconds = "0";
    private String durationMilliseconds = "0";
    private TreeMap<String, String> anyAttributes = new TreeMap();
    private String[] namedAttributes = new String[0];
    public static final String ELE_MAX_DURATION = "MaxDuration";

    public MaxDuration(Element element) throws InvalidParameterException {
        this.anyAttributes = SCTE130Utils.locateOtherAttributes(this.namedAttributes, element.getAttributes());
        NodeList list = element.getChildNodes();
        for (int indx = 0; indx < list.getLength(); ++indx) {
            Node node = list.item(indx);
            if (!(node instanceof Text)) continue;
            this.duration = ((Text)node).getData();
        }
        if (!this.parseDuration(this.duration)) {
            throw new InvalidParameterException("Failed to parse MaxDuration. Invalid input format [" + this.duration + "]");
        }
    }

    public MaxDuration() {
    }

    public MaxDuration(String duration) throws InvalidParameterException {
        this.duration = duration;
        if (!this.parseDuration(duration)) {
            throw new InvalidParameterException("Invalid parameter format exception. Must be some combination of PnYnMnDTnHnMnS.SSS");
        }
    }

    public boolean parseDuration(String theDuration) {
        String dateString = null;
        String timeString = null;
        if (!(theDuration = theDuration.toUpperCase()).startsWith("P")) {
            theDuration = "P" + theDuration;
        }
        char[] characters = theDuration.toCharArray();
        for (int indx = 0; indx < characters.length; ++indx) {
            char c = characters[indx];
            if (c == 'P' || c == 'T' || c == 'Y' || c == 'M' || c == 'D' || c == 'H' || c == 'S' || c == '.' || Character.isDigit(c)) continue;
            return false;
        }
        if (theDuration.indexOf(84) != -1) {
            String[] results = theDuration.split("T");
            if (results.length == 2) {
                dateString = results[0];
                timeString = results[1];
            } else {
                timeString = results[0];
            }
        } else {
            dateString = theDuration;
        }
        this.parseDate(dateString);
        this.parseTime(timeString);
        return true;
    }

    private void parseDate(String dateString) {
        if (dateString != null && dateString.length() > 0) {
            String value = "";
            char[] dateChars = dateString.toCharArray();
            for (int indx = 0; indx < dateChars.length; ++indx) {
                char c = dateChars[indx];
                if (c == 'P') continue;
                if (Character.isDigit(c)) {
                    value = value + c;
                    continue;
                }
                if (c == 'Y') {
                    this.durationYears = value;
                    value = "";
                    continue;
                }
                if (c == 'M') {
                    this.durationMonths = value;
                    value = "";
                    continue;
                }
                if (c != 'D') continue;
                this.durationDays = value;
                value = "";
            }
        }
    }

    private void parseTime(String timeString) {
        if (timeString != null && timeString.length() > 0) {
            String value = "";
            boolean millisecondShift = false;
            char[] timeChars = timeString.toCharArray();
            for (int indx = 0; indx < timeChars.length; ++indx) {
                char c = timeChars[indx];
                if (c == 'T') continue;
                if (Character.isDigit(c)) {
                    value = value + c;
                    continue;
                }
                if (c == 'H') {
                    this.durationHours = value;
                    value = "";
                    continue;
                }
                if (c == 'M') {
                    this.durationMinutes = value;
                    value = "";
                    continue;
                }
                if (c == '.') {
                    this.durationSeconds = value;
                    value = "";
                    millisecondShift = true;
                    continue;
                }
                if (c != 'S') continue;
                if (millisecondShift) {
                    this.durationMilliseconds = value;
                } else {
                    this.durationSeconds = value;
                }
                value = "";
            }
        }
    }

    public boolean equals(MessageInterface obj) {
        MaxDuration other = (MaxDuration)obj;
        SCTE130Utils dUtils = SCTE130Utils.getInstance();
        if (!SCTE130Utils.stringsEqual(this.getDuration(), other.getDuration())) {
            dUtils.devLog("MaxDuration equality check failed. Durations don't match.");
            return false;
        }
        return true;
    }

    public SOAPElement getSOAPElement() throws SOAPException {
        SCTE130Namespaces nameSpaces = SCTE130Namespaces.getInstance();
        SOAPFactory factory = SOAPFactory.newInstance();
        SOAPElement scpe = factory.createElement(ELE_MAX_DURATION, "adm", nameSpaces.getURIForName("adm"));
        nameSpaces.populateNamespace(scpe, "adm");
        SCTE130Utils.addOtherAttributes(scpe, this.anyAttributes);
        scpe.addTextNode(this.getDuration());
        return scpe;
    }

    public void addAnyAttribute(String attributeName, String attributeValue) {
        this.anyAttributes.put(attributeName, attributeValue);
    }

    public String getDurationHours() {
        return this.durationHours;
    }

    public int getDurationHoursAsInt() {
        return Integer.parseInt(this.durationHours);
    }

    public String getDurationMinutes() {
        return this.durationMinutes;
    }

    public int getDurationMinutesAsInt() {
        return Integer.parseInt(this.durationMinutes);
    }

    public String getDurationSeconds() {
        return this.durationSeconds;
    }

    public int getDurationSecondsAsInt() {
        return Integer.parseInt(this.durationSeconds);
    }

    public String getDurationMilliseconds() {
        return this.durationMilliseconds;
    }

    public int getDurationMillisecondsAsInt() {
        return Integer.parseInt(this.durationMilliseconds);
    }

    public int getDurationInSeconds() {
        int totalSeconds = 0;
        totalSeconds += Integer.parseInt(this.getDurationHours()) * 3600;
        totalSeconds += Integer.parseInt(this.getDurationMinutes()) * 60;
        return totalSeconds += Integer.parseInt(this.getDurationSeconds());
    }

    public String getDuration() {
        return this.duration;
    }

    public void setDuration(String duration) throws InvalidParameterException {
        this.duration = duration;
        if (!this.parseDuration(this.duration)) {
            throw new InvalidParameterException("Invalid duration specification. Must be in PnYnMnDTnHnMnS.SSS format.");
        }
    }

    public String getDurationDays() {
        return this.durationDays;
    }

    public int getDurationDaysAsInt() {
        return Integer.parseInt(this.durationDays);
    }

    public void setDurationDays(String durationDays) {
        this.durationDays = durationDays;
    }

    public String getDurationMonths() {
        return this.durationMonths;
    }

    public int getDurationMonthsAsInt() {
        return Integer.parseInt(this.durationMonths);
    }

    public void setDurationMonths(String durationMonths) {
        this.durationMonths = durationMonths;
    }

    public String getDurationYears() {
        return this.durationYears;
    }

    public int getDurationYearsAsInt() {
        return Integer.parseInt(this.durationYears);
    }

    public void setDurationYears(String durationYears) {
        this.durationYears = durationYears;
    }

    public void setDurationHours(String durationHours) {
        this.durationHours = durationHours;
    }

    public void setDurationMilliseconds(String durationMilliseconds) {
        this.durationMilliseconds = durationMilliseconds;
    }

    public void setDurationMinutes(String durationMinutes) {
        this.durationMinutes = durationMinutes;
    }

    public void setDurationSeconds(String durationSeconds) {
        this.durationSeconds = durationSeconds;
    }

    public static void main(String[] args) {
        MaxDuration d = new MaxDuration("P1Y2M3DT10H15M60.700S");
        System.out.println("Duration: " + d.getDuration());
        System.out.println("Years:    " + d.getDurationYears());
        System.out.println("Months:   " + d.getDurationMonths());
        System.out.println("Days:     " + d.getDurationDays());
        System.out.println("Hours:    " + d.getDurationHours());
        System.out.println("Minutes:  " + d.getDurationMinutes());
        System.out.println("Seconds:  " + d.getDurationSeconds());
        System.out.println("Millis:   " + d.getDurationMilliseconds());
    }
}

