/*
 * Decompiled with CFR 0.152.
 */
package com.ttv.SCTE130.messages.adm;

import com.ttv.SCTE130.SCTE130MessageFactory;
import com.ttv.SCTE130.SCTE130MessageFactoryLocator;
import com.ttv.SCTE130.SCTE130Namespaces;
import com.ttv.SCTE130.messages.MessageInterface;
import com.ttv.SCTE130.messages.adm.EffectiveEndDateTime;
import com.ttv.SCTE130.messages.adm.EffectiveStartDateTime;
import com.ttv.SCTE130.messages.adm.Scope;
import com.ttv.SCTE130.messages.core.Duration;
import com.ttv.SCTE130.messages.core.Ext;
import com.ttv.SCTE130.utils.SCTE130Utils;
import java.util.TreeMap;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PlacementConstraints
implements MessageInterface {
    private TreeMap<String, String> anyAttributes = new TreeMap();
    private String[] namedAttributes = new String[0];
    private Duration duration = null;
    private EffectiveStartDateTime effectiveStart = null;
    private EffectiveEndDateTime effectiveEnd = null;
    private Scope scope = null;
    private Ext ext = null;
    public static final String ELE_PLACEMENT_CONSTRAINTS = "PlacementConstraints";

    public PlacementConstraints(Element element) throws Exception {
        this.anyAttributes = SCTE130Utils.locateOtherAttributes(this.namedAttributes, element.getAttributes());
        NodeList list = element.getChildNodes();
        for (int indx = 0; indx < list.getLength(); ++indx) {
            Node node = list.item(indx);
            if (!(node instanceof Element)) continue;
            Element child = (Element)node;
            SCTE130MessageFactory factory = SCTE130MessageFactoryLocator.getMessageFactory(child);
            Object obj = factory.allocateSCTE130Message(child);
            if (obj instanceof EffectiveStartDateTime) {
                this.effectiveStart = (EffectiveStartDateTime)obj;
            }
            if (obj instanceof EffectiveEndDateTime) {
                this.effectiveEnd = (EffectiveEndDateTime)obj;
            }
            if (obj instanceof Scope) {
                this.scope = (Scope)obj;
            }
            if (obj instanceof Duration) {
                this.duration = (Duration)obj;
            }
            if (!(obj instanceof Ext)) continue;
            this.ext = (Ext)obj;
        }
    }

    public PlacementConstraints() {
    }

    public PlacementConstraints(Duration duration, EffectiveStartDateTime effectiveStart, EffectiveEndDateTime effectiveEnd, Scope scope, Ext ext) {
        this.duration = duration;
        this.effectiveStart = effectiveStart;
        this.effectiveEnd = effectiveEnd;
        this.scope = scope;
        this.ext = ext;
    }

    public boolean equals(MessageInterface obj) {
        PlacementConstraints other = (PlacementConstraints)obj;
        SCTE130Utils dUtils = SCTE130Utils.getInstance();
        if (!SCTE130Utils.objectsEqual(this.getEffectiveStart(), other.getEffectiveStart())) {
            dUtils.devLog("PlacementConstraints equality check failed. EffectiveStartDateTimes don't match.");
            return false;
        }
        if (!SCTE130Utils.objectsEqual(this.getEffectiveEnd(), other.getEffectiveEnd())) {
            dUtils.devLog("PlacementConstraints equality check failed. EffectiveEndDateTimes don't match.");
            return false;
        }
        if (!SCTE130Utils.objectsEqual(this.getScope(), other.getScope())) {
            dUtils.devLog("PlacementConstraints equality check failed. Scope don't match.");
            return false;
        }
        if (!SCTE130Utils.objectsEqual(this.getDuration(), other.getDuration())) {
            dUtils.devLog("PlacementConstraints equality check failed. Duration don't match.");
            return false;
        }
        if (!SCTE130Utils.objectsEqual(this.getExt(), other.getExt())) {
            dUtils.devLog("Constraints equality check failed. Exts don't match.");
            return false;
        }
        return true;
    }

    public SOAPElement getSOAPElement() throws SOAPException {
        SCTE130Namespaces nameSpaces = SCTE130Namespaces.getInstance();
        SOAPFactory factory = SOAPFactory.newInstance();
        SOAPElement content = factory.createElement(ELE_PLACEMENT_CONSTRAINTS, "adm", nameSpaces.getURIForName("adm"));
        nameSpaces.populateNamespace(content, "adm");
        SCTE130Utils.addOtherAttributes(content, this.anyAttributes);
        SCTE130Utils.addChildElement(content, this.getDuration());
        SCTE130Utils.addChildElement(content, this.getEffectiveStart());
        SCTE130Utils.addChildElement(content, this.getEffectiveEnd());
        SCTE130Utils.addChildElement(content, this.getScope());
        SCTE130Utils.addChildElement(content, this.getExt());
        return content;
    }

    public void addAnyAttribute(String attributeName, String attributeValue) {
        this.anyAttributes.put(attributeName, attributeValue);
    }

    public EffectiveEndDateTime getEffectiveEnd() {
        return this.effectiveEnd;
    }

    public void setEffectiveEnd(EffectiveEndDateTime effectiveEnd) {
        this.effectiveEnd = effectiveEnd;
    }

    public EffectiveStartDateTime getEffectiveStart() {
        return this.effectiveStart;
    }

    public void setEffectiveStart(EffectiveStartDateTime effectiveStart) {
        this.effectiveStart = effectiveStart;
    }

    public Duration getDuration() {
        return this.duration;
    }

    public void setDuration(Duration duration) {
        this.duration = duration;
    }

    public Ext getExt() {
        return this.ext;
    }

    public void setExt(Ext ext) {
        this.ext = ext;
    }

    public Scope getScope() {
        return this.scope;
    }

    public void setScope(Scope scope) {
        this.scope = scope;
    }
}

