/*
 * Decompiled with CFR 0.152.
 */
package com.ttv.SCTE130.messages.adm;

import com.ttv.SCTE130.SCTE130MessageFactory;
import com.ttv.SCTE130.SCTE130MessageFactoryLocator;
import com.ttv.SCTE130.SCTE130Namespaces;
import com.ttv.SCTE130.messages.MessageInterface;
import com.ttv.SCTE130.messages.TopLevelMessage;
import com.ttv.SCTE130.messages.adm.ADMData;
import com.ttv.SCTE130.messages.adm.Client;
import com.ttv.SCTE130.messages.adm.Entertainment;
import com.ttv.SCTE130.messages.adm.PlacementOpportunity;
import com.ttv.SCTE130.messages.adm.Service;
import com.ttv.SCTE130.messages.adm.SystemContext;
import com.ttv.SCTE130.messages.core.Ext;
import com.ttv.SCTE130.messages.core.InitiatorData;
import com.ttv.SCTE130.utils.SCTE130Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlacementRequest
implements MessageInterface,
TopLevelMessage {
    private String messageId = null;
    private String version = "1.0";
    private String identity = null;
    private String system = null;
    private String resend = null;
    private boolean updatesAllowed = false;
    private TreeMap<String, String> anyAttributes = new TreeMap();
    private InitiatorData initData = null;
    private SystemContext systemContext = null;
    private List<Service> services = null;
    private Entertainment entertainment = null;
    private Client client = null;
    private ADMData admData = null;
    private List<PlacementOpportunity> oppies = null;
    private Ext ext = null;
    public static final String ELE_PLACEMENT_REQUEST = "PlacementRequest";
    private static final String ATTR_MESSAGE_ID = "messageId";
    private static final String ATTR_IDENTITY = "identity";
    private static final String ATTR_VERSION = "version";
    private static final String ATTR_SYSTEM = "system";
    private static final String ATTR_RESEND = "resend";
    private static final String ATTR_UPDATES_ALLOWED = "updatesAllowed";
    private String[] namedAttributes = new String[]{"messageId", "version", "identity", "system", "resend", "updatesAllowed"};

    public PlacementRequest(Element element) throws Exception {
        this.messageId = element.getAttribute(ATTR_MESSAGE_ID);
        this.identity = element.getAttribute(ATTR_IDENTITY);
        this.system = element.getAttribute(ATTR_SYSTEM);
        this.resend = element.getAttribute(ATTR_RESEND);
        String remoteUpdatesAllowed = element.getAttribute(ATTR_UPDATES_ALLOWED);
        if (remoteUpdatesAllowed != null && remoteUpdatesAllowed.length() > 0) {
            this.updatesAllowed = Boolean.parseBoolean(remoteUpdatesAllowed);
        }
        this.anyAttributes = SCTE130Utils.locateOtherAttributes(this.namedAttributes, element.getAttributes());
        NodeList list = element.getChildNodes();
        for (int indx = 0; indx < list.getLength(); ++indx) {
            Node node = list.item(indx);
            if (!(node instanceof Element)) continue;
            Element child = (Element)node;
            SCTE130MessageFactory factory = SCTE130MessageFactoryLocator.getMessageFactory(child);
            Object obj = factory.allocateSCTE130Message(child);
            if (obj instanceof InitiatorData) {
                this.initData = (InitiatorData)obj;
            }
            if (obj instanceof SystemContext) {
                this.systemContext = (SystemContext)obj;
            }
            if (obj instanceof Service) {
                if (this.services == null) {
                    this.services = new ArrayList<Service>();
                }
                this.services.add((Service)obj);
            }
            if (obj instanceof Entertainment) {
                this.entertainment = (Entertainment)obj;
            }
            if (obj instanceof Client) {
                this.client = (Client)obj;
            }
            if (obj instanceof ADMData) {
                this.admData = (ADMData)obj;
            }
            if (obj instanceof PlacementOpportunity) {
                if (this.oppies == null) {
                    this.oppies = new ArrayList<PlacementOpportunity>();
                }
                this.oppies.add((PlacementOpportunity)obj);
            }
            if (!(obj instanceof Ext)) continue;
            this.ext = (Ext)obj;
        }
    }

    public PlacementRequest() {
    }

    public PlacementRequest(String messageId, String identity, String system, boolean updatesAllowed, SystemContext systemContext, List<Service> services, Entertainment entertainment, Client client, ADMData admData, List<PlacementOpportunity> oppies, Ext ext) {
        this.messageId = messageId;
        this.identity = identity;
        this.system = system;
        this.updatesAllowed = updatesAllowed;
        this.systemContext = systemContext;
        this.services = services;
        this.entertainment = entertainment;
        this.client = client;
        this.admData = admData;
        this.oppies = oppies;
        this.ext = ext;
    }

    @Override
    public boolean equals(MessageInterface obj) {
        PlacementRequest other = (PlacementRequest)obj;
        SCTE130Utils dUtils = SCTE130Utils.getInstance();
        if (!SCTE130Utils.stringsEqual(this.getMessageId(), other.getMessageId())) {
            dUtils.devLog("PlacementRequest equality check failed. Message Ids don't match.");
            return false;
        }
        if (!SCTE130Utils.stringsEqual(this.getIdentity(), other.getIdentity())) {
            dUtils.devLog("PlacementRequest equality check failed. Message identities don't match.");
            return false;
        }
        if (!SCTE130Utils.stringsEqual(this.getSystem(), other.getSystem())) {
            dUtils.devLog("PlacementRequest equality check failed. Systems don't match.");
            return false;
        }
        if (!SCTE130Utils.stringsEqual(this.getResend(), other.getResend())) {
            dUtils.devLog("PlacementRequest equality check failed. Resend attributes don't match.");
            return false;
        }
        if (this.isUpdatesAllowed() != other.isUpdatesAllowed()) {
            dUtils.devLog("PlacementRequest equality check failed. UpdatesAllowed don't match.");
            return false;
        }
        if (!SCTE130Utils.objectsEqual(this.getInitData(), other.getInitData())) {
            dUtils.devLog("PlacementRequest equality check failed. InitiatorData don't match.");
            return false;
        }
        if (!SCTE130Utils.objectsEqual(this.getSystemContext(), other.getSystemContext())) {
            dUtils.devLog("PlacementRequest equality check failed. SystemContext don't match.");
            return false;
        }
        if (!SCTE130Utils.listsEqual(this.getServices(), other.getServices())) {
            dUtils.devLog("PlacementRequest equality check failed. Service Itemss don't match.");
            return false;
        }
        if (!SCTE130Utils.objectsEqual(this.getEntertainment(), other.getEntertainment())) {
            dUtils.devLog("PlacementRequest equality check failed. Entertainment items don't match.");
            return false;
        }
        if (!SCTE130Utils.objectsEqual(this.getClient(), other.getClient())) {
            dUtils.devLog("PlacementRequest equality check failed. Clients don't match.");
            return false;
        }
        if (!SCTE130Utils.objectsEqual(this.getAdmData(), other.getAdmData())) {
            dUtils.devLog("PlacementRequest equality check failed. ADMData don't match.");
            return false;
        }
        if (!SCTE130Utils.listsEqual(this.getOppies(), other.getOppies())) {
            dUtils.devLog("PlacementRequest equality check failed. PlacementOpportunities don't match.");
            return false;
        }
        if (!SCTE130Utils.objectsEqual(this.getExt(), other.getExt())) {
            dUtils.devLog("PlacementRequest equality check failed. Exts don't match.");
            return false;
        }
        return true;
    }

    @Override
    public SOAPElement getSOAPElement() throws SOAPException {
        SCTE130Namespaces nameSpaces = SCTE130Namespaces.getInstance();
        SOAPFactory factory = SOAPFactory.newInstance();
        SOAPElement placement = factory.createElement(ELE_PLACEMENT_REQUEST, "adm", nameSpaces.getURIForName("adm"));
        nameSpaces.populateNamespace(placement, "adm");
        SCTE130Utils.setAttribute(placement, ATTR_MESSAGE_ID, this.getMessageId());
        SCTE130Utils.setAttribute(placement, ATTR_VERSION, this.getVersion());
        SCTE130Utils.setAttribute(placement, ATTR_IDENTITY, this.getIdentity());
        SCTE130Utils.setAttribute(placement, ATTR_SYSTEM, this.getSystem());
        SCTE130Utils.setAttribute(placement, ATTR_RESEND, this.getResend());
        SCTE130Utils.setAttribute(placement, ATTR_UPDATES_ALLOWED, Boolean.toString(this.isUpdatesAllowed()));
        SCTE130Utils.addOtherAttributes(placement, this.anyAttributes);
        SCTE130Utils.addChildElement(placement, this.getInitData());
        SCTE130Utils.addChildElement(placement, this.getSystemContext());
        SCTE130Utils.addChildElementList(placement, this.getServices());
        SCTE130Utils.addChildElement(placement, this.getEntertainment());
        SCTE130Utils.addChildElement(placement, this.getClient());
        SCTE130Utils.addChildElement(placement, this.getAdmData());
        SCTE130Utils.addChildElementList(placement, this.getOppies());
        SCTE130Utils.addChildElement(placement, this.getExt());
        return placement;
    }

    public void addAnyAttribute(String attributeName, String attributeValue) {
        this.anyAttributes.put(attributeName, attributeValue);
    }

    @Override
    public InitiatorData getInitData() {
        return this.initData;
    }

    public void setInitData(InitiatorData initData) {
        this.initData = initData;
    }

    public String getResend() {
        return this.resend;
    }

    public void setResend(String resend) {
        this.resend = resend;
    }

    public String getIdentity() {
        return this.identity;
    }

    public void setIdentity(String identity) {
        this.identity = identity;
    }

    public boolean isUpdatesAllowed() {
        return this.updatesAllowed;
    }

    public void setUpdatesAllowed(boolean updatesAllowed) {
        this.updatesAllowed = updatesAllowed;
    }

    public ADMData getAdmData() {
        return this.admData;
    }

    public void setAdmData(ADMData admData) {
        this.admData = admData;
    }

    public Client getClient() {
        return this.client;
    }

    public void setClient(Client client) {
        this.client = client;
    }

    public Entertainment getEntertainment() {
        return this.entertainment;
    }

    public void setEntertainment(Entertainment entertainment) {
        this.entertainment = entertainment;
    }

    public Ext getExt() {
        return this.ext;
    }

    public void setExt(Ext ext) {
        this.ext = ext;
    }

    @Override
    public String getMessageId() {
        return this.messageId;
    }

    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    public List<PlacementOpportunity> getOppies() {
        return this.oppies;
    }

    public void setOppies(List<PlacementOpportunity> oppies) {
        this.oppies = oppies;
    }

    public List<Service> getServices() {
        return this.services;
    }

    public void setServices(List<Service> services) {
        this.services = services;
    }

    public String getSystem() {
        return this.system;
    }

    public void setSystem(String system) {
        this.system = system;
    }

    public SystemContext getSystemContext() {
        return this.systemContext;
    }

    public void setSystemContext(SystemContext systemContext) {
        this.systemContext = systemContext;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }
}

