/*
 * Decompiled with CFR 0.152.
 */
package com.ttv.SCTE130.messages.adm;

import com.ttv.SCTE130.SCTE130MessageFactory;
import com.ttv.SCTE130.SCTE130MessageFactoryLocator;
import com.ttv.SCTE130.SCTE130Namespaces;
import com.ttv.SCTE130.messages.MessageInterface;
import com.ttv.SCTE130.messages.TopLevelMessage;
import com.ttv.SCTE130.messages.adm.ADMData;
import com.ttv.SCTE130.messages.adm.Client;
import com.ttv.SCTE130.messages.adm.Entertainment;
import com.ttv.SCTE130.messages.adm.PlacementDecision;
import com.ttv.SCTE130.messages.adm.PlacementOpportunity;
import com.ttv.SCTE130.messages.adm.Service;
import com.ttv.SCTE130.messages.adm.SystemContext;
import com.ttv.SCTE130.messages.core.Ext;
import com.ttv.SCTE130.messages.core.InitiatorData;
import com.ttv.SCTE130.messages.core.StatusCode;
import com.ttv.SCTE130.utils.SCTE130Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlacementUpdateNotification
implements MessageInterface,
TopLevelMessage {
    private String messageId = null;
    private String version = "1.0";
    private String identity = null;
    private String system = null;
    private String resend = null;
    private String messageRef = null;
    private String updateAction = null;
    private TreeMap<String, String> anyAttributes = new TreeMap();
    private InitiatorData initData = null;
    private StatusCode statusCode = null;
    private SystemContext systemContext = null;
    private List<Service> services = null;
    private Entertainment entertainment = null;
    private Client client = null;
    private ADMData admData = null;
    private List<PlacementDecision> decisions = null;
    private Ext ext = null;
    public static final String ELE_PLACEMENT_UPDATE_NOTIFICATION = "PlacementUpdateNotification";
    private static final String ATTR_MESSAGE_ID = "messageId";
    private static final String ATTR_VERSION = "version";
    private static final String ATTR_IDENTITY = "identity";
    private static final String ATTR_SYSTEM = "system";
    private static final String ATTR_RESEND = "resend";
    private static final String ATTR_MESSAGE_REF = "messageRef";
    private static final String ATTR_UPDATE_ACTION = "updateAction";
    private String[] namedAttributes = new String[]{"messageId", "version", "identity", "system", "resend", "messageRef", "updateAction"};
    public static final String UPDATE_ACTION_REPLACE = "replace";
    public static final String UPDATE_ACTION_CANCEL = "cancel";

    public PlacementUpdateNotification(Element element) throws Exception {
        this.messageId = element.getAttribute(ATTR_MESSAGE_ID);
        this.identity = element.getAttribute(ATTR_IDENTITY);
        this.updateAction = element.getAttribute(ATTR_UPDATE_ACTION);
        this.system = element.getAttribute(ATTR_SYSTEM);
        this.resend = element.getAttribute(ATTR_RESEND);
        this.messageRef = element.getAttribute(ATTR_MESSAGE_REF);
        this.anyAttributes = SCTE130Utils.locateOtherAttributes(this.namedAttributes, element.getAttributes());
        NodeList list = element.getChildNodes();
        for (int indx = 0; indx < list.getLength(); ++indx) {
            Node node = list.item(indx);
            if (!(node instanceof Element)) continue;
            Element child = (Element)node;
            SCTE130MessageFactory factory = SCTE130MessageFactoryLocator.getMessageFactory(child);
            Object obj = factory.allocateSCTE130Message(child);
            if (obj instanceof InitiatorData) {
                this.initData = (InitiatorData)obj;
            }
            if (obj instanceof StatusCode) {
                this.statusCode = (StatusCode)obj;
            }
            if (obj instanceof SystemContext) {
                this.systemContext = (SystemContext)obj;
            }
            if (obj instanceof Service) {
                if (this.services == null) {
                    this.services = new ArrayList<Service>();
                }
                this.services.add((Service)obj);
            }
            if (obj instanceof Entertainment) {
                this.entertainment = (Entertainment)obj;
            }
            if (obj instanceof Client) {
                this.client = (Client)obj;
            }
            if (obj instanceof ADMData) {
                this.admData = (ADMData)obj;
            }
            if (obj instanceof PlacementOpportunity) {
                if (this.decisions == null) {
                    this.decisions = new ArrayList<PlacementDecision>();
                }
                this.decisions.add((PlacementDecision)obj);
            }
            if (!(obj instanceof Ext)) continue;
            this.ext = (Ext)obj;
        }
    }

    public PlacementUpdateNotification() {
    }

    public PlacementUpdateNotification(String messageId, String identity, String system, String messageRef, String updateAction, StatusCode statusCode, SystemContext systemContext, List<Service> services, Entertainment entertainment, Client client, ADMData admData, List<PlacementDecision> decisions, Ext ext) {
        this.messageId = messageId;
        this.identity = identity;
        this.system = system;
        this.messageRef = messageRef;
        this.updateAction = updateAction;
        this.statusCode = statusCode;
        this.systemContext = systemContext;
        this.services = services;
        this.entertainment = entertainment;
        this.client = client;
        this.admData = admData;
        this.decisions = decisions;
        this.ext = ext;
    }

    @Override
    public boolean equals(MessageInterface obj) {
        PlacementUpdateNotification other = (PlacementUpdateNotification)obj;
        SCTE130Utils dUtils = SCTE130Utils.getInstance();
        if (!SCTE130Utils.stringsEqual(this.getMessageId(), other.getMessageId())) {
            dUtils.devLog("PlacementUpdateNotification equality check failed. Message Ids don't match.");
            return false;
        }
        if (!SCTE130Utils.stringsEqual(this.getIdentity(), other.getIdentity())) {
            dUtils.devLog("PlacementUpdateNotification equality check failed. Message identities don't match.");
            return false;
        }
        if (!SCTE130Utils.stringsEqual(this.getResend(), other.getResend())) {
            dUtils.devLog("PlacementUpdateNotification equality check failed. Resends don't match.");
            return false;
        }
        if (!SCTE130Utils.stringsEqual(this.getSystem(), other.getSystem())) {
            dUtils.devLog("PlacementUpdateNotification equality check failed. Systems don't match.");
            return false;
        }
        if (!SCTE130Utils.stringsEqual(this.getMessageRef(), other.getMessageRef())) {
            dUtils.devLog("PlacementUpdateNotification equality check failed. MessageRefs don't match.");
            return false;
        }
        if (!SCTE130Utils.stringsEqual(this.getUpdateAction(), other.getUpdateAction())) {
            dUtils.devLog("PlacementUpdateNotification equality check failed. UpdateActions don't match.");
            return false;
        }
        if (!SCTE130Utils.objectsEqual(this.getInitData(), other.getInitData())) {
            dUtils.devLog("PlacementUpdateNotification equality check failed. InitiatorData don't match.");
            return false;
        }
        if (!SCTE130Utils.objectsEqual(this.getStatusCode(), other.getStatusCode())) {
            dUtils.devLog("PlacementUpdateNotification equality check failed. StatusCodes don't match.");
            return false;
        }
        if (!SCTE130Utils.objectsEqual(this.getSystemContext(), other.getSystemContext())) {
            dUtils.devLog("PlacementUpdateNotification equality check failed. System Contexts don't match.");
            return false;
        }
        if (!SCTE130Utils.listsEqual(this.getServices(), other.getServices())) {
            dUtils.devLog("PlacementUpdateNotification equality check failed. Services don't match.");
            return false;
        }
        if (!SCTE130Utils.objectsEqual(this.getEntertainment(), other.getEntertainment())) {
            dUtils.devLog("PlacementUpdateNotification equality check failed. Entertainment items don't match.");
            return false;
        }
        if (!SCTE130Utils.objectsEqual(this.getClient(), other.getClient())) {
            dUtils.devLog("PlacementUpdateNotification equality check failed. Clients don't match.");
            return false;
        }
        if (!SCTE130Utils.objectsEqual(this.getAdmData(), other.getAdmData())) {
            dUtils.devLog("PlacementUpdateNotification equality check failed. ADMData items don't match.");
            return false;
        }
        if (!SCTE130Utils.listsEqual(this.getDecisions(), other.getDecisions())) {
            dUtils.devLog("PlacementUpdateNotification equality check failed. Placement Decisions don't match.");
            return false;
        }
        if (!SCTE130Utils.objectsEqual(this.getExt(), other.getExt())) {
            dUtils.devLog("PlacementUpdateNotification equality check failed. Exts don't match.");
            return false;
        }
        return true;
    }

    @Override
    public SOAPElement getSOAPElement() throws SOAPException {
        SCTE130Namespaces nameSpaces = SCTE130Namespaces.getInstance();
        SOAPFactory factory = SOAPFactory.newInstance();
        SOAPElement update = factory.createElement(ELE_PLACEMENT_UPDATE_NOTIFICATION, "adm", nameSpaces.getURIForName("adm"));
        nameSpaces.populateNamespace(update, "adm");
        SCTE130Utils.setAttribute(update, ATTR_MESSAGE_ID, this.getMessageId());
        SCTE130Utils.setAttribute(update, ATTR_VERSION, this.getVersion());
        SCTE130Utils.setAttribute(update, ATTR_IDENTITY, this.getIdentity());
        SCTE130Utils.setAttribute(update, ATTR_SYSTEM, this.getSystem());
        SCTE130Utils.setAttribute(update, ATTR_RESEND, this.getResend());
        SCTE130Utils.setAttribute(update, ATTR_MESSAGE_REF, this.getMessageRef());
        SCTE130Utils.setAttribute(update, ATTR_UPDATE_ACTION, this.getUpdateAction());
        SCTE130Utils.addOtherAttributes(update, this.anyAttributes);
        SCTE130Utils.addChildElement(update, this.getInitData());
        SCTE130Utils.addChildElement(update, this.getStatusCode());
        SCTE130Utils.addChildElement(update, this.getSystemContext());
        SCTE130Utils.addChildElementList(update, this.getServices());
        SCTE130Utils.addChildElement(update, this.getEntertainment());
        SCTE130Utils.addChildElement(update, this.getClient());
        SCTE130Utils.addChildElement(update, this.getAdmData());
        SCTE130Utils.addChildElementList(update, this.getDecisions());
        SCTE130Utils.addChildElement(update, this.getExt());
        return update;
    }

    public void addAnyAttribute(String attributeName, String attributeValue) {
        this.anyAttributes.put(attributeName, attributeValue);
    }

    @Override
    public InitiatorData getInitData() {
        return this.initData;
    }

    public void setInitData(InitiatorData initData) {
        this.initData = initData;
    }

    public String getResend() {
        return this.resend;
    }

    public void setResend(String resend) {
        this.resend = resend;
    }

    public StatusCode getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(StatusCode statusCode) {
        this.statusCode = statusCode;
    }

    public ADMData getAdmData() {
        return this.admData;
    }

    public void setAdmData(ADMData admData) {
        this.admData = admData;
    }

    public Client getClient() {
        return this.client;
    }

    public void setClient(Client client) {
        this.client = client;
    }

    public Entertainment getEntertainment() {
        return this.entertainment;
    }

    public void setEntertainment(Entertainment entertainment) {
        this.entertainment = entertainment;
    }

    public Ext getExt() {
        return this.ext;
    }

    public void setExt(Ext ext) {
        this.ext = ext;
    }

    public String getIdentity() {
        return this.identity;
    }

    public void setIdentity(String identity) {
        this.identity = identity;
    }

    @Override
    public String getMessageId() {
        return this.messageId;
    }

    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    public String getMessageRef() {
        return this.messageRef;
    }

    public void setMessageRef(String messageRef) {
        this.messageRef = messageRef;
    }

    public List<PlacementDecision> getDecisions() {
        return this.decisions;
    }

    public void setDecisions(List<PlacementDecision> decisions) {
        this.decisions = decisions;
    }

    public List<Service> getServices() {
        return this.services;
    }

    public void setServices(List<Service> services) {
        this.services = services;
    }

    public String getSystem() {
        return this.system;
    }

    public void setSystem(String system) {
        this.system = system;
    }

    public SystemContext getSystemContext() {
        return this.systemContext;
    }

    public void setSystemContext(SystemContext systemContext) {
        this.systemContext = systemContext;
    }

    public String getUpdateAction() {
        return this.updateAction;
    }

    public void setUpdateAction(String updateAction) {
        this.updateAction = updateAction;
    }

    public String getVersion() {
        return this.version;
    }
}

