/*
 * Decompiled with CFR 0.152.
 */
package com.ttv.SCTE130.messages.adm;

import com.ttv.SCTE130.SCTE130MessageFactory;
import com.ttv.SCTE130.SCTE130MessageFactoryLocator;
import com.ttv.SCTE130.SCTE130Namespaces;
import com.ttv.SCTE130.messages.MessageInterface;
import com.ttv.SCTE130.messages.adm.Service;
import com.ttv.SCTE130.messages.adm.SystemContext;
import com.ttv.SCTE130.messages.core.Ext;
import com.ttv.SCTE130.utils.SCTE130Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceDescription
implements MessageInterface {
    private TreeMap<String, String> anyAttributes = new TreeMap();
    private String[] namedAttributes = new String[0];
    private SystemContext systemContext = null;
    private List<Service> services = null;
    private Ext ext = null;
    public static final String ELE_SERVICE_DESCRIPTION = "ServiceDescription";

    public ServiceDescription(Element element) throws Exception {
        this.anyAttributes = SCTE130Utils.locateOtherAttributes(this.namedAttributes, element.getAttributes());
        NodeList list = element.getChildNodes();
        for (int indx = 0; indx < list.getLength(); ++indx) {
            Node node = list.item(indx);
            if (!(node instanceof Element)) continue;
            Element child = (Element)node;
            SCTE130MessageFactory factory = SCTE130MessageFactoryLocator.getMessageFactory(child);
            Object obj = factory.allocateSCTE130Message(child);
            if (obj instanceof SystemContext) {
                this.systemContext = (SystemContext)obj;
            }
            if (obj instanceof Service) {
                if (this.services == null) {
                    this.services = new ArrayList<Service>();
                }
                this.services.add((Service)obj);
            }
            if (!(obj instanceof Ext)) continue;
            this.ext = (Ext)obj;
        }
    }

    public ServiceDescription() {
    }

    public ServiceDescription(List<Service> services, SystemContext systemContext, Ext ext) {
        this.services = services;
        this.systemContext = systemContext;
        this.ext = ext;
    }

    @Override
    public boolean equals(MessageInterface obj) {
        ServiceDescription other = (ServiceDescription)obj;
        SCTE130Utils dUtils = SCTE130Utils.getInstance();
        if (!SCTE130Utils.listsEqual(this.getServices(), other.getServices())) {
            dUtils.devLog("ServiceDescription equality check failed. Service ites don't match.");
            return false;
        }
        if (!SCTE130Utils.objectsEqual(this.getSystemContext(), other.getSystemContext())) {
            dUtils.devLog("ServiceDescription equality check failed. SystemContexts don't match.");
            return false;
        }
        if (!SCTE130Utils.objectsEqual(this.getExt(), other.getExt())) {
            dUtils.devLog("ServiceDescription equality check failed. Exts don't match.");
            return false;
        }
        return true;
    }

    @Override
    public SOAPElement getSOAPElement() throws SOAPException {
        SCTE130Namespaces nameSpaces = SCTE130Namespaces.getInstance();
        SOAPFactory factory = SOAPFactory.newInstance();
        SOAPElement registrationRequest = factory.createElement(ELE_SERVICE_DESCRIPTION, "adm", nameSpaces.getURIForName("adm"));
        nameSpaces.populateNamespace(registrationRequest, "adm");
        SCTE130Utils.addOtherAttributes(registrationRequest, this.anyAttributes);
        SCTE130Utils.addChildElement(registrationRequest, this.getSystemContext());
        SCTE130Utils.addChildElementList(registrationRequest, this.getServices());
        SCTE130Utils.addChildElement(registrationRequest, this.getExt());
        return registrationRequest;
    }

    public void addAnyAttribute(String attributeName, String attributeValue) {
        this.anyAttributes.put(attributeName, attributeValue);
    }

    public Ext getExt() {
        return this.ext;
    }

    public void setExt(Ext ext) {
        this.ext = ext;
    }

    public List<Service> getServices() {
        return this.services;
    }

    public void setServices(List<Service> services) {
        this.services = services;
    }

    public SystemContext getSystemContext() {
        return this.systemContext;
    }

    public void setSystemContext(SystemContext systemContext) {
        this.systemContext = systemContext;
    }
}

