/*
 * Decompiled with CFR 0.152.
 */
package com.ttv.SCTE130.messages.adm;

import com.ttv.SCTE130.SCTE130MessageFactory;
import com.ttv.SCTE130.SCTE130MessageFactoryLocator;
import com.ttv.SCTE130.SCTE130Namespaces;
import com.ttv.SCTE130.messages.MessageInterface;
import com.ttv.SCTE130.messages.adm.Channel;
import com.ttv.SCTE130.messages.adm.Network;
import com.ttv.SCTE130.messages.adm.ServiceGroup;
import com.ttv.SCTE130.messages.adm.Session;
import com.ttv.SCTE130.messages.adm.Zone;
import com.ttv.SCTE130.messages.core.Ext;
import com.ttv.SCTE130.utils.SCTE130Utils;
import java.util.TreeMap;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SystemContext
implements MessageInterface {
    private TreeMap<String, String> anyAttributes = new TreeMap();
    private String[] namedAttributes = new String[0];
    private ServiceGroup serviceGroup = null;
    private Network network = null;
    private Channel channel = null;
    private Zone zone = null;
    private Session session = null;
    private Ext ext = null;
    public static final String ELE_SYSTEM_CONTEXT = "SystemContext";

    public SystemContext(Element element) throws Exception {
        this.anyAttributes = SCTE130Utils.locateOtherAttributes(this.namedAttributes, element.getAttributes());
        NodeList list = element.getChildNodes();
        for (int indx = 0; indx < list.getLength(); ++indx) {
            Node node = list.item(indx);
            if (!(node instanceof Element)) continue;
            Element child = (Element)node;
            SCTE130MessageFactory factory = SCTE130MessageFactoryLocator.getMessageFactory(child);
            Object obj = factory.allocateSCTE130Message(child);
            if (obj instanceof ServiceGroup) {
                this.serviceGroup = (ServiceGroup)obj;
            }
            if (obj instanceof Session) {
                this.session = (Session)obj;
            }
            if (obj instanceof Zone) {
                this.zone = (Zone)obj;
            }
            if (obj instanceof Channel) {
                this.channel = (Channel)obj;
            }
            if (obj instanceof Network) {
                this.network = (Network)obj;
            }
            if (!(obj instanceof Ext)) continue;
            this.ext = (Ext)obj;
        }
    }

    public SystemContext() {
    }

    public SystemContext(ServiceGroup serviceGroup, Network network, Channel channel, Zone zone, Session session, Ext ext) {
        this.serviceGroup = serviceGroup;
        this.network = network;
        this.session = session;
        this.channel = channel;
        this.zone = zone;
        this.ext = ext;
    }

    public boolean equals(MessageInterface obj) {
        SystemContext other = (SystemContext)obj;
        SCTE130Utils dUtils = SCTE130Utils.getInstance();
        if (!SCTE130Utils.objectsEqual(this.getServiceGroup(), other.getServiceGroup())) {
            dUtils.devLog("SystemContext equality check failed. ServiceGroups don't match.");
            return false;
        }
        if (!SCTE130Utils.objectsEqual(this.getSession(), other.getSession())) {
            dUtils.devLog("SystemContext equality check failed. Sessions don't match.");
            return false;
        }
        if (!SCTE130Utils.objectsEqual(this.getZone(), other.getZone())) {
            dUtils.devLog("SystemContext equality check failed. Zones don't match.");
            return false;
        }
        if (!SCTE130Utils.objectsEqual(this.getChannel(), other.getChannel())) {
            dUtils.devLog("SystemContext equality check failed. Channels don't match.");
            return false;
        }
        if (!SCTE130Utils.objectsEqual(this.getNetwork(), other.getNetwork())) {
            dUtils.devLog("SystemContext equality check failed. Networks don't match.");
            return false;
        }
        if (!SCTE130Utils.objectsEqual(this.getExt(), other.getExt())) {
            dUtils.devLog("SystemContext equality check failed. Exts don't match.");
            return false;
        }
        return true;
    }

    public SOAPElement getSOAPElement() throws SOAPException {
        SCTE130Namespaces nameSpaces = SCTE130Namespaces.getInstance();
        SOAPFactory factory = SOAPFactory.newInstance();
        SOAPElement systemContext = factory.createElement(ELE_SYSTEM_CONTEXT, "adm", nameSpaces.getURIForName("adm"));
        nameSpaces.populateNamespace(systemContext, "adm");
        SCTE130Utils.addOtherAttributes(systemContext, this.anyAttributes);
        SCTE130Utils.addChildElement(systemContext, this.getServiceGroup());
        SCTE130Utils.addChildElement(systemContext, this.getNetwork());
        SCTE130Utils.addChildElement(systemContext, this.getChannel());
        SCTE130Utils.addChildElement(systemContext, this.getZone());
        SCTE130Utils.addChildElement(systemContext, this.getSession());
        SCTE130Utils.addChildElement(systemContext, this.getExt());
        return systemContext;
    }

    public void addAnyAttribute(String attributeName, String attributeValue) {
        this.anyAttributes.put(attributeName, attributeValue);
    }

    public Channel getChannel() {
        return this.channel;
    }

    public void setChannel(Channel channel) {
        this.channel = channel;
    }

    public Ext getExt() {
        return this.ext;
    }

    public void setExt(Ext ext) {
        this.ext = ext;
    }

    public Network getNetwork() {
        return this.network;
    }

    public void setNetwork(Network network) {
        this.network = network;
    }

    public ServiceGroup getServiceGroup() {
        return this.serviceGroup;
    }

    public Session getSession() {
        return this.session;
    }

    public Zone getZone() {
        return this.zone;
    }

    public void setServiceGroup(ServiceGroup serviceGroup) {
        this.serviceGroup = serviceGroup;
    }

    public void setSession(Session session) {
        this.session = session;
    }

    public void setZone(Zone zone) {
        this.zone = zone;
    }
}

