/*
 * Decompiled with CFR 0.152.
 */
package com.ttv.SCTE130.messages.adm;

import com.ttv.SCTE130.SCTE130Namespaces;
import com.ttv.SCTE130.messages.MessageInterface;
import com.ttv.SCTE130.utils.SCTE130Utils;
import java.util.TreeMap;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class TerminalAddress
implements MessageInterface {
    private String address = null;
    private String type = null;
    private TreeMap<String, String> anyAttributes = new TreeMap();
    public static final String ELE_TERMINAL_ADDRESS = "TerminalAddress";
    public static final String TERMINAL_TYPE_MAC = "MAC";
    public static final String TERMINAL_TYPE_IPV4 = "IPv4";
    public static final String TERMINAL_TYPE_IPV6 = "IPv6";
    private static final String ATTR_TYPE = "type";
    private String[] namedAttributes = new String[]{"type"};

    public TerminalAddress(Element element) {
        this.type = element.getAttribute(ATTR_TYPE);
        this.anyAttributes = SCTE130Utils.locateOtherAttributes(this.namedAttributes, element.getAttributes());
        NodeList list = element.getChildNodes();
        for (int indx = 0; indx < list.getLength(); ++indx) {
            Node node = list.item(indx);
            if (!(node instanceof Text)) continue;
            this.address = ((Text)node).getData();
        }
    }

    public TerminalAddress() {
    }

    public TerminalAddress(String address, String type) {
        this.address = address;
        this.type = type;
    }

    public boolean equals(MessageInterface obj) {
        TerminalAddress other = (TerminalAddress)obj;
        SCTE130Utils dUtils = SCTE130Utils.getInstance();
        if (!SCTE130Utils.stringsEqual(other.getAddress(), this.getAddress())) {
            dUtils.devLog("TerminalAddress equality check failed. Addresses don't match.");
            return false;
        }
        if (!SCTE130Utils.stringsEqual(other.getType(), this.getType())) {
            dUtils.devLog("TerminalAddress equality check failed. Types don't match.");
            return false;
        }
        return true;
    }

    public SOAPElement getSOAPElement() throws SOAPException {
        SCTE130Namespaces nameSpaces = SCTE130Namespaces.getInstance();
        SOAPFactory factory = SOAPFactory.newInstance();
        SOAPElement addr = factory.createElement(ELE_TERMINAL_ADDRESS, "adm", nameSpaces.getURIForName("adm"));
        nameSpaces.populateNamespace(addr, "adm");
        SCTE130Utils.addOtherAttributes(addr, this.anyAttributes);
        addr.addTextNode(this.getAddress());
        addr.setAttribute(ATTR_TYPE, this.getType());
        return addr;
    }

    public void addAnyAttribute(String attributeName, String attributeValue) {
        this.anyAttributes.put(attributeName, attributeValue);
    }

    public String getAddress() {
        return this.address;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setAddress(String address) {
        this.address = address;
    }
}

