/*
 * Decompiled with CFR 0.152.
 */
package com.ttv.SCTE130.messages.adm;

import com.ttv.SCTE130.SCTE130Namespaces;
import com.ttv.SCTE130.messages.MessageInterface;
import com.ttv.SCTE130.utils.DateUtils;
import com.ttv.SCTE130.utils.SCTE130Utils;
import java.util.Date;
import java.util.TreeMap;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import org.w3c.dom.Element;

public class Window
implements MessageInterface {
    private Date start = null;
    private Date end = null;
    private TreeMap<String, String> anyAttributes = new TreeMap();
    public static final String ELE_WINDOW = "Window";
    private static final String ATTR_START = "start";
    private static final String ATTR_END = "end";
    private String[] namedAttributes = new String[]{"start", "end"};

    public Window(Element element) {
        String remoteStart = element.getAttribute(ATTR_START);
        String remoteEnd = element.getAttribute(ATTR_END);
        if (remoteStart != null && remoteStart.length() > 0) {
            try {
                this.start = DateUtils.parseXSDDateTime(remoteStart);
            }
            catch (Exception e) {
                SCTE130Utils.getInstance().devLog("Failed to parse StartTime in Window.");
            }
        }
        if (remoteEnd != null && remoteEnd.length() > 0) {
            try {
                this.end = DateUtils.parseXSDDateTime(remoteEnd);
            }
            catch (Exception e) {
                SCTE130Utils.getInstance().devLog("Failed to parse EndTime in Window.");
            }
        }
        this.anyAttributes = SCTE130Utils.locateOtherAttributes(this.namedAttributes, element.getAttributes());
    }

    public Window() {
    }

    public Window(Date start, Date end) {
        this.start = start;
        this.end = end;
    }

    public boolean equals(MessageInterface obj) {
        Window other = (Window)obj;
        SCTE130Utils dUtils = SCTE130Utils.getInstance();
        if (this.getStart().compareTo(other.getStart()) != 0) {
            dUtils.devLog("Window equality check failed. StartTimes don't match.");
            return false;
        }
        if (this.getEnd().compareTo(other.getEnd()) != 0) {
            dUtils.devLog("Window equality check failed. EndTimes don't match.");
            return false;
        }
        return true;
    }

    public SOAPElement getSOAPElement() throws SOAPException {
        SCTE130Namespaces nameSpaces = SCTE130Namespaces.getInstance();
        SOAPFactory factory = SOAPFactory.newInstance();
        SOAPElement win = factory.createElement(ELE_WINDOW, "adm", nameSpaces.getURIForName("adm"));
        nameSpaces.populateNamespace(win, "adm");
        SCTE130Utils.addOtherAttributes(win, this.anyAttributes);
        SCTE130Utils.setAttribute(win, ATTR_START, this.getStartAsStr());
        SCTE130Utils.setAttribute(win, ATTR_END, this.getEndAsStr());
        return win;
    }

    public void addAnyAttribute(String attributeName, String attributeValue) {
        this.anyAttributes.put(attributeName, attributeValue);
    }

    public Date getEnd() {
        return this.end;
    }

    public String getEndAsStr() {
        return DateUtils.formatXSDDateTime(this.end);
    }

    public void setEnd(Date end) {
        this.end = end;
    }

    public Date getStart() {
        return this.start;
    }

    public String getStartAsStr() {
        return DateUtils.formatXSDDateTime(this.start);
    }

    public void setStart(Date start) {
        this.start = start;
    }
}

