/*
 * Decompiled with CFR 0.152.
 */
package com.ttv.SCTE130.messages.cis;

import com.ttv.SCTE130.SCTE130Namespaces;
import com.ttv.SCTE130.messages.MessageInterface;
import com.ttv.SCTE130.utils.SCTE130Utils;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import org.jboss.util.xml.DOMUtils;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class AdvancedFilterElement
implements MessageInterface {
    private String queryId = null;
    private String ql = null;
    private String query = null;
    public static final String ELE_ADVANCED_FILTER_ELEMENT = "AdvancedFilterElement";
    private static final String ATTR_QUERY_ID = "queryId";
    private static final String ATTR_QL = "ql";

    public AdvancedFilterElement(Element element) throws Exception {
        String remoteQL = element.getAttribute(ATTR_QL);
        if (remoteQL != null && remoteQL.length() > 0) {
            this.ql = remoteQL;
        }
        this.queryId = element.getAttribute(ATTR_QUERY_ID);
        NodeList list = element.getChildNodes();
        for (int indx = 0; indx < list.getLength(); ++indx) {
            Node node = list.item(indx);
            if (!(node instanceof Text)) continue;
            this.query = ((Text)node).getData();
        }
    }

    public AdvancedFilterElement() {
    }

    public AdvancedFilterElement(String queryId, String ql, String query) {
        this.queryId = queryId;
        this.ql = ql;
        this.query = query;
    }

    public boolean equals(MessageInterface obj) {
        AdvancedFilterElement other = (AdvancedFilterElement)obj;
        SCTE130Utils dUtils = SCTE130Utils.getInstance();
        if (!SCTE130Utils.stringsEqual(this.getQueryId(), other.getQueryId())) {
            dUtils.devLog("AdvancedFilterElement equality check failed. Query Ids don't match.");
            return false;
        }
        if (!SCTE130Utils.stringsEqual(this.getQl(), other.getQl())) {
            dUtils.devLog("AdvancedFilterElement equality check failed. QLs don't match.");
            return false;
        }
        if (!SCTE130Utils.stringsEqual(this.getQuery(), other.getQuery())) {
            dUtils.devLog("AdvancedFilterElement equality check failed. Querys don't match.");
            return false;
        }
        return true;
    }

    public SOAPElement getSOAPElement() throws SOAPException {
        SCTE130Namespaces nameSpaces = SCTE130Namespaces.getInstance();
        SOAPFactory factory = SOAPFactory.newInstance();
        Document doc = DOMUtils.getOwnerDocument();
        SOAPElement contentSelector = factory.createElement(ELE_ADVANCED_FILTER_ELEMENT, "cis", nameSpaces.getURIForName("cis"));
        nameSpaces.populateNamespace(contentSelector, "cis");
        CDATASection cdata = doc.createCDATASection(this.getQuery());
        contentSelector.setAttribute(ATTR_QUERY_ID, this.getQueryId());
        contentSelector.setAttribute(ATTR_QL, this.getQl());
        contentSelector.appendChild((Node)cdata);
        return contentSelector;
    }

    public String getQueryId() {
        return this.queryId;
    }

    public void setQueryId(String queryId) {
        this.queryId = queryId;
    }

    public String getQl() {
        return this.ql;
    }

    public String getQuery() {
        return this.query;
    }

    public void setQl(String ql) {
        this.ql = ql;
    }

    public void setQuery(String query) {
        this.query = query;
    }
}

