/*
 * Decompiled with CFR 0.152.
 */
package com.ttv.SCTE130.messages.cis;

import com.ttv.SCTE130.SCTE130Namespaces;
import com.ttv.SCTE130.messages.MessageInterface;
import com.ttv.SCTE130.utils.SCTE130Utils;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import org.jboss.util.xml.DOMUtils;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class AdvancedQueryResult
implements MessageInterface {
    private String queryRef = null;
    private boolean mediaAvailable = false;
    private String result = null;
    public static final String ELE_ADVANCED_QUERY_RESULT = "AdvancedQueryResult";
    private static final String ATTR_QUERY_REF = "queryRef";
    private static final String ATTR_MEDIA_AVAILABLE = "mediaAvailable";

    public AdvancedQueryResult(Element element) throws Exception {
        this.queryRef = element.getAttribute(ATTR_QUERY_REF);
        String remoteMediaAvailable = element.getAttribute(ATTR_MEDIA_AVAILABLE);
        if (remoteMediaAvailable != null && remoteMediaAvailable.length() > 0) {
            this.mediaAvailable = Boolean.parseBoolean(remoteMediaAvailable);
        }
        NodeList list = element.getChildNodes();
        for (int indx = 0; indx < list.getLength(); ++indx) {
            Node node = list.item(indx);
            if (!(node instanceof Text)) continue;
            this.result = ((Text)node).getData();
        }
    }

    public AdvancedQueryResult() {
    }

    public AdvancedQueryResult(String queryRef, boolean mediaAvailable, String result) {
        this.queryRef = queryRef;
        this.mediaAvailable = mediaAvailable;
        this.result = result;
    }

    public boolean equals(Object other) {
        if (other instanceof MessageInterface) {
            return this.equals((MessageInterface)other);
        }
        return false;
    }

    public boolean equals(MessageInterface obj) {
        AdvancedQueryResult other = (AdvancedQueryResult)obj;
        SCTE130Utils dUtils = SCTE130Utils.getInstance();
        if (!SCTE130Utils.stringsEqual(this.getQueryRef(), other.getQueryRef())) {
            dUtils.devLog("AdvancedQueryResult equality check failed. Query Refs don't match.");
            return false;
        }
        if (this.isMediaAvailable() != other.isMediaAvailable()) {
            dUtils.devLog("AdvancedQueryResult equality check failed. MediaAvailable flags don't match.");
            return false;
        }
        if (!SCTE130Utils.stringsEqual(this.getResult(), other.getResult())) {
            dUtils.devLog("AdvancedQueryResult equality check failed. Results don't match.");
            return false;
        }
        return true;
    }

    public SOAPElement getSOAPElement() throws SOAPException {
        SCTE130Namespaces nameSpaces = SCTE130Namespaces.getInstance();
        SOAPFactory factory = SOAPFactory.newInstance();
        Document doc = DOMUtils.getOwnerDocument();
        SOAPElement queryresult = factory.createElement(ELE_ADVANCED_QUERY_RESULT, "cis", nameSpaces.getURIForName("cis"));
        nameSpaces.populateNamespace(queryresult, "cis");
        CDATASection cdata = doc.createCDATASection(this.getResult());
        queryresult.setAttribute(ATTR_QUERY_REF, this.getQueryRef());
        queryresult.setAttribute(ATTR_MEDIA_AVAILABLE, Boolean.toString(this.isMediaAvailable()));
        queryresult.appendChild((Node)cdata);
        return queryresult;
    }

    public boolean isMediaAvailable() {
        return this.mediaAvailable;
    }

    public void setMediaAvailable(boolean mediaAvailable) {
        this.mediaAvailable = mediaAvailable;
    }

    public String getQueryRef() {
        return this.queryRef;
    }

    public void setQueryRef(String queryRef) {
        this.queryRef = queryRef;
    }

    public String getResult() {
        return this.result;
    }

    public void setResult(String result) {
        this.result = result;
    }
}

