/*
 * Decompiled with CFR 0.152.
 */
package com.ttv.SCTE130.messages.cis;

import com.ttv.SCTE130.SCTE130MessageFactory;
import com.ttv.SCTE130.SCTE130MessageFactoryLocator;
import com.ttv.SCTE130.SCTE130Namespaces;
import com.ttv.SCTE130.messages.MessageInterface;
import com.ttv.SCTE130.messages.TopLevelMessage;
import com.ttv.SCTE130.messages.cis.ContentNotificationSelector;
import com.ttv.SCTE130.messages.core.Callout;
import com.ttv.SCTE130.messages.core.Ext;
import com.ttv.SCTE130.messages.core.InitiatorData;
import com.ttv.SCTE130.utils.SCTE130Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContentNotificationRegistrationRequest
implements MessageInterface,
TopLevelMessage {
    private String messageId = null;
    private String version = "1.0";
    private String identity = null;
    private String system = null;
    private String resend = null;
    private TreeMap<String, String> anyAttributes = new TreeMap();
    private InitiatorData initData = null;
    private List<Callout> callouts = null;
    private ContentNotificationSelector selector = null;
    private Ext ext = null;
    public static final String ELE_CONTENT_NOTIFICATION_REGISTRATION_REQUEST = "ContentNotificationRegistrationRequest";
    private static final String ATTR_MESSAGE_ID = "messageId";
    private static final String ATTR_VERSION = "version";
    private static final String ATTR_SYSTEM = "system";
    private static final String ATTR_RESEND = "resend";
    private static final String ATTR_IDENTITY = "identity";
    private String[] namedAttributes = new String[]{"messageId", "version", "identity", "system", "resend"};

    public ContentNotificationRegistrationRequest(Element element) throws Exception {
        this.messageId = element.getAttribute(ATTR_MESSAGE_ID);
        this.system = element.getAttribute(ATTR_SYSTEM);
        this.resend = element.getAttribute(ATTR_RESEND);
        this.identity = element.getAttribute(ATTR_IDENTITY);
        this.anyAttributes = SCTE130Utils.locateOtherAttributes(this.namedAttributes, element.getAttributes());
        NodeList list = element.getChildNodes();
        for (int indx = 0; indx < list.getLength(); ++indx) {
            Node node = list.item(indx);
            if (!(node instanceof Element)) continue;
            Element child = (Element)node;
            SCTE130MessageFactory factory = SCTE130MessageFactoryLocator.getMessageFactory(child);
            Object obj = factory.allocateSCTE130Message(child);
            if (obj instanceof InitiatorData) {
                this.initData = (InitiatorData)obj;
            }
            if (obj instanceof Callout) {
                if (this.callouts == null) {
                    this.callouts = new ArrayList<Callout>();
                }
                this.callouts.add((Callout)obj);
            }
            if (obj instanceof ContentNotificationSelector) {
                this.selector = (ContentNotificationSelector)obj;
            }
            if (!(obj instanceof Ext)) continue;
            this.ext = (Ext)obj;
        }
    }

    public ContentNotificationRegistrationRequest() {
    }

    public ContentNotificationRegistrationRequest(String messageId, String system, String identity, List<Callout> callouts, ContentNotificationSelector selector, Ext ext) {
        this.messageId = messageId;
        this.system = system;
        this.identity = identity;
        this.callouts = callouts;
        this.selector = selector;
        this.ext = ext;
    }

    @Override
    public boolean equals(MessageInterface obj) {
        ContentNotificationRegistrationRequest other = (ContentNotificationRegistrationRequest)obj;
        SCTE130Utils dUtils = SCTE130Utils.getInstance();
        if (!SCTE130Utils.stringsEqual(this.getMessageId(), other.getMessageId())) {
            dUtils.devLog("ContentNotificationRegistrationRequest equality check failed. MessageIds don't match.");
            return false;
        }
        if (!SCTE130Utils.stringsEqual(this.getSystem(), other.getSystem())) {
            dUtils.devLog("ContentNotificationRegistrationRequest equality check failed. Systems don't match.");
            return false;
        }
        if (!SCTE130Utils.stringsEqual(this.getResend(), other.getResend())) {
            dUtils.devLog("ContentNotificationRegistrationRequest equality check failed. Resends don't match.");
            return false;
        }
        if (!SCTE130Utils.stringsEqual(this.getIdentity(), other.getIdentity())) {
            dUtils.devLog("ContentNotificationRegistrationRequest equality check failed. Identities don't match.");
            return false;
        }
        if (!SCTE130Utils.listsEqual(this.getCallouts(), other.getCallouts())) {
            dUtils.devLog("ContentNotificationRegistrationRequest equality check failed. Callouts don't match.");
            return false;
        }
        if (!SCTE130Utils.objectsEqual(this.getInitData(), other.getInitData())) {
            dUtils.devLog("ContentNotificationRegistrationRequest equality check failed. InitiatorData don't match.");
            return false;
        }
        if (!SCTE130Utils.objectsEqual(this.getSelector(), other.getSelector())) {
            dUtils.devLog("ContentNotificationRegistrationRequest equality check failed. ContentSelectors don't match.");
            return false;
        }
        if (!SCTE130Utils.objectsEqual(this.getExt(), other.getExt())) {
            dUtils.devLog("ContentNotificationRegistrationRequest equality check failed. Exts don't match.");
            return false;
        }
        return true;
    }

    @Override
    public SOAPElement getSOAPElement() throws SOAPException {
        SCTE130Namespaces nameSpaces = SCTE130Namespaces.getInstance();
        SOAPFactory factory = SOAPFactory.newInstance();
        SOAPElement registrationRequest = factory.createElement(ELE_CONTENT_NOTIFICATION_REGISTRATION_REQUEST, "cis", nameSpaces.getURIForName("cis"));
        nameSpaces.populateNamespace(registrationRequest, "cis");
        SCTE130Utils.setAttribute(registrationRequest, ATTR_MESSAGE_ID, this.getMessageId());
        SCTE130Utils.setAttribute(registrationRequest, ATTR_VERSION, this.getVersion());
        SCTE130Utils.setAttribute(registrationRequest, ATTR_IDENTITY, this.getIdentity());
        SCTE130Utils.setAttribute(registrationRequest, ATTR_SYSTEM, this.getSystem());
        SCTE130Utils.setAttribute(registrationRequest, ATTR_RESEND, this.getResend());
        SCTE130Utils.addOtherAttributes(registrationRequest, this.anyAttributes);
        SCTE130Utils.addChildElement(registrationRequest, this.getInitData());
        SCTE130Utils.addChildElementList(registrationRequest, this.getCallouts());
        SCTE130Utils.addChildElement(registrationRequest, this.getSelector());
        SCTE130Utils.addChildElement(registrationRequest, this.getExt());
        return registrationRequest;
    }

    public void addAnyAttribute(String attributeName, String attributeValue) {
        this.anyAttributes.put(attributeName, attributeValue);
    }

    @Override
    public InitiatorData getInitData() {
        return this.initData;
    }

    public void setInitData(InitiatorData initData) {
        this.initData = initData;
    }

    public String getResend() {
        return this.resend;
    }

    public void setResend(String resend) {
        this.resend = resend;
    }

    public Ext getExt() {
        return this.ext;
    }

    public void setExt(Ext ext) {
        this.ext = ext;
    }

    public List<Callout> getCallouts() {
        return this.callouts;
    }

    public void setCallouts(List<Callout> callouts) {
        this.callouts = callouts;
    }

    public String getIdentity() {
        return this.identity;
    }

    public void setIdentity(String identity) {
        this.identity = identity;
    }

    @Override
    public String getMessageId() {
        return this.messageId;
    }

    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    public ContentNotificationSelector getSelector() {
        return this.selector;
    }

    public void setSelector(ContentNotificationSelector selector) {
        this.selector = selector;
    }

    public String getSystem() {
        return this.system;
    }

    public void setSystem(String system) {
        this.system = system;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }
}

