/*
 * Decompiled with CFR 0.152.
 */
package com.ttv.SCTE130.messages.cis;

import com.ttv.SCTE130.SCTE130MessageFactory;
import com.ttv.SCTE130.SCTE130MessageFactoryLocator;
import com.ttv.SCTE130.SCTE130Namespaces;
import com.ttv.SCTE130.messages.MessageInterface;
import com.ttv.SCTE130.messages.cis.QueryFilter;
import com.ttv.SCTE130.messages.core.ContentDataModel;
import com.ttv.SCTE130.utils.SCTE130Utils;
import java.util.ArrayList;
import java.util.List;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContentQuery
implements MessageInterface {
    private String contentQueryId = null;
    private boolean expandOutput = false;
    private ContentDataModel dataModel = null;
    private List<QueryFilter> queryFilters = null;
    public static final String ELE_CONTENT_QUERY = "ContentQuery";
    private static final String ATTR_CONTENT_QUERY_ID = "contentQueryId";
    private static final String ATTR_EXPAND_OUTPUT = "expandOutput";

    public ContentQuery(Element element) throws Exception {
        String remoteExpandOutput = element.getAttribute(ATTR_EXPAND_OUTPUT);
        if (remoteExpandOutput != null && remoteExpandOutput.length() > 0) {
            this.expandOutput = Boolean.parseBoolean(remoteExpandOutput);
        }
        this.contentQueryId = element.getAttribute(ATTR_CONTENT_QUERY_ID);
        NodeList list = element.getChildNodes();
        for (int indx = 0; indx < list.getLength(); ++indx) {
            Node node = list.item(indx);
            if (!(node instanceof Element)) continue;
            Element child = (Element)node;
            SCTE130MessageFactory factory = SCTE130MessageFactoryLocator.getMessageFactory(child);
            Object obj = factory.allocateSCTE130Message(child);
            if (obj instanceof QueryFilter) {
                if (this.queryFilters == null) {
                    this.queryFilters = new ArrayList<QueryFilter>();
                }
                this.queryFilters.add((QueryFilter)obj);
            }
            if (!(obj instanceof ContentDataModel)) continue;
            this.dataModel = (ContentDataModel)obj;
        }
    }

    public ContentQuery() {
    }

    public ContentQuery(String contentQueryId, ContentDataModel dataModel, boolean expandOutput, List<QueryFilter> filters) {
        this.contentQueryId = contentQueryId;
        this.dataModel = dataModel;
        this.expandOutput = expandOutput;
        this.queryFilters = filters;
    }

    @Override
    public boolean equals(MessageInterface obj) {
        ContentQuery other = (ContentQuery)obj;
        SCTE130Utils dUtils = SCTE130Utils.getInstance();
        if (!SCTE130Utils.stringsEqual(this.getContentQueryId(), other.getContentQueryId())) {
            dUtils.devLog("ContentQuery equality check failed. ContentQueryIds don't match.");
            return false;
        }
        if (!SCTE130Utils.objectsEqual(this.getContentDataModel(), other.getContentDataModel())) {
            dUtils.devLog("ContentQuery equality check failed. ContentDataModels don't match.");
            return false;
        }
        if (this.getExpandOutput() != other.getExpandOutput()) {
            dUtils.devLog("ContentQuery equality check failed. ExpandOutput flags don't match.");
            return false;
        }
        if (!SCTE130Utils.listsEqual(this.getQueryFilters(), other.getQueryFilters())) {
            dUtils.devLog("ContentQuery equality check failed. QueryFilters don't match.");
            return false;
        }
        return true;
    }

    @Override
    public SOAPElement getSOAPElement() throws SOAPException {
        SCTE130Namespaces nameSpaces = SCTE130Namespaces.getInstance();
        SOAPFactory factory = SOAPFactory.newInstance();
        SOAPElement contentQuery = factory.createElement(ELE_CONTENT_QUERY, "cis", nameSpaces.getURIForName("cis"));
        nameSpaces.populateNamespace(contentQuery, "cis");
        contentQuery.setAttribute(ATTR_CONTENT_QUERY_ID, this.getContentQueryId());
        contentQuery.setAttribute(ATTR_EXPAND_OUTPUT, this.getExpandOutputStr());
        SCTE130Utils.addChildElement(contentQuery, this.getContentDataModel());
        SCTE130Utils.addChildElementList(contentQuery, this.getQueryFilters());
        return contentQuery;
    }

    public String getContentQueryId() {
        return this.contentQueryId;
    }

    public void setContentQueryId(String contentQueryId) {
        this.contentQueryId = contentQueryId;
    }

    public List<QueryFilter> getQueryFilters() {
        return this.queryFilters;
    }

    public ContentDataModel getContentDataModel() {
        return this.dataModel;
    }

    public boolean getExpandOutput() {
        return this.expandOutput;
    }

    public String getExpandOutputStr() {
        return this.expandOutput ? "true" : "false";
    }

    public void setContentDataModel(ContentDataModel dataModel) {
        this.dataModel = dataModel;
    }

    public void setExpandOutput(boolean expandOutput) {
        this.expandOutput = expandOutput;
    }

    public void setQueryFilters(List<QueryFilter> queryFilters) {
        this.queryFilters = queryFilters;
    }
}

