/*
 * Decompiled with CFR 0.152.
 */
package com.ttv.SCTE130.messages.cis;

import com.ttv.SCTE130.SCTE130MessageFactory;
import com.ttv.SCTE130.SCTE130MessageFactoryLocator;
import com.ttv.SCTE130.SCTE130Namespaces;
import com.ttv.SCTE130.messages.MessageInterface;
import com.ttv.SCTE130.messages.cis.AdvancedQueryResultList;
import com.ttv.SCTE130.messages.cis.BasicQueryResultList;
import com.ttv.SCTE130.utils.SCTE130Utils;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ContentQueryResult
implements MessageInterface {
    private int resultSetSize;
    private String contentQueryRef = null;
    private BasicQueryResultList basicQueryResultList = null;
    private AdvancedQueryResultList advancedQueryResultList = null;
    public static final String ELE_CONTENT_QUERY_RESULT = "ContentQueryResult";
    private static final String ATTR_QUERY_ID = "contentQueryRef";
    private static final String ATTR_RESULT_SET_SIZE = "resultSetSize";

    public ContentQueryResult(Element element) throws Exception {
        String remoteResultSetSize = element.getAttribute(ATTR_RESULT_SET_SIZE);
        if (remoteResultSetSize != null && remoteResultSetSize.length() > 0) {
            this.resultSetSize = Integer.parseInt(remoteResultSetSize);
        }
        this.contentQueryRef = element.getAttribute(ATTR_QUERY_ID);
        NodeList list = element.getChildNodes();
        for (int indx = 0; indx < list.getLength(); ++indx) {
            Node node = list.item(indx);
            if (!(node instanceof Element)) continue;
            Element child = (Element)node;
            SCTE130MessageFactory factory = SCTE130MessageFactoryLocator.getMessageFactory(child);
            Object obj = factory.allocateSCTE130Message(child);
            if (obj instanceof BasicQueryResultList) {
                this.basicQueryResultList = (BasicQueryResultList)obj;
            }
            if (!(obj instanceof AdvancedQueryResultList)) continue;
            this.advancedQueryResultList = (AdvancedQueryResultList)obj;
        }
    }

    public ContentQueryResult() {
    }

    public ContentQueryResult(String contentQueryRef, int resultSetSize, BasicQueryResultList basicQueryResultList) {
        this.contentQueryRef = contentQueryRef;
        this.resultSetSize = resultSetSize;
        this.basicQueryResultList = basicQueryResultList;
    }

    public ContentQueryResult(String contentQueryRef, int resultSetSize, AdvancedQueryResultList advancedQueryResultList) {
        this.contentQueryRef = contentQueryRef;
        this.resultSetSize = resultSetSize;
        this.advancedQueryResultList = advancedQueryResultList;
    }

    public boolean equals(MessageInterface obj) {
        ContentQueryResult other = (ContentQueryResult)obj;
        SCTE130Utils dUtils = SCTE130Utils.getInstance();
        if (this.getResultSetSize() != other.getResultSetSize()) {
            dUtils.devLog("ContentQueryResult equality check failed. ResultSetSizes don't match.");
            return false;
        }
        if (!SCTE130Utils.stringsEqual(this.getContentQueryRef(), other.getContentQueryRef())) {
            dUtils.devLog("ContentQueryResult equality check failed. ContentQuery Ids don't match.");
            return false;
        }
        if (!SCTE130Utils.objectsEqual(this.getBasicQueryResultList(), other.getBasicQueryResultList())) {
            dUtils.devLog("ContentQueryResult equality check failed. BasicQueryResults don't match.");
            return false;
        }
        if (!SCTE130Utils.objectsEqual(this.getAdvancedQueryResultList(), other.getAdvancedQueryResultList())) {
            dUtils.devLog("ContentQueryResult equality check failed. AdvancedQueryResultList don't match.");
            return false;
        }
        return true;
    }

    public SOAPElement getSOAPElement() throws SOAPException {
        SCTE130Namespaces nameSpaces = SCTE130Namespaces.getInstance();
        SOAPFactory factory = SOAPFactory.newInstance();
        SOAPElement contentQueryResult = factory.createElement(ELE_CONTENT_QUERY_RESULT, "cis", nameSpaces.getURIForName("cis"));
        nameSpaces.populateNamespace(contentQueryResult, "cis");
        contentQueryResult.setAttribute(ATTR_QUERY_ID, this.getContentQueryRef());
        contentQueryResult.setAttribute(ATTR_RESULT_SET_SIZE, this.getResultSetSizeAsStr());
        SCTE130Utils.addChildElement(contentQueryResult, this.getBasicQueryResultList());
        SCTE130Utils.addChildElement(contentQueryResult, this.getAdvancedQueryResultList());
        return contentQueryResult;
    }

    public String getContentQueryRef() {
        return this.contentQueryRef;
    }

    public void setContentQueryRef(String getContentQueryRef) {
        this.contentQueryRef = getContentQueryRef;
    }

    public int getResultSetSize() {
        return this.resultSetSize;
    }

    public String getResultSetSizeAsStr() {
        return "" + this.resultSetSize;
    }

    public BasicQueryResultList getBasicQueryResultList() {
        return this.basicQueryResultList;
    }

    public AdvancedQueryResultList getAdvancedQueryResultList() {
        return this.advancedQueryResultList;
    }

    public void setAdvancedQueryResultList(AdvancedQueryResultList advancedQueryResultList) {
        this.advancedQueryResultList = advancedQueryResultList;
    }

    public void setBasicQueryResultList(BasicQueryResultList basicQueryResultList) {
        this.basicQueryResultList = basicQueryResultList;
    }

    public void setResultSetSize(int resultSetSize) {
        this.resultSetSize = resultSetSize;
    }
}

