/*
 * Decompiled with CFR 0.152.
 */
package com.ttv.SCTE130.messages.cis;

import com.ttv.SCTE130.SCTE130MessageFactory;
import com.ttv.SCTE130.SCTE130MessageFactoryLocator;
import com.ttv.SCTE130.SCTE130Namespaces;
import com.ttv.SCTE130.messages.MessageInterface;
import com.ttv.SCTE130.messages.TopLevelMessage;
import com.ttv.SCTE130.messages.core.Ext;
import com.ttv.SCTE130.messages.core.InitiatorData;
import com.ttv.SCTE130.messages.core.StatusCode;
import com.ttv.SCTE130.utils.DateUtils;
import com.ttv.SCTE130.utils.SCTE130Utils;
import java.util.Date;
import java.util.TreeMap;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CreateCursorResponse
implements MessageInterface,
TopLevelMessage {
    private String messageId = null;
    private String version = "1.0";
    private String identity = null;
    private String system = null;
    private String messageRef = null;
    private int resultSetSize;
    private Date cursorExpires = null;
    private TreeMap<String, String> anyAttributes = new TreeMap();
    private InitiatorData initData = null;
    private StatusCode statusCode = null;
    private Ext ext = null;
    public static final String ELE_CREATE_CURSOR_RESPONSE = "CreateCursorResponse";
    private static final String ATTR_MESSAGE_ID = "messageId";
    private static final String ATTR_VERSION = "version";
    private static final String ATTR_IDENTITY = "identity";
    private static final String ATTR_SYSTEM = "system";
    private static final String ATTR_MESSAGE_REF = "messageRef";
    private static final String ATTR_CURSOR_EXPIRES = "cursorExpires";
    private static final String ATTR_RESULT_SET_SIZE = "resultSetSize";
    private String[] namedAttributes = new String[]{"messageId", "version", "identity", "system", "messageRef", "cursorExpires", "resultSetSize"};

    public CreateCursorResponse(Element element) throws Exception {
        this.messageId = element.getAttribute(ATTR_MESSAGE_ID);
        this.identity = element.getAttribute(ATTR_IDENTITY);
        this.system = element.getAttribute(ATTR_SYSTEM);
        this.messageRef = element.getAttribute(ATTR_MESSAGE_REF);
        String remoteCursorExpires = element.getAttribute(ATTR_CURSOR_EXPIRES);
        String remoteResultSetSize = element.getAttribute(ATTR_RESULT_SET_SIZE);
        if (remoteCursorExpires != null && remoteCursorExpires.length() > 0) {
            this.cursorExpires = DateUtils.parseXSDDateTime(remoteCursorExpires);
        }
        if (remoteResultSetSize != null && remoteResultSetSize.length() > 0) {
            this.resultSetSize = Integer.parseInt(remoteResultSetSize);
        }
        this.anyAttributes = SCTE130Utils.locateOtherAttributes(this.namedAttributes, element.getAttributes());
        NodeList list = element.getChildNodes();
        for (int indx = 0; indx < list.getLength(); ++indx) {
            Node node = list.item(indx);
            if (!(node instanceof Element)) continue;
            Element child = (Element)node;
            SCTE130MessageFactory factory = SCTE130MessageFactoryLocator.getMessageFactory(child);
            Object obj = factory.allocateSCTE130Message(child);
            if (obj instanceof InitiatorData) {
                this.initData = (InitiatorData)obj;
            }
            if (obj instanceof StatusCode) {
                this.statusCode = (StatusCode)obj;
            }
            if (!(obj instanceof Ext)) continue;
            this.ext = (Ext)obj;
        }
    }

    public CreateCursorResponse() {
    }

    public CreateCursorResponse(String messageId, String identity, String system, String messageRef, int resultSetSize, Date cursorExpires, StatusCode statusCode, Ext ext) {
        this.messageId = messageId;
        this.identity = identity;
        this.system = system;
        this.resultSetSize = resultSetSize;
        this.cursorExpires = cursorExpires;
        this.statusCode = statusCode;
        this.messageRef = messageRef;
        this.ext = ext;
    }

    public boolean equals(MessageInterface obj) {
        CreateCursorResponse other = (CreateCursorResponse)obj;
        SCTE130Utils dUtils = SCTE130Utils.getInstance();
        if (this.getResultSetSize() != other.getResultSetSize()) {
            dUtils.devLog("ContentQueryResponse equality check failed. ResultSetSizes don't match.");
            return false;
        }
        if (!SCTE130Utils.stringsEqual(this.getMessageId(), other.getMessageId())) {
            dUtils.devLog("ContentQueryResponse equality check failed. MessageIds don't match.");
            return false;
        }
        if (!SCTE130Utils.stringsEqual(this.getIdentity(), other.getIdentity())) {
            dUtils.devLog("ContentQueryResponse equality check failed. Identities don't match.");
            return false;
        }
        if (!SCTE130Utils.stringsEqual(this.getSystem(), other.getSystem())) {
            dUtils.devLog("ContentQueryResponse equality check failed. Systems don't match.");
            return false;
        }
        if (!SCTE130Utils.stringsEqual(this.getMessageRef(), other.getMessageRef())) {
            dUtils.devLog("ContentQueryResponse equality check failed. MessageRefs don't match.");
            return false;
        }
        if (!SCTE130Utils.objectsEqual(this.getInitData(), other.getInitData())) {
            dUtils.devLog("ContentQueryResponse equality check failed. InitiatorData don't match.");
            return false;
        }
        if (!SCTE130Utils.objectsEqual(this.getStatusCode(), other.getStatusCode())) {
            dUtils.devLog("ContentQueryResponse equality check failed. StatusCodes don't match.");
            return false;
        }
        if (this.getCursorExpires().compareTo(other.getCursorExpires()) != 0) {
            dUtils.devLog("ContentQueryResponse equality check failed. CursorExpires don't match.");
            return false;
        }
        if (!SCTE130Utils.objectsEqual(this.getExt(), other.getExt())) {
            dUtils.devLog("ContentQueryResponse equality check failed. Exts don't match.");
            return false;
        }
        return true;
    }

    public SOAPElement getSOAPElement() throws SOAPException {
        SCTE130Namespaces nameSpaces = SCTE130Namespaces.getInstance();
        SOAPFactory factory = SOAPFactory.newInstance();
        SOAPElement queryResponse = factory.createElement(ELE_CREATE_CURSOR_RESPONSE, "cis", nameSpaces.getURIForName("cis"));
        nameSpaces.populateNamespace(queryResponse, "cis");
        SCTE130Utils.setAttribute(queryResponse, ATTR_MESSAGE_ID, this.getMessageId());
        SCTE130Utils.setAttribute(queryResponse, ATTR_VERSION, this.getVersion());
        SCTE130Utils.setAttribute(queryResponse, ATTR_IDENTITY, this.getIdentity());
        SCTE130Utils.setAttribute(queryResponse, ATTR_SYSTEM, this.getSystem());
        SCTE130Utils.setAttribute(queryResponse, ATTR_MESSAGE_REF, this.getMessageRef());
        SCTE130Utils.setAttribute(queryResponse, ATTR_RESULT_SET_SIZE, this.getResultSetSizeAsStr());
        SCTE130Utils.setAttribute(queryResponse, ATTR_CURSOR_EXPIRES, this.getCursorExpiresAsStr());
        SCTE130Utils.addOtherAttributes(queryResponse, this.anyAttributes);
        SCTE130Utils.addChildElement(queryResponse, this.getInitData());
        SCTE130Utils.addChildElement(queryResponse, this.getStatusCode());
        SCTE130Utils.addChildElement(queryResponse, this.getExt());
        return queryResponse;
    }

    public void addAnyAttribute(String attributeName, String attributeValue) {
        this.anyAttributes.put(attributeName, attributeValue);
    }

    public InitiatorData getInitData() {
        return this.initData;
    }

    public void setInitData(InitiatorData initData) {
        this.initData = initData;
    }

    public String getIdentity() {
        return this.identity;
    }

    public void setIdentity(String identity) {
        this.identity = identity;
    }

    public int getResultSetSize() {
        return this.resultSetSize;
    }

    public String getResultSetSizeAsStr() {
        return "" + this.resultSetSize;
    }

    public void setResultSetSize(int resultSetSize) {
        this.resultSetSize = resultSetSize;
    }

    public Date getCursorExpires() {
        return this.cursorExpires;
    }

    public String getCursorExpiresAsStr() {
        return DateUtils.formatXSDDateTime(this.cursorExpires);
    }

    public void setCursorExpires(Date cursorExpires) {
        this.cursorExpires = cursorExpires;
    }

    public Ext getExt() {
        return this.ext;
    }

    public void setExt(Ext ext) {
        this.ext = ext;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    public String getMessageRef() {
        return this.messageRef;
    }

    public void setMessageRef(String messageRef) {
        this.messageRef = messageRef;
    }

    public StatusCode getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(StatusCode statusCode) {
        this.statusCode = statusCode;
    }

    public String getSystem() {
        return this.system;
    }

    public void setSystem(String system) {
        this.system = system;
    }

    public String getVersion() {
        return this.version;
    }
}

