/*
 * Decompiled with CFR 0.152.
 */
package com.ttv.SCTE130.messages.cis;

import com.ttv.SCTE130.SCTE130Namespaces;
import com.ttv.SCTE130.messages.MessageInterface;
import com.ttv.SCTE130.utils.SCTE130Utils;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import org.w3c.dom.Element;

public class Cursor
implements MessageInterface {
    private String cursorRef = null;
    private String contentQueryRef = null;
    private int startIndex;
    private int count;
    public static final String ELE_CURSOR = "Cursor";
    private static final String ATTR_START_INDEX = "startIndex";
    private static final String ATTR_COUNT = "count";
    private static final String ATTR_CURSOR_REF = "cursorRef";
    private static final String ATTR_CONTENT_QUERY_REF = "contentQueryRef";

    public Cursor(Element element) throws Exception {
        String remoteStartIndex = element.getAttribute(ATTR_START_INDEX);
        String remoteCount = element.getAttribute(ATTR_COUNT);
        if (remoteStartIndex != null && remoteStartIndex.length() != 0) {
            this.startIndex = Integer.parseInt(remoteStartIndex);
        }
        if (remoteCount != null && remoteCount.length() != 0) {
            this.count = Integer.parseInt(remoteCount);
        }
        this.cursorRef = element.getAttribute(ATTR_CURSOR_REF);
        this.contentQueryRef = element.getAttribute(ATTR_CONTENT_QUERY_REF);
    }

    public Cursor() {
    }

    public Cursor(int startIndex, int count, String cursorRef, String contentQueryRef) {
        this.startIndex = startIndex;
        this.count = count;
        this.cursorRef = cursorRef;
        this.contentQueryRef = contentQueryRef;
    }

    public boolean equals(MessageInterface obj) {
        Cursor other = (Cursor)obj;
        SCTE130Utils dUtils = SCTE130Utils.getInstance();
        if (this.getStartIndex() != other.getStartIndex()) {
            dUtils.devLog("Cursor equality check failed. Start Indexes don't match.");
            return false;
        }
        if (this.getCount() != other.getCount()) {
            dUtils.devLog("Cursor equality check failed. Counts don't match.");
            return false;
        }
        if (!SCTE130Utils.stringsEqual(this.getCursorRef(), other.getCursorRef())) {
            dUtils.devLog("Cursor equality check failed. Cursor references don't match.");
            return false;
        }
        if (!SCTE130Utils.stringsEqual(this.getContentQueryRef(), other.getContentQueryRef())) {
            dUtils.devLog("Cursor equality check failed. Content Query Refs don't match.");
            return false;
        }
        return true;
    }

    public SOAPElement getSOAPElement() throws SOAPException {
        SCTE130Namespaces nameSpaces = SCTE130Namespaces.getInstance();
        SOAPFactory factory = SOAPFactory.newInstance();
        SOAPElement filterElement = factory.createElement(ELE_CURSOR, "cis", nameSpaces.getURIForName("cis"));
        nameSpaces.populateNamespace(filterElement, "cis");
        filterElement.setAttribute(ATTR_CURSOR_REF, this.getCursorRef());
        filterElement.setAttribute(ATTR_CONTENT_QUERY_REF, this.getContentQueryRef());
        filterElement.setAttribute(ATTR_START_INDEX, this.getStartIndexAsStr());
        filterElement.setAttribute(ATTR_COUNT, this.getCountAsStr());
        return filterElement;
    }

    public String getContentQueryRef() {
        return this.contentQueryRef;
    }

    public void setContentQueryRef(String contentQueryRef) {
        this.contentQueryRef = contentQueryRef;
    }

    public int getCount() {
        return this.count;
    }

    public String getCountAsStr() {
        return "" + this.count;
    }

    public String getCursorRef() {
        return this.cursorRef;
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public String getStartIndexAsStr() {
        return "" + this.startIndex;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public void setCursorId(String cursorRef) {
        this.cursorRef = cursorRef;
    }

    public void setStartIndex(int startIndex) {
        this.startIndex = startIndex;
    }
}

