/*
 * Decompiled with CFR 0.152.
 */
package com.ttv.SCTE130.messages.cis;

import com.ttv.SCTE130.SCTE130MessageFactory;
import com.ttv.SCTE130.SCTE130MessageFactoryLocator;
import com.ttv.SCTE130.SCTE130Namespaces;
import com.ttv.SCTE130.messages.MessageInterface;
import com.ttv.SCTE130.messages.cis.AdvancedFilterElement;
import com.ttv.SCTE130.messages.cis.FilterElement;
import com.ttv.SCTE130.utils.SCTE130Utils;
import java.util.ArrayList;
import java.util.List;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryFilter
implements MessageInterface {
    private String op = null;
    private List<FilterElement> filterElements = null;
    private List<AdvancedFilterElement> advancedFilterElements = null;
    public static final String ELE_QUERY_FILTER = "QueryFilter";
    private static final String ATTR_OP = "op";
    public static final String INCLUDE = "include";
    public static final String EXCLUDE = "exclude";

    public QueryFilter(Element element) throws Exception {
        String remoteOp = element.getAttribute(ATTR_OP);
        if (remoteOp != null && remoteOp.length() > 0) {
            this.op = remoteOp;
        }
        NodeList list = element.getChildNodes();
        for (int indx = 0; indx < list.getLength(); ++indx) {
            Node node = list.item(indx);
            if (!(node instanceof Element)) continue;
            Element child = (Element)node;
            SCTE130MessageFactory factory = SCTE130MessageFactoryLocator.getMessageFactory(child);
            Object obj = factory.allocateSCTE130Message(child);
            if (obj instanceof FilterElement) {
                if (this.filterElements == null) {
                    this.filterElements = new ArrayList<FilterElement>();
                }
                this.filterElements.add((FilterElement)obj);
            }
            if (!(obj instanceof AdvancedFilterElement)) continue;
            if (this.advancedFilterElements == null) {
                this.advancedFilterElements = new ArrayList<AdvancedFilterElement>();
            }
            this.advancedFilterElements.add((AdvancedFilterElement)obj);
        }
    }

    public QueryFilter() {
    }

    public QueryFilter(String op, List<FilterElement> filterElements) {
        this.op = op;
        this.filterElements = filterElements;
    }

    public QueryFilter(String op, List<AdvancedFilterElement> advancedFilterElements, boolean noOp) {
        this.op = op;
        this.advancedFilterElements = advancedFilterElements;
    }

    @Override
    public boolean equals(MessageInterface obj) {
        QueryFilter other = (QueryFilter)obj;
        SCTE130Utils dUtils = SCTE130Utils.getInstance();
        if (!SCTE130Utils.stringsEqual(this.getOp(), other.getOp())) {
            dUtils.devLog("QueryFilter equality check failed. Ops don't match.");
            return false;
        }
        if (!SCTE130Utils.listsEqual(this.getFilterElements(), other.getFilterElements())) {
            dUtils.devLog("QueryFilter equality check failed. FilterElements don't match.");
            return false;
        }
        if (!SCTE130Utils.listsEqual(this.getAdvancedFilterElements(), other.getAdvancedFilterElements())) {
            dUtils.devLog("QueryFilter equality check failed. AdvancedFilterElements don't match.");
            return false;
        }
        return true;
    }

    @Override
    public SOAPElement getSOAPElement() throws SOAPException {
        SCTE130Namespaces nameSpaces = SCTE130Namespaces.getInstance();
        SOAPFactory factory = SOAPFactory.newInstance();
        SOAPElement queryFilter = factory.createElement(ELE_QUERY_FILTER, "cis", nameSpaces.getURIForName("cis"));
        nameSpaces.populateNamespace(queryFilter, "cis");
        queryFilter.setAttribute(ATTR_OP, this.getOp());
        SCTE130Utils.addChildElementList(queryFilter, this.getFilterElements());
        SCTE130Utils.addChildElementList(queryFilter, this.getAdvancedFilterElements());
        return queryFilter;
    }

    public List<FilterElement> getFilterElements() {
        return this.filterElements;
    }

    public String getOp() {
        return this.op;
    }

    public List<AdvancedFilterElement> getAdvancedFilterElements() {
        return this.advancedFilterElements;
    }

    public void setAdvancedFilterElements(List<AdvancedFilterElement> advancedFilterElements) {
        this.advancedFilterElements = advancedFilterElements;
    }

    public void setFilterElements(List<FilterElement> filterElements) {
        this.filterElements = filterElements;
    }

    public void setOp(String op) {
        this.op = op;
    }
}

