/*
 * Decompiled with CFR 0.152.
 */
package com.ttv.SCTE130.messages.core;

import com.ttv.SCTE130.SCTE130Namespaces;
import com.ttv.SCTE130.messages.MessageInterface;
import com.ttv.SCTE130.utils.SCTE130Utils;
import java.util.TreeMap;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class Address
implements MessageInterface {
    private String URL = null;
    private String type = null;
    private TreeMap<String, String> anyAttributes = new TreeMap();
    public static final String ELE_ADDRESS = "Address";
    private static final String ATTR_TYPE = "type";
    private String[] namedAttributes = new String[]{"type"};
    public static final String ADDRESS_TYPE_SOAP = "SOAP";
    public static final String ADDRESS_TYPE_HTTP = "HTTP";
    public static final String ADDRESS_TYPE_SOCKET = "SOCKET";

    public Address(Element element) {
        this.type = element.getAttribute(ATTR_TYPE);
        this.anyAttributes = SCTE130Utils.locateOtherAttributes(this.namedAttributes, element.getAttributes());
        NodeList list = element.getChildNodes();
        for (int indx = 0; indx < list.getLength(); ++indx) {
            Node node = list.item(indx);
            if (!(node instanceof Text)) continue;
            this.URL = ((Text)node).getData();
        }
    }

    public Address() {
    }

    public Address(String URL2, String type) {
        this.URL = URL2;
        this.type = type;
    }

    public boolean equals(MessageInterface obj) {
        Address other = (Address)obj;
        SCTE130Utils dUtils = SCTE130Utils.getInstance();
        if (!SCTE130Utils.stringsEqual(other.getURL(), this.getURL())) {
            dUtils.devLog("Address equality check failed. URLs don't match.");
            return false;
        }
        if (!SCTE130Utils.stringsEqual(other.getType(), this.getType())) {
            dUtils.devLog("Address equality check failed. Types don't match.");
            return false;
        }
        return true;
    }

    public SOAPElement getSOAPElement() throws SOAPException {
        SCTE130Namespaces nameSpaces = SCTE130Namespaces.getInstance();
        SOAPFactory factory = SOAPFactory.newInstance();
        SOAPElement addr = factory.createElement(ELE_ADDRESS, "core", nameSpaces.getURIForName("core"));
        nameSpaces.populateNamespace(addr, "core");
        addr.addTextNode(this.getURL());
        SCTE130Utils.setAttribute(addr, ATTR_TYPE, this.getType());
        SCTE130Utils.addOtherAttributes(addr, this.anyAttributes);
        return addr;
    }

    public void addAnyAttribute(String attributeName, String attributeValue) {
        this.anyAttributes.put(attributeName, attributeValue);
    }

    public void setURL(String url) {
        this.URL = url;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getURL() {
        return this.URL;
    }

    public String getType() {
        return this.type;
    }
}

