/*
 * Decompiled with CFR 0.152.
 */
package com.ttv.SCTE130.messages.core;

import com.ttv.SCTE130.SCTE130Namespaces;
import com.ttv.SCTE130.messages.MessageInterface;
import com.ttv.SCTE130.utils.SCTE130Utils;
import java.util.TreeMap;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class ContentDataModel
implements MessageInterface {
    private String type = null;
    private String URL = null;
    private TreeMap<String, String> anyAttributes = new TreeMap();
    public static final String ELE_CONTENT_DATA_MODEL = "ContentDataModel";
    private static final String ATTR_TYPE = "type";
    private String[] namedAttributes = new String[]{"type"};
    public static final String CLADI_11 = "CLADI_1.1";
    public static final String CLADI_20 = "CLADI_2.0";
    public static final String SCTE_2021 = "SCTE2021";
    public static final String CLADI_11_URL = "http://www.cablelabs.com/<date>/ADI1.1";
    public static final String CLADI_20_URL = "http://www.cablelabs.com/<date>/ADI2.0";
    public static final String SCTE_2021_URL = "http://www.scte.org/schemas/2021/2007";

    public ContentDataModel(Element element) throws Exception {
        this.type = element.getAttribute(ATTR_TYPE);
        this.anyAttributes = SCTE130Utils.locateOtherAttributes(this.namedAttributes, element.getAttributes());
        NodeList list = element.getChildNodes();
        for (int indx = 0; indx < list.getLength(); ++indx) {
            Node node = list.item(indx);
            if (!(node instanceof Text)) continue;
            this.URL = ((Text)node).getData();
        }
    }

    public ContentDataModel() {
    }

    public ContentDataModel(String type, String URL2) {
        this.type = type;
        this.URL = URL2;
    }

    public boolean equals(MessageInterface obj) {
        ContentDataModel other = (ContentDataModel)obj;
        SCTE130Utils dUtils = SCTE130Utils.getInstance();
        if (!SCTE130Utils.stringsEqual(this.getType(), other.getType())) {
            dUtils.devLog("ContentDataModel equality check failed. Types don't match.");
            return false;
        }
        if (!SCTE130Utils.stringsEqual(this.getURL(), other.getURL())) {
            dUtils.devLog("ContentDataModel equality check failed. URLs don't match.");
            return false;
        }
        return true;
    }

    public SOAPElement getSOAPElement() throws SOAPException {
        SCTE130Namespaces nameSpaces = SCTE130Namespaces.getInstance();
        SOAPFactory factory = SOAPFactory.newInstance();
        SOAPElement mod = factory.createElement(ELE_CONTENT_DATA_MODEL, "core", nameSpaces.getURIForName("core"));
        nameSpaces.populateNamespace(mod, "core");
        SCTE130Utils.setAttribute(mod, ATTR_TYPE, this.getType());
        SCTE130Utils.addOtherAttributes(mod, this.anyAttributes);
        mod.addTextNode(this.getURL());
        return mod;
    }

    public void addAnyAttribute(String attributeName, String attributeValue) {
        this.anyAttributes.put(attributeName, attributeValue);
    }

    public String getURL() {
        return this.URL;
    }

    public void setURL(String URL2) {
        this.URL = URL2;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }
}

