/*
 * Decompiled with CFR 0.152.
 */
package com.ttv.SCTE130.messages.core;

import com.ttv.SCTE130.SCTE130Namespaces;
import com.ttv.SCTE130.messages.MessageInterface;
import com.ttv.SCTE130.utils.SCTE130Utils;
import java.util.TreeMap;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class ContentLocation
implements MessageInterface {
    private String location = null;
    private boolean mediaAvailable = false;
    private TreeMap<String, String> anyAttributes = new TreeMap();
    public static final String ELE_CONTENT_LOCATION = "ContentLocation";
    private static final String ATTR_MEDIA_AVAILABLE = "mediaAvailable";
    private String[] namedAttributes = new String[]{"mediaAvailable"};

    public ContentLocation(Element element) {
        String remoteMediaAvailable = element.getAttribute(ATTR_MEDIA_AVAILABLE);
        if (remoteMediaAvailable != null && remoteMediaAvailable.length() > 0) {
            this.mediaAvailable = Boolean.parseBoolean(remoteMediaAvailable);
        }
        this.anyAttributes = SCTE130Utils.locateOtherAttributes(this.namedAttributes, element.getAttributes());
        NodeList list = element.getChildNodes();
        for (int indx = 0; indx < list.getLength(); ++indx) {
            Node node = list.item(indx);
            if (!(node instanceof Text)) continue;
            this.location = ((Text)node).getData();
        }
    }

    public ContentLocation() {
    }

    public ContentLocation(String location, boolean mediaAvailable) {
        this.location = location;
        this.mediaAvailable = mediaAvailable;
    }

    public boolean equals(MessageInterface obj) {
        ContentLocation other = (ContentLocation)obj;
        SCTE130Utils dUtils = SCTE130Utils.getInstance();
        if (!SCTE130Utils.stringsEqual(other.getLocation(), this.getLocation())) {
            dUtils.devLog("ContentLocation equality check failed. Locations don't match.");
            return false;
        }
        if (this.isMediaAvailable() != other.isMediaAvailable()) {
            dUtils.devLog("ContentLocation equality check failed. MediaAvailable flags don't match.");
            return false;
        }
        return true;
    }

    public SOAPElement getSOAPElement() throws SOAPException {
        SCTE130Namespaces nameSpaces = SCTE130Namespaces.getInstance();
        SOAPFactory factory = SOAPFactory.newInstance();
        SOAPElement contentLoc = factory.createElement(ELE_CONTENT_LOCATION, "core", nameSpaces.getURIForName("core"));
        nameSpaces.populateNamespace(contentLoc, "core");
        SCTE130Utils.setAttribute(contentLoc, ATTR_MEDIA_AVAILABLE, Boolean.toString(this.isMediaAvailable()));
        SCTE130Utils.addOtherAttributes(contentLoc, this.anyAttributes);
        contentLoc.addTextNode(this.getLocation());
        return contentLoc;
    }

    public void addAnyAttribute(String attributeName, String attributeValue) {
        this.anyAttributes.put(attributeName, attributeValue);
    }

    public boolean isMediaAvailable() {
        return this.mediaAvailable;
    }

    public void setMediaAvailable(boolean mediaAvailable) {
        this.mediaAvailable = mediaAvailable;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }
}

