/*
 * Decompiled with CFR 0.152.
 */
package com.ttv.SCTE130.messages.core;

import com.ttv.SCTE130.SCTE130Namespaces;
import com.ttv.SCTE130.messages.MessageInterface;
import com.ttv.SCTE130.utils.DateUtils;
import com.ttv.SCTE130.utils.SCTE130Utils;
import java.util.Date;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class CurrentDateTime
implements MessageInterface {
    private Date time = null;
    public static final String ELE_CURRENT_DATE_TIME = "CurrentDateTime";

    public CurrentDateTime(Element element) throws Exception {
        String remoteTime = null;
        NodeList list = element.getChildNodes();
        for (int indx = 0; indx < list.getLength(); ++indx) {
            Node node = list.item(indx);
            if (!(node instanceof Text) || (remoteTime = ((Text)node).getData()) == null || remoteTime.length() <= 0) continue;
            this.time = DateUtils.parseXSDDateTime(remoteTime);
        }
    }

    public CurrentDateTime() {
    }

    public CurrentDateTime(Date time) {
        this.time = time;
    }

    public boolean equals(MessageInterface obj) {
        CurrentDateTime other = (CurrentDateTime)obj;
        SCTE130Utils dUtils = SCTE130Utils.getInstance();
        if (other.getTime().compareTo(this.getTime()) != 0) {
            dUtils.devLog("CurrentDateTime equality check failed. Dates don't match.");
            return false;
        }
        return true;
    }

    public SOAPElement getSOAPElement() throws SOAPException {
        SCTE130Namespaces nameSpaces = SCTE130Namespaces.getInstance();
        SOAPFactory factory = SOAPFactory.newInstance();
        SOAPElement addr = factory.createElement(ELE_CURRENT_DATE_TIME, "core", nameSpaces.getURIForName("core"));
        nameSpaces.populateNamespace(addr, "core");
        addr.addTextNode(this.getTimeAsStr());
        return addr;
    }

    public Date getTime() {
        return this.time;
    }

    public String getTimeAsStr() {
        return DateUtils.formatXSDDateTime(this.time);
    }

    public void setTime(Date time) {
        this.time = time;
    }
}

