/*
 * Decompiled with CFR 0.152.
 */
package com.ttv.SCTE130.messages.core;

import com.ttv.SCTE130.SCTE130Namespaces;
import com.ttv.SCTE130.messages.MessageInterface;
import com.ttv.SCTE130.messages.core.CurrentDateTime;
import com.ttv.SCTE130.utils.DateUtils;
import com.ttv.SCTE130.utils.SCTE130Utils;
import java.util.TreeMap;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import org.w3c.dom.Element;

public class Program
implements MessageInterface {
    private int uniqueProgramId;
    private CurrentDateTime referenceDateTime = null;
    private TreeMap<String, String> anyAttributes = new TreeMap();
    public static final String ELE_PROGRAM = "Program";
    private static final String ATTR_UNIQUE_PROGRAM_ID = "uniqueProgramID";
    private static final String ATTR_REFERENCE_DATE_TIME = "referenceDateTime";
    private String[] namedAttributes = new String[]{"uniqueProgramID", "referenceDateTime"};

    public Program(Element element) {
        String remoteReferenceDateTime = element.getAttribute(ATTR_REFERENCE_DATE_TIME);
        String remoteUniqueProgramId = element.getAttribute(ATTR_UNIQUE_PROGRAM_ID);
        if (remoteUniqueProgramId != null && remoteUniqueProgramId.length() > 0) {
            this.uniqueProgramId = Integer.parseInt(remoteUniqueProgramId);
        }
        if (remoteReferenceDateTime != null) {
            try {
                this.referenceDateTime = new CurrentDateTime(DateUtils.parseXSDDateTime(remoteReferenceDateTime));
            }
            catch (Exception e) {
                SCTE130Utils.getInstance().devLog("Failed to create ReferenceDateTime from string: " + remoteReferenceDateTime);
            }
        }
        this.anyAttributes = SCTE130Utils.locateOtherAttributes(this.namedAttributes, element.getAttributes());
    }

    public Program() {
    }

    public Program(int uniqueProgramId, CurrentDateTime referenceDateTime) {
        this.uniqueProgramId = uniqueProgramId;
        this.referenceDateTime = referenceDateTime;
    }

    public boolean equals(MessageInterface obj) {
        Program other = (Program)obj;
        SCTE130Utils dUtils = SCTE130Utils.getInstance();
        if (!SCTE130Utils.stringsEqual(other.getUniqueProgramIdAsStr(), this.getUniqueProgramIdAsStr())) {
            dUtils.devLog("Program equality check failed. UniqueProgramIds don't match.");
            return false;
        }
        if (!SCTE130Utils.objectsEqual(other.getReferenceDateTime(), this.getReferenceDateTime())) {
            dUtils.devLog("Program equality check failed. ReferenceDateTimes don't match.");
            return false;
        }
        return true;
    }

    public SOAPElement getSOAPElement() throws SOAPException {
        SCTE130Namespaces nameSpaces = SCTE130Namespaces.getInstance();
        SOAPFactory factory = SOAPFactory.newInstance();
        SOAPElement program = factory.createElement(ELE_PROGRAM, "core", nameSpaces.getURIForName("core"));
        nameSpaces.populateNamespace(program, "core");
        SCTE130Utils.setAttribute(program, ATTR_UNIQUE_PROGRAM_ID, this.getUniqueProgramIdAsStr());
        SCTE130Utils.setAttribute(program, ATTR_REFERENCE_DATE_TIME, this.getReferenceDateTime().getTimeAsStr());
        SCTE130Utils.addOtherAttributes(program, this.anyAttributes);
        return program;
    }

    public void addAnyAttribute(String attributeName, String attributeValue) {
        this.anyAttributes.put(attributeName, attributeValue);
    }

    public CurrentDateTime getReferenceDateTime() {
        return this.referenceDateTime;
    }

    public void setReferenceDateTime(CurrentDateTime referenceDateTime) {
        this.referenceDateTime = referenceDateTime;
    }

    public int getUniqueProgramId() {
        return this.uniqueProgramId;
    }

    public String getUniqueProgramIdAsStr() {
        return "" + this.uniqueProgramId;
    }

    public void setUniqueProgramId(int uniqueProgramId) {
        this.uniqueProgramId = uniqueProgramId;
    }
}

