/*
 * Decompiled with CFR 0.152.
 */
package com.ttv.SCTE130.messages.core;

import com.ttv.SCTE130.SCTE130Namespaces;
import com.ttv.SCTE130.messages.MessageInterface;
import com.ttv.SCTE130.utils.DateUtils;
import com.ttv.SCTE130.utils.SCTE130Utils;
import java.util.Date;
import java.util.TreeMap;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class SegmentationUpid
implements MessageInterface {
    private int type;
    private int length;
    private int eventID;
    private int typeID;
    private int segmentNum;
    private int segmentCounts;
    private TreeMap<String, String> anyAttributes = new TreeMap();
    private String upid = null;
    private Date referenceDateTime = null;
    public static final String ELE_SEGMENTATION_UPID = "SegmentationUpid";
    private static final String ATTR_TYPE = "type";
    private static final String ATTR_LENGTH = "length";
    private static final String ATTR_EVENT_ID = "eventID";
    private static final String ATTR_TYPE_ID = "typeID";
    private static final String ATTR_SEGMENT_NUM = "segmentNum";
    private static final String ATTR_SEGMENT_COUNT = "segmentCounts";
    private static final String ATTR_REFERENCE_DATE = "referenceDateTime";
    private String[] namedAttributes = new String[]{"type", "length", "eventID", "typeID", "segmentNum", "segmentCounts", "referenceDateTime"};

    public SegmentationUpid(Element element) {
        String remoteType = element.getAttribute(ATTR_TYPE);
        String remoteLength = element.getAttribute(ATTR_LENGTH);
        String remoteEventID = element.getAttribute(ATTR_EVENT_ID);
        String remoteTypeID = element.getAttribute(ATTR_TYPE_ID);
        String remoteSegmentNum = element.getAttribute(ATTR_SEGMENT_NUM);
        String remoteSegmentCount = element.getAttribute(ATTR_SEGMENT_COUNT);
        String remoteReferenceDate = element.getAttribute(ATTR_REFERENCE_DATE);
        if (remoteSegmentCount != null && remoteSegmentCount.length() > 0) {
            this.segmentCounts = Integer.parseInt(remoteSegmentCount);
        }
        if (remoteSegmentNum != null && remoteSegmentNum.length() > 0) {
            this.segmentNum = Integer.parseInt(remoteSegmentNum);
        }
        if (remoteType != null && remoteType.length() > 0) {
            this.type = Integer.parseInt(remoteType);
        }
        if (remoteLength != null && remoteLength.length() > 0) {
            this.length = Integer.parseInt(remoteLength);
        }
        if (remoteEventID != null && remoteEventID.length() > 0) {
            this.eventID = Integer.parseInt(remoteEventID);
        }
        if (remoteTypeID != null && remoteTypeID.length() > 0) {
            this.typeID = Integer.parseInt(remoteTypeID);
        }
        try {
            if (remoteReferenceDate != null && remoteReferenceDate.length() > 0) {
                this.referenceDateTime = DateUtils.parseXSDDateTime(remoteReferenceDate);
            }
        }
        catch (Exception e) {
            SCTE130Utils.getInstance().devLog("Failed to parse referenceDateTime in SegmentationUPID.");
        }
        this.anyAttributes = SCTE130Utils.locateOtherAttributes(this.namedAttributes, element.getAttributes());
        NodeList list = element.getChildNodes();
        for (int indx = 0; indx < list.getLength(); ++indx) {
            Node node = list.item(indx);
            if (!(node instanceof Text)) continue;
            this.upid = ((Text)node).getData();
        }
    }

    public SegmentationUpid() {
    }

    public SegmentationUpid(String upid, int type, int length, int eventID, int typeID, int segmentNum, int segmentCounts, Date referenceDateTime) {
        this.upid = upid;
        this.type = type;
        this.length = length;
        this.eventID = eventID;
        this.typeID = typeID;
        this.segmentNum = segmentNum;
        this.segmentCounts = segmentCounts;
        this.referenceDateTime = referenceDateTime;
    }

    public boolean equals(MessageInterface obj) {
        SegmentationUpid other = (SegmentationUpid)obj;
        SCTE130Utils dUtils = SCTE130Utils.getInstance();
        if (!SCTE130Utils.stringsEqual(this.getUpid(), other.getUpid())) {
            dUtils.devLog("SegmentationUpid equality check failed. UPIDS don't match.");
            return false;
        }
        if (other.getType() != this.getType()) {
            dUtils.devLog("SegmentationUpid equality check failed. Types don't match.");
            return false;
        }
        if (other.getLength() != this.getLength()) {
            dUtils.devLog("SegmentationUpid equality check failed. Lengths don't match.");
            return false;
        }
        if (other.getEventID() != this.getEventID()) {
            dUtils.devLog("SegmentationUpid equality check failed. EventIDs don't match.");
            return false;
        }
        if (other.getTypeID() != this.getTypeID()) {
            dUtils.devLog("SegmentationUpid equality check failed. TypeIDs don't match.");
            return false;
        }
        if (other.getSegmentNum() != this.getSegmentNum()) {
            dUtils.devLog("SegmentationUpid equality check failed. Segment nums don't match.");
            return false;
        }
        if (other.getSegmentCounts() != this.getSegmentCounts()) {
            dUtils.devLog("SegmentationUpid equality check failed. Segment Counts don't match.");
            return false;
        }
        if (this.getReferenceDateTime().compareTo(other.getReferenceDateTime()) != 0) {
            dUtils.devLog("SegmentationUpid equality check failed. ReferenceDateTimes don't match.");
            return false;
        }
        return true;
    }

    public SOAPElement getSOAPElement() throws SOAPException {
        SCTE130Namespaces nameSpaces = SCTE130Namespaces.getInstance();
        SOAPFactory factory = SOAPFactory.newInstance();
        SOAPElement segUpid = factory.createElement(ELE_SEGMENTATION_UPID, "core", nameSpaces.getURIForName("core"));
        nameSpaces.populateNamespace(segUpid, "core");
        segUpid.addTextNode(this.getUpid());
        SCTE130Utils.setAttribute(segUpid, ATTR_TYPE, this.getTypeAsStr());
        SCTE130Utils.setAttribute(segUpid, ATTR_LENGTH, this.getLengthAsStr());
        SCTE130Utils.setAttribute(segUpid, ATTR_EVENT_ID, this.getEventIDAsStr());
        SCTE130Utils.setAttribute(segUpid, ATTR_TYPE_ID, this.getTypeIDAsStr());
        SCTE130Utils.setAttribute(segUpid, ATTR_SEGMENT_NUM, this.getSegmentNumAsStr());
        SCTE130Utils.setAttribute(segUpid, ATTR_SEGMENT_COUNT, this.getSegmentCountsAsStr());
        SCTE130Utils.setAttribute(segUpid, ATTR_REFERENCE_DATE, this.getReferenceDateTimeAsStr());
        SCTE130Utils.addOtherAttributes(segUpid, this.anyAttributes);
        return segUpid;
    }

    public void addAnyAttribute(String attributeName, String attributeValue) {
        this.anyAttributes.put(attributeName, attributeValue);
    }

    public Date getReferenceDateTime() {
        return this.referenceDateTime;
    }

    public String getReferenceDateTimeAsStr() {
        return DateUtils.formatXSDDateTime(this.referenceDateTime);
    }

    public void setReferenceDateTime(Date referenceDateTime) {
        this.referenceDateTime = referenceDateTime;
    }

    public int getSegmentNum() {
        return this.segmentNum;
    }

    public int getSegmentCounts() {
        return this.segmentCounts;
    }

    public int getEventID() {
        return this.eventID;
    }

    public int getLength() {
        return this.length;
    }

    public int getType() {
        return this.type;
    }

    public int getTypeID() {
        return this.typeID;
    }

    public String getUpid() {
        return this.upid;
    }

    public String getSegmentNumAsStr() {
        return "" + this.segmentNum;
    }

    public String getSegmentCountsAsStr() {
        return "" + this.segmentCounts;
    }

    public String getEventIDAsStr() {
        return "" + this.eventID;
    }

    public String getLengthAsStr() {
        return "" + this.length;
    }

    public String getTypeAsStr() {
        return "" + this.type;
    }

    public String getTypeIDAsStr() {
        return "" + this.typeID;
    }

    public void setSegmentNum(int segmentNum) {
        this.segmentNum = segmentNum;
    }

    public void setSegmentCounts(int segmentCounts) {
        this.segmentCounts = segmentCounts;
    }

    public void setEventID(int eventID) {
        this.eventID = eventID;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public void setType(int type) {
        this.type = type;
    }

    public void setTypeID(int typeID) {
        this.typeID = typeID;
    }

    public void setUpid(String upid) {
        this.upid = upid;
    }
}

