/*
 * Decompiled with CFR 0.152.
 */
package com.ttv.SCTE130.messages.core;

import com.ttv.SCTE130.SCTE130MessageFactory;
import com.ttv.SCTE130.SCTE130MessageFactoryLocator;
import com.ttv.SCTE130.SCTE130Namespaces;
import com.ttv.SCTE130.messages.MessageInterface;
import com.ttv.SCTE130.messages.TopLevelMessage;
import com.ttv.SCTE130.messages.core.Ext;
import com.ttv.SCTE130.messages.core.InitiatorData;
import com.ttv.SCTE130.utils.SCTE130Utils;
import java.util.TreeMap;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ServiceCheckRequest
implements MessageInterface,
TopLevelMessage {
    private String messageId = null;
    private String version = "1.0";
    private String identity = null;
    private String system = null;
    private String resend = null;
    private TreeMap<String, String> anyAttributes = new TreeMap();
    private InitiatorData initData = null;
    private Ext ext = null;
    public static final String ELE_SERVICE_CHECK_REQUEST = "ServiceCheckRequest";
    private static final String ATTR_MESSAGE_ID = "messageId";
    private static final String ATTR_VERSION = "version";
    private static final String ATTR_IDENTITY = "identity";
    private static final String ATTR_SYSTEM = "system";
    private static final String ATTR_RESEND = "resend";
    private String[] namedAttributes = new String[]{"messageId", "version", "identity", "system", "resend"};

    public ServiceCheckRequest(Element element) throws Exception {
        this.messageId = element.getAttribute(ATTR_MESSAGE_ID);
        this.identity = element.getAttribute(ATTR_IDENTITY);
        this.system = element.getAttribute(ATTR_SYSTEM);
        this.resend = element.getAttribute(ATTR_RESEND);
        this.anyAttributes = SCTE130Utils.locateOtherAttributes(this.namedAttributes, element.getAttributes());
        NodeList list = element.getChildNodes();
        for (int indx = 0; indx < list.getLength(); ++indx) {
            Node node = list.item(indx);
            if (!(node instanceof Element)) continue;
            Element child = (Element)node;
            SCTE130MessageFactory factory = SCTE130MessageFactoryLocator.getMessageFactory(child);
            Object obj = factory.allocateSCTE130Message(child);
            if (obj instanceof InitiatorData) {
                this.initData = (InitiatorData)obj;
            }
            if (!(obj instanceof Ext)) continue;
            this.ext = (Ext)obj;
        }
    }

    public ServiceCheckRequest() {
    }

    public ServiceCheckRequest(String messageId, String identity, String system, Ext ext) {
        this.messageId = messageId;
        this.identity = identity;
        this.system = system;
    }

    public boolean equals(MessageInterface obj) {
        ServiceCheckRequest other = (ServiceCheckRequest)obj;
        SCTE130Utils dUtils = SCTE130Utils.getInstance();
        if (!SCTE130Utils.stringsEqual(this.getMessageId(), other.getMessageId())) {
            dUtils.devLog("ServiceCheckRequest equality check failed. Ids don't match.");
            return false;
        }
        if (!SCTE130Utils.stringsEqual(this.getIdentity(), other.getIdentity())) {
            dUtils.devLog("ServiceCheckRequest equality check failed. Identities don't match.");
            return false;
        }
        if (!SCTE130Utils.stringsEqual(this.getSystem(), other.getSystem())) {
            dUtils.devLog("ServiceCheckRequest equality check failed. Systems don't match.");
            return false;
        }
        if (!SCTE130Utils.stringsEqual(this.getResend(), other.getResend())) {
            dUtils.devLog("ServiceCheckRequest equality check failed. Resends don't match.");
            return false;
        }
        if (!SCTE130Utils.objectsEqual(this.getInitData(), other.getInitData())) {
            dUtils.devLog("ServiceCheckRequest equality check failed. InitiatorData don't match.");
            return false;
        }
        if (!SCTE130Utils.objectsEqual(this.getExt(), other.getExt())) {
            dUtils.devLog("ServiceCheckRequest equality check failed. Exts don't match.");
            return false;
        }
        return true;
    }

    public SOAPElement getSOAPElement() throws SOAPException {
        SCTE130Namespaces nameSpaces = SCTE130Namespaces.getInstance();
        SOAPFactory factory = SOAPFactory.newInstance();
        SOAPElement serviceCheck = factory.createElement(ELE_SERVICE_CHECK_REQUEST, "core", nameSpaces.getURIForName("core"));
        nameSpaces.populateNamespace(serviceCheck, "core");
        SCTE130Utils.setAttribute(serviceCheck, ATTR_MESSAGE_ID, this.getMessageId());
        SCTE130Utils.setAttribute(serviceCheck, ATTR_VERSION, this.getVersion());
        SCTE130Utils.setAttribute(serviceCheck, ATTR_IDENTITY, this.getIdentity());
        SCTE130Utils.setAttribute(serviceCheck, ATTR_SYSTEM, this.getSystem());
        SCTE130Utils.setAttribute(serviceCheck, ATTR_RESEND, this.getResend());
        SCTE130Utils.addOtherAttributes(serviceCheck, this.anyAttributes);
        SCTE130Utils.addChildElement(serviceCheck, this.getInitData());
        SCTE130Utils.addChildElement(serviceCheck, this.getExt());
        return serviceCheck;
    }

    public void addAnyAttribute(String attributeName, String attributeValue) {
        this.anyAttributes.put(attributeName, attributeValue);
    }

    public InitiatorData getInitData() {
        return this.initData;
    }

    public void setInitData(InitiatorData initData) {
        this.initData = initData;
    }

    public String getResend() {
        return this.resend;
    }

    public void setResend(String resend) {
        this.resend = resend;
    }

    public String getIdentity() {
        return this.identity;
    }

    public void setIdentity(String identity) {
        this.identity = identity;
    }

    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    public Ext getExt() {
        return this.ext;
    }

    public void setExt(Ext ext) {
        this.ext = ext;
    }

    public String getSystem() {
        return this.system;
    }

    public String getVersion() {
        return this.version;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public void setId(String messageId) {
        this.messageId = messageId;
    }

    public void setSystem(String system) {
        this.system = system;
    }
}

