/*
 * Decompiled with CFR 0.152.
 */
package com.ttv.SCTE130.messages.core;

import com.ttv.SCTE130.SCTE130MessageFactory;
import com.ttv.SCTE130.SCTE130MessageFactoryLocator;
import com.ttv.SCTE130.SCTE130Namespaces;
import com.ttv.SCTE130.messages.MessageInterface;
import com.ttv.SCTE130.messages.core.ExternalStatusCode;
import com.ttv.SCTE130.messages.core.Note;
import com.ttv.SCTE130.utils.SCTE130Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatusCode
implements MessageInterface {
    private int statusClass;
    private int statusCode;
    private TreeMap<String, String> anyAttributes = new TreeMap();
    private List<Note> notes = null;
    private ExternalStatusCode externalStatusCode = null;
    public static final String ELE_STATUS_CODE = "StatusCode";
    private static final String ATTR_CLASS = "class";
    private static final String ATTR_DETAIL = "detail";
    private String[] namedAttributes = new String[]{"class", "detail"};
    public static final int CLASS_SUCCESS = 0;
    public static final int CLASS_ERROR = 1;
    public static final int CLASS_WARNING = 2;
    public static final int CLASS_INFORMATION = 3;
    public static final int STATUS_CODE_RESERVED = 0;
    public static final int STATUS_CODE_INCOMPLETE_MESSAGE = 1;
    public static final int STATUS_CODE_MESSAGE_VALIDATION_FAILED = 2;
    public static final int STATUS_CODE_REGISTRATION_OVERLAP = 3;
    public static final int STATUS_CODE_QUERY_FAILED = 4;
    public static final int STATUS_CODE_AMBIGUOUS_DETAILS = 5;
    public static final int STATUS_CODE_UNSUPPORTED_PROTOCOL = 6;
    public static final int STATUS_CODE_NETWORK_ADDRESS_DOES_NOT_EXIST = 7;
    public static final int STATUS_CODE_NETWORK_ADDRESS_IN_USE = 8;
    public static final int STATUS_CODE_DUPLICATE_MESSAGE_ID = 9;
    public static final int STATUS_CODE_NETWORK_CONNECTION_LOST = 10;
    public static final int STATUS_CODE_RESOURCE_NOT_FOUND = 11;
    public static final int STATUS_CODE_NOT_SUPPORTED = 12;
    public static final int STATUS_CODE_NOT_AUTHORIZED = 13;
    public static final int STATUS_CODE_UNKNOWN_MESSAGE_REFERENCE = 14;
    public static final int STATUS_CODE_RESEND_FORCED_ABANDONMENT = 15;
    public static final int STATUS_CODE_OUT_OF_RESOURCES = 16;
    public static final int STATUS_CODE_TIMEOUT = 17;
    public static final int STATUS_CODE_PLACEMENT_DURATION_EXCEEDED_REQUEST = 3001;
    public static final int STATUS_CODE_PLACEMENT_DURATION_MISMATCH = 3002;
    public static final int STATUS_CODE_CONTENT_FAILED_ANALYSIS = 3003;
    public static final int STATUS_CODE_ABNORMAL_TERMINATION_OF_PLAYOUT = 3004;
    public static final int STATUS_CODE_ABNORMAL_TERMINATION_BETWEEN_SEGMENTS = 3005;
    public static final int STATUS_CODE_RESUMED_FROM_PAUSE = 3006;
    public static final int STATUS_CODE_SESSION_TERMINATED_ON_PAUSE = 3007;
    public static final int STATUS_CODE_SESSION_TERMINATED_BY_USER = 3008;
    public static final int STATUS_CODE_SESSION_RESOURCE_UNAVAILABLE = 3009;
    public static final int STATUS_CODE_SESSION_INADEQUATE_RESOURCES = 3010;
    public static final int STATUS_CODE_PLACEMENT_TERMINATED = 3011;
    public static final int STATUS_CODE_CURSOR_UNDEFINED = 4001;
    public static final int STATUS_CODE_CURSOR_ALREADY_EXISTS = 4002;

    public StatusCode(Element element) throws Exception {
        String remoteStatusClass = element.getAttribute(ATTR_CLASS);
        String remoteStatusCode = element.getAttribute(ATTR_DETAIL);
        if (remoteStatusClass != null && remoteStatusClass.length() > 0) {
            this.statusClass = Integer.parseInt(remoteStatusClass);
        }
        if (remoteStatusCode != null && remoteStatusCode.length() > 0) {
            this.statusCode = Integer.parseInt(remoteStatusCode);
        }
        this.anyAttributes = SCTE130Utils.locateOtherAttributes(this.namedAttributes, element.getAttributes());
        NodeList list = element.getChildNodes();
        for (int indx = 0; indx < list.getLength(); ++indx) {
            Node node = list.item(indx);
            if (!(node instanceof Element)) continue;
            Element child = (Element)node;
            SCTE130MessageFactory factory = SCTE130MessageFactoryLocator.getMessageFactory(child);
            Object obj = factory.allocateSCTE130Message(child);
            if (obj instanceof Note) {
                if (this.notes == null) {
                    this.notes = new ArrayList<Note>();
                }
                this.notes.add((Note)obj);
            }
            if (!(obj instanceof ExternalStatusCode)) continue;
            this.externalStatusCode = (ExternalStatusCode)obj;
        }
    }

    public StatusCode() {
    }

    public StatusCode(int statusClass, int statusCode, List<Note> notes, ExternalStatusCode externalStatusCode) {
        this.statusClass = statusClass;
        this.statusCode = statusCode;
        this.notes = notes;
        this.externalStatusCode = externalStatusCode;
    }

    @Override
    public boolean equals(MessageInterface obj) {
        StatusCode other = (StatusCode)obj;
        SCTE130Utils dUtils = SCTE130Utils.getInstance();
        if (!SCTE130Utils.stringsEqual(this.getStatusClassAsStr(), other.getStatusClassAsStr())) {
            dUtils.devLog("ExternalStatusCode equality check failed. Classes don't match.");
            return false;
        }
        if (!SCTE130Utils.stringsEqual(this.getStatusCodeAsStr(), other.getStatusCodeAsStr())) {
            dUtils.devLog("ExternalStatusCode equality check failed. Codes don't match.");
            return false;
        }
        if (!SCTE130Utils.listsEqual(this.getNotes(), other.getNotes())) {
            dUtils.devLog("ExternalStatusCode equality check failed. Notes don't match.");
            return false;
        }
        if (!SCTE130Utils.objectsEqual(this.getExternalStatusCode(), other.getExternalStatusCode())) {
            dUtils.devLog("ExternalStatusCode equality check failed. ExternalStatusCodes don't match.");
            return false;
        }
        return true;
    }

    @Override
    public SOAPElement getSOAPElement() throws SOAPException {
        SCTE130Namespaces nameSpaces = SCTE130Namespaces.getInstance();
        SOAPFactory factory = SOAPFactory.newInstance();
        SOAPElement statusCode = factory.createElement(ELE_STATUS_CODE, "core", nameSpaces.getURIForName("core"));
        nameSpaces.populateNamespace(statusCode, "core");
        SCTE130Utils.setAttribute(statusCode, ATTR_CLASS, this.getStatusClassAsStr());
        SCTE130Utils.setAttribute(statusCode, ATTR_DETAIL, this.getStatusCodeAsStr());
        SCTE130Utils.addOtherAttributes(statusCode, this.anyAttributes);
        SCTE130Utils.addChildElementList(statusCode, this.getNotes());
        SCTE130Utils.addChildElement(statusCode, this.getExternalStatusCode());
        return statusCode;
    }

    public void addAnyAttribute(String attributeName, String attributeValue) {
        this.anyAttributes.put(attributeName, attributeValue);
    }

    public ExternalStatusCode getExternalStatusCode() {
        return this.externalStatusCode;
    }

    public void setExternalStatusCode(ExternalStatusCode externalStatusCode) {
        this.externalStatusCode = externalStatusCode;
    }

    public List<Note> getNotes() {
        return this.notes;
    }

    public void setNotes(List<Note> notes) {
        this.notes = notes;
    }

    public String getStatusClassAsStr() {
        return "" + this.statusClass;
    }

    public int getStatusClass() {
        return this.statusClass;
    }

    public void setStatusClass(int statusClass) {
        this.statusClass = statusClass;
    }

    public String getStatusCodeAsStr() {
        return "" + this.statusCode;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(int statusCode) {
        this.statusCode = statusCode;
    }
}

