/*
 * Decompiled with CFR 0.152.
 */
package com.ttv.SCTE130.test;

import com.ttv.SCTE130.SCTE130MessageFactory;
import com.ttv.SCTE130.SCTE130MessageFactoryLocator;
import com.ttv.SCTE130.SCTE130Namespaces;
import com.ttv.SCTE130.client.SCTE130Client;
import com.ttv.SCTE130.messages.adm.Client;
import com.ttv.SCTE130.messages.adm.ContentProvider;
import com.ttv.SCTE130.messages.adm.EffectiveEndDateTime;
import com.ttv.SCTE130.messages.adm.EffectiveStartDateTime;
import com.ttv.SCTE130.messages.adm.Entertainment;
import com.ttv.SCTE130.messages.adm.EntertainmentNPT;
import com.ttv.SCTE130.messages.adm.MaxDuration;
import com.ttv.SCTE130.messages.adm.MaxPlacementCount;
import com.ttv.SCTE130.messages.adm.MinDuration;
import com.ttv.SCTE130.messages.adm.MinPlacementCount;
import com.ttv.SCTE130.messages.adm.OpportunityBinding;
import com.ttv.SCTE130.messages.adm.OpportunityConstraints;
import com.ttv.SCTE130.messages.adm.PlacementControl;
import com.ttv.SCTE130.messages.adm.PlacementDateTime;
import com.ttv.SCTE130.messages.adm.PlacementDecisionOwner;
import com.ttv.SCTE130.messages.adm.PlacementOpportunity;
import com.ttv.SCTE130.messages.adm.PlacementRequest;
import com.ttv.SCTE130.messages.adm.PlacementResponse;
import com.ttv.SCTE130.messages.adm.ProductType;
import com.ttv.SCTE130.messages.adm.Scope;
import com.ttv.SCTE130.messages.adm.Service;
import com.ttv.SCTE130.messages.adm.SystemContext;
import com.ttv.SCTE130.messages.adm.TargetCode;
import com.ttv.SCTE130.messages.adm.TerminalAddress;
import com.ttv.SCTE130.messages.core.AdType;
import com.ttv.SCTE130.messages.core.AssetRef;
import com.ttv.SCTE130.messages.core.Content;
import com.ttv.SCTE130.messages.core.ContentDataModel;
import com.ttv.SCTE130.messages.core.CurrentDateTime;
import com.ttv.SCTE130.messages.core.Duration;
import com.ttv.SCTE130.messages.core.Program;
import com.ttv.SCTE130.messages.core.Tracking;
import java.util.ArrayList;
import java.util.Date;
import java.util.Vector;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import org.w3c.dom.Element;

public class PlacementRequestStressTestMsg {
    public static void main(String[] args) {
        PlacementRequestStressTestMsg prst = new PlacementRequestStressTestMsg();
        prst.test(args);
    }

    public void test(String[] args) {
        Runnable caller;
        int indx;
        SCTE130Client client = new SCTE130Client();
        client.setCallOptions(args);
        client.setDestinationURL("http://10.250.30.22/ADSServer");
        client.setLoginPassword("admin", "administrator");
        int numberOfThreads = Integer.parseInt(args[0]);
        int numberOfCallsPerThread = Integer.parseInt(args[1]);
        Vector<Thread> callers = new Vector<Thread>();
        for (indx = 0; indx < numberOfThreads; ++indx) {
            caller = new Caller(numberOfCallsPerThread, args, client);
            Thread t1 = new Thread(caller);
            callers.add(t1);
            t1.start();
        }
        for (indx = 0; indx < callers.size(); ++indx) {
            caller = (Thread)callers.get(indx);
            try {
                ((Thread)caller).join();
                continue;
            }
            catch (InterruptedException ie) {
                ie.printStackTrace();
            }
        }
        System.out.println("Done.");
    }

    public static PlacementRequest createPlacementRequest(String[] args) throws SOAPException, Exception {
        AssetRef assetRef = new AssetRef(args[2], args[3]);
        ProductType productType = new ProductType("MOD");
        ContentProvider provider = new ContentProvider(args[3], new ContentDataModel("CLADI_1.1", "http://www.cablelabs.com/<date>/ADI1.1"));
        Scope scope = new Scope("Local");
        AdType adType = new AdType("Interstitial");
        PlacementDecisionOwner owner = new PlacementDecisionOwner("Allen Smithy");
        EntertainmentNPT npt = new EntertainmentNPT("0", 1.0);
        Content content = new Content("1", assetRef, new Duration("PT30M"), adType, null, new Tracking("12345"), null);
        Entertainment entertainment = new Entertainment(content, npt, null);
        CurrentDateTime currentDateTime = new CurrentDateTime(new Date());
        ArrayList<TargetCode> targetCodeList = new ArrayList<TargetCode>();
        targetCodeList.add(new TargetCode("30096", "ZipPlus4"));
        TerminalAddress terminalAddress = new TerminalAddress("3c:3c:3c:3c", "MAC");
        Client client = new Client(currentDateTime, targetCodeList, terminalAddress, null);
        Program program = new Program(101, new CurrentDateTime(new Date()));
        ArrayList<Service> serviceList = new ArrayList<Service>();
        serviceList.add(new Service("1", "interactive", "pre-roll", program, adType, provider, productType, owner, scope, null));
        MinPlacementCount minD = new MinPlacementCount(1);
        MaxPlacementCount maxD = new MaxPlacementCount(2);
        SystemContext systemContext = new SystemContext(null, null, null, null, null, null);
        MinDuration minDuration = new MinDuration("PT33S");
        MaxDuration maxDuration = new MaxDuration("PT66S");
        EffectiveStartDateTime start = new EffectiveStartDateTime(new Date());
        EffectiveEndDateTime end = new EffectiveEndDateTime(new Date());
        OpportunityConstraints constraints = new OpportunityConstraints();
        constraints.setAdType(adType);
        constraints.setScope(scope);
        constraints.setMaxDuration(maxDuration);
        constraints.setMinDuration(minDuration);
        ArrayList<PlacementControl> placementControlList = new ArrayList<PlacementControl>();
        placementControlList.add(new PlacementControl("id1", "Fill", 1, content, constraints, new PlacementDateTime(new Date()), null));
        OpportunityBinding oppyBinding1 = new OpportunityBinding("Interstitial", 1, 4);
        OpportunityBinding oppyBinding2 = new OpportunityBinding("Interstitial", 2, 4);
        OpportunityBinding oppyBinding3 = new OpportunityBinding("Interstitial", 3, 4);
        OpportunityBinding oppyBinding4 = new OpportunityBinding("Interstitial", 4, 4);
        ArrayList<PlacementOpportunity> oppies = new ArrayList<PlacementOpportunity>();
        oppies.add(new PlacementOpportunity("id1", "regRef", "localRef", oppyBinding1, constraints, new PlacementDateTime(new Date()), placementControlList, null));
        oppies.add(new PlacementOpportunity("id1", "regRef", "localRef", oppyBinding2, constraints, new PlacementDateTime(new Date()), placementControlList, null));
        oppies.add(new PlacementOpportunity("id1", "regRef", "localRef", oppyBinding3, constraints, new PlacementDateTime(new Date()), placementControlList, null));
        oppies.add(new PlacementOpportunity("id1", "regRef", "localRef", oppyBinding4, constraints, new PlacementDateTime(new Date()), placementControlList, null));
        PlacementRequest pr = new PlacementRequest("id", "identity", "system", false, systemContext, serviceList, entertainment, client, null, oppies, null);
        return pr;
    }

    private class Caller
    implements Runnable {
        private int numberOfCalls = 0;
        private String[] args = null;
        private SCTE130Client client = null;

        public Caller(int numberOfCalls, String[] args, SCTE130Client client) {
            this.numberOfCalls = numberOfCalls;
            this.args = args;
            this.client = client;
        }

        public void run() {
            try {
                PlacementRequest placementRequest = PlacementRequestStressTestMsg.createPlacementRequest(this.args);
                SOAPElement element = placementRequest.getSOAPElement();
                SCTE130Namespaces.getInstance().populateNamespace(element, "adm");
                for (int indx = 0; indx < this.numberOfCalls; ++indx) {
                    long start = System.currentTimeMillis();
                    Element ret = this.client.invoke(element);
                    long end = System.currentTimeMillis();
                    System.out.println("Elapsed time: " + (end - start) + " milliseconds.");
                    SCTE130MessageFactory factory = SCTE130MessageFactoryLocator.getMessageFactory(ret);
                    PlacementResponse messageInstance = (PlacementResponse)factory.allocateSCTE130Message(ret);
                    if (messageInstance.getStatusCode().getStatusClass() == 0) continue;
                    System.out.println("PlacementStatus returned with error condition: " + messageInstance.getStatusCode().getStatusClass());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

